<?php

namespace App\Models\Site\Assessment;

use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;

class SiteAssessmentRoutine extends SiteGlobalModel
{
    protected $table='site_assessment_routines';
    protected $appends = array('assessment_name', 'assessment_type_name');

    const Academic_group_id = 'academic_group_id';
    const Site_assessment_declare_id = 'site_assessment_declare_id';
    const Site_subject_group_condition_setting_id = 'site_subject_group_condition_setting_id';
    const Subject_topic_id = 'subject_topic_id';
    const Assessment_id = 'assessment_id';
    const Assessment_type_id = 'assessment_type_id';
    const Assessment_type_no_id = 'assessment_type_no_id';
    const Assessment_start_date = 'assessment_start_date';
    const Assessment_end_date = 'assessment_end_date';
    const Assessment_start_time = 'assessment_start_time';
    const Assessment_end_time = 'assessment_end_time';
    const Assessment_duration = 'assessment_duration';
    const Per_day_student = 'per_day_student';
    const Site_id = 'site_id';
    const Status = 'status';


    protected $fillable = [
        self::Academic_group_id,
        self::Site_assessment_declare_id,
        self::Site_subject_group_condition_setting_id,
        self::Subject_topic_id,
        self::Assessment_id,
        self::Assessment_type_id,
        self::Assessment_type_no_id,
        self::Assessment_start_date,
        self::Assessment_end_date,
        self::Assessment_start_time,
        self::Assessment_end_time,
        self::Assessment_duration,
        self::Per_day_student,
        self::Site_id,
        self::Status,

    ];


    public function getAssessmentNameAttribute() {

        return  $this->attributes['assessment_name']=  $this->assessment->assessment_name;

    }

    public function getAssessmentTypeNameAttribute() {

        return  $this->attributes['assessment_type_name']=  $this->assessmentType->type_name;

    }

    public function assessment()
    {
        return $this->belongsTo(Assessment::class);

    }


    public function assessmentType()
    {
        return $this->belongsTo(AssessmentType::class);

    }
    public function academicAssessmentTypeNo()
    {
        return $this->belongsTo(AssessmentTypeNo::class);

    }

    public function subjectGroupConditionSetting()
    {
        return $this->belongsTo(SubjectGroupConditionSetting::class, 'site_subject_group_condition_setting_id');

    }

    public function subjectTopic()
    {
        return $this->belongsTo(SiteClassSubjectAssessmentTopic::class, 'subject_topic_id');

    }
}
