<?php

namespace App\Models\Site\Assessment;

use App\Models\Academic\AcademicExamType;
use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentHistory;

class SiteAssessmentDeclareStudent extends SiteGlobalModel
{
    protected $table='site_assessment_declare_students';
    protected $appends = array('student_roll_number');

    const Site_exam_declare_id = 'site_assessment_declare_id';
    const Student_history_id = 'student_history_id';
    const Assessment_type_id = 'assessment_type_id';
    const Assessment_type_no_ids = 'assessment_type_no_ids';
    const Site_id = 'site_id';
    const Status = 'status';



    protected $fillable = [
        self::Site_exam_declare_id,
        self::Student_history_id,
        self::Assessment_type_id,
        self::Assessment_type_no_ids,
        self::Site_id,
        self::Status,

    ];

    public function getStudentRollNumberAttribute()
    {
        return $this->attributes['student_roll_number'] = $this->studentHistory->student_roll_number ?? '';
    }

  

    public function siteAssessmentDeclareStudentSubject()
    {
        return $this->hasMany(SiteAssessmentDeclareStudentSubject::class);

    }
 

    public function studentHistory()
    {
        return $this->belongsTo(StudentHistory::class);

    }


}
