<?php

namespace App\Models\Site\Accounts;

use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteAccountsVoucherDetailsStudentPaymentHistoryRecord extends SiteGlobalModel
{

    public $timestamps = true;
    protected $table='site_accounts_voucher_details_student_payment_history_records';

    const SITE_ACCOUNTS_VOUCHER_DETAIL_ID = 'site_accounts_voucher_detail_id';
    const SITE_STUDENT_FEE_PAYMENT_HISTORY_ID = 'site_student_fee_payment_history_id';
    const SITE_ID = 'site_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const STATUS = 'status';


    protected $fillable = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_STUDENT_FEE_PAYMENT_HISTORY_ID,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,
    ];

    public $ownFields = [
        self::SITE_ACCOUNTS_VOUCHER_DETAIL_ID,
        self::SITE_STUDENT_FEE_PAYMENT_HISTORY_ID,
        self::SITE_ID,
        self::ACADEMIC_GROUP_ID,
        self::STATUS,

    ];

//    public function accounts()
//    {
//        return $this->hasMany(Accounts::class);
//    }
    public function accountsVoucherDetails()
    {
        return $this->belongsTo(AccountsVoucherDetails::class, 'site_accounts_voucher_detail_id');
    }

    public function siteStudentFeePaymentHistory()
    {
        return $this->belongsTo(SiteStudentFeePaymentHistory::class,'site_student_fee_payment_history_id');
    }

    public function siteStudentFeeDemandSlipDetails()
    {
        return $this->belongsTo(SiteStudentFeeDemandSlipDetails::class);
    }
}
