<?php

namespace App\Models\Site\Accounts;

use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class Ledger extends SiteGlobalModel
{

    public $timestamps = true;
    protected $table='site_accounts_ledgers';

    const PARENT_ID = 'parent_id';
    const PARENT_HEAD_KEY = 'parent_head_key';
    const NAME = 'name';
    const LEDGER_CODE = 'ledger_code';
    const ROOT = 'root';
    const SITE_ID = 'site_id';
    const SITE_GROUP_ID = 'site_group_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';
    const PROPRIETOR_ACCESS_KEY = 'proprietor_access_key';
    const ACCOUNTS_ENTRY = 'accounts_entry';
    const SITE_ACCOUNTS_BANK_ID = 'site_accounts_bank_id';
    const SITE_ACCOUNTS_PARTY_ID = 'site_accounts_party_id';
    const INITIAL_AMOUNT = 'initial_amount';
    const COUNT_AS_CASH_STATUS = 'count_as_cash_status';
    const ACCOUNTS_RECEIVABLE_STATUS = 'accounts_receivable_status';
    const ACCOUNTS_PAYABLE_STATUS = 'accounts_payable_status';



    protected $fillable = [
        self::PARENT_ID,
        self::PARENT_HEAD_KEY,
        self::NAME,
        self::LEDGER_CODE,
        self::ROOT,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::PROPRIETOR_ACCESS_KEY,
        self::ACCOUNTS_ENTRY,
        self::SITE_ACCOUNTS_BANK_ID,
        self::SITE_ACCOUNTS_PARTY_ID,
        self::INITIAL_AMOUNT,
        self::COUNT_AS_CASH_STATUS,
        self::ACCOUNTS_RECEIVABLE_STATUS,
        self::ACCOUNTS_PAYABLE_STATUS,
    ];

    public $ownFields = [
        self::PARENT_ID,
        self::PARENT_HEAD_KEY,
        self::NAME,
        self::LEDGER_CODE,
        self::ROOT,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::PROPRIETOR_ACCESS_KEY,
        self::ACCOUNTS_ENTRY,
        self::SITE_ACCOUNTS_BANK_ID,
        self::SITE_ACCOUNTS_PARTY_ID,
        self::INITIAL_AMOUNT,
        self::COUNT_AS_CASH_STATUS,
        self::ACCOUNTS_RECEIVABLE_STATUS,
        self::ACCOUNTS_PAYABLE_STATUS,


    ];

    public function accounts()
    {
        return $this->hasMany(Accounts::class);
    }
     public function bankAccountDetails()
     {
         return $this->hasMany(BankAccountDetails::class, 'site_accounts_bank_id' ,'site_accounts_bank_id');
     }

}
