<?php

namespace App\Models\Site\Accounts;

use App\Models\Edu\Accounts\AccountsHead;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class AccountsGroup extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table='site_accounts_groups';

    const ACCOUNT_HEAD_ID = 'accounts_head_id';
    const NAME = 'name';
    const HEAD_KEY = 'head_key';
    const SITE_ID = 'site_id';
    const SITE_GROUP_ID = 'site_group_id';
    const ACADEMIC_GROUP_ID = 'academic_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';
    const PROPRIETOR_ACCESS_KEY = 'proprietor_access_key';




    protected $fillable = [
        self::ACCOUNT_HEAD_ID,
        self::NAME,
        self::HEAD_KEY,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::PROPRIETOR_ACCESS_KEY,
    ];

    public $ownFields = [
        self::ACCOUNT_HEAD_ID,
        self::NAME,
        self::HEAD_KEY,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::ACADEMIC_GROUP_ID,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
        self::PROPRIETOR_ACCESS_KEY,
    ];

    public function accountsHead()
    {
        return $this->belongsTo(AccountsHead::class);
    }

    public function accountsSubGroup()
    {
        return $this->hasMany(AccountsSubGroup::class,'id');
    }

}
