<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 6/12/2016
 * Time: 10:42 AM
 */
namespace App\Models\Relation;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Dimsav\Translatable\Translatable;
use App\Models\Reference\Reference;

class Relation extends Model
{
    use SoftDeletes, Translatable;

    public $translationModel = RelationTranslation::class;
    public $translationForeignKey = 'relation_id';

    const STATUS = 'status';
    const RELATION_NAME = 'relation_name';

    public $timestamps = false;

    protected $table = 'relations';

    protected $dates = ['deleted_at'];

    protected $fillable = [
        self::STATUS
    ];
    
    public $translatedAttributes = [
        self::RELATION_NAME
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function references()
    {
        return $this->hasMany(Reference::class);
    }
}