<?php

namespace App\Models\Permission;

use App\Models\Menu\Menu;
use App\Models\ProjectModel;
use App\Models\Role\Role;
use Illuminate\Database\Eloquent\Model;


class GroupAccess extends ProjectModel
{


    const MENU_ID = 'menu_id';
    const ROLE_ID = 'role_id';
    const SUB_MODULE_IDS = 'sub_module_ids';

    public $timestamps = false;

    protected $fillable = [
       self::MENU_ID,
        self::ROLE_ID,
        self::SUB_MODULE_IDS
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function role()
    {
        return $this->belongsTo(Role::class,self::ROLE_ID);
    }

    public function menu()
    {
        return $this->belongsTo(Menu::class,self::MENU_ID);
    }
}
