<?php



namespace App\Models\JobApplication;

use App\Models\ProjectModel;


use Illuminate\Database\Eloquent\Model;

class GlobalJobCircular extends Model
{
    protected $table = 'job_circulars';


    public const TITLE        = 'title';
    public const COMPANY      = 'company';
    public const LOCATION     = 'location';
    public const TYPE         = 'type';
    public const CATEGORY     = 'category';
    public const EXPERIENCE   = 'experience';
    public const SALARY       = 'salary';
    public const SALARY_TYPE  = 'salaryType';
    public const EDUCATION    = 'education';
    public const DEADLINE     = 'deadline';
    public const DESCRIPTION  = 'description';
    public const SITE_ID      = 'site_id';


    protected $fillable = [
        self::TITLE,
        self::COMPANY,
        self::LOCATION,
        self::TYPE,
        self::CATEGORY,
        self::EXPERIENCE,
        self::SALARY,
        self::SALARY_TYPE,
        self::EDUCATION,
        self::DEADLINE,
        self::DESCRIPTION,
        self::SITE_ID,
    ];

    protected $casts = [
        self::DEADLINE => 'date',
    ];
}
