<?php

namespace App\Models\House;

use Illuminate\Database\Eloquent\Model;

//class Designation extends ProjectModel
class House extends Model
{
    protected $table='houses';

    const NAME = 'name';
    const STATUS ='status';
    const POSITION = 'position';

    public $timestamps = false;

    protected $fillable = [
        self::NAME,
        self::STATUS,
        self::POSITION
    ];
    protected $ownfields = [
        self::NAME,
        self::STATUS,
        self::POSITION
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
//    public function department()
//    {
//        return $this->belongsTo(Department::class);
//    }

    /**
     * many users with one designation
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
  

    public function siteLeavePolicy()
    {
        return $this->hasMany(SiteLeavePolicy::class);
    }

    public function employeeHistory()
    {
        return $this->hasMany(EmployeeHistory::class);
    }



}
