<?php

namespace App\Models\Holydays;

use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;
use App\Models\Holydays\Holyday;
use App\Models\Status\Status;

class HolyDayType extends Model
{
    const NAME = 'name';
    const HEAD_KEY = 'head_key';
    const STATUS = 'status';


    public $timestamps = false;

    protected $fillable = [
        self::NAME,
        self::STATUS,
        self::HEAD_KEY
    ];

    public $ownFields = [
        self::NAME,
        self::STATUS,
        self::HEAD_KEY
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function holydays()
    {
        return $this->hasMany(Holyday::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function status()
    {
        return $this->belongsTo(Status::class);
    }
}
