<?php

namespace App\Models\Employee;

use App\Models\Examinations\Examination;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeEducationBackground extends ProjectModel
{
    use SoftDeletes;

    protected $table='emp_education_backgrounds';

    const USER = 'user_id';
    const EXAMINATION_ID = 'examination_id';
    const BOARD_UNIVERSITY_NAME = 'board_university_name';
    const PASSING_YEAR = 'passing_year';
    const RESULT_TYPE_ID = 'result_type_id';
    const TIME_DURATION = 'time_duration';
    const GPA = 'gpa';
    const STATUS = 'status';
    const SITE_ID = 'site_id';

    public $timestamps = false;
    protected $dates = ['deleted_at'];

    protected $fillable = [
        self::USER,
        self::EXAMINATION_ID,
        self::BOARD_UNIVERSITY_NAME,
        self::PASSING_YEAR,
        self::RESULT_TYPE_ID,
        self::TIME_DURATION,
        self::GPA,
        self::STATUS,
        self::SITE_ID,

    ];

    protected $ownFields = [
        self::USER,
        self::EXAMINATION_ID,
        self::BOARD_UNIVERSITY_NAME,
        self::PASSING_YEAR,
        self::RESULT_TYPE_ID,
        self::TIME_DURATION,
        self::GPA,
        self::STATUS,
        self::SITE_ID,
    ];


    public function examination()
    {
        return $this->belongsTo(Examination::class);
    }




}
