<?php

namespace App\Models\Edu\Transaction;

use App\Models\Edu\Item\ItemDetail;
use Illuminate\Database\Eloquent\Model;

class EduStudentInvoiceDeclareItem extends Model
{
    protected $table = 'edu_student_invoice_declare_items';


    const Edu_student_invoice_declare_id = 'edu_student_invoice_declare_id';
    const Edu_item_detail_id = 'edu_item_detail_id';
    const Amount = 'amount';
    const Site_id = 'site_id';
    const STATUS = 'status';



    protected $fillable = [
        self::Site_id,
        self::Edu_student_invoice_declare_id,
        self::Edu_item_detail_id,
        self::Amount,
        self::STATUS,
    ];

    public function eduItemDetail()
    {
        return $this->belongsTo(ItemDetail::class, 'edu_item_detail_id');
    }
}
