<?php

namespace App\Models\Edu\NonSite;

use App\Models\Academic\AcademicEducationLevel;
use App\Models\Academic\AcademicInstituteManagementType;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Gender\Gender;
use App\Models\Thana\Thana;
use Illuminate\Database\Eloquent\Model;

class AllInstituteList extends Model
{
    public $timestamps = true;
    protected $table='all_institute_lists';


    const Division_id = 'division_id';
    const District_id = 'district_id';
    const Thana_id = 'thana_id';
    const Eiin = 'eiin';
    const Institution_name = 'institution_name';
    const Academic_education_level_id = 'academic_education_level_id';
    const Academic_institute_management_type_id = 'academic_institute_management_type_id';
    const Institution_mobile = 'institution_mobile';
    const Institution_email = 'institution_email';
    const Gender_id = 'gender_id';
    const Accepted_as_site = 'accepted_as_site';
    const Status = 'status';



    protected $fillable = [
        self::Division_id,
        self::District_id,
        self::Thana_id,
        self::Eiin,
        self::Institution_name,
        self::Academic_education_level_id,
        self::Academic_institute_management_type_id,
        self::Institution_mobile,
        self::Institution_email,
        self::Gender_id,
        self::Accepted_as_site,
        self::Status,
    ];

    public $ownFields = [
        self::Division_id,
        self::District_id,
        self::Thana_id,
        self::Eiin,
        self::Institution_name,
        self::Academic_education_level_id,
        self::Academic_institute_management_type_id,
        self::Institution_mobile,
        self::Institution_email,
        self::Gender_id,
        self::Accepted_as_site,
        self::Status,
    ];



    public function division()
    {
        return $this->belongsTo(Division::class);
    }


    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function thana()
    {
        return $this->belongsTo(Thana::class);
    }

    public function academicEducationLevel()
    {
        return $this->belongsTo(AcademicEducationLevel::class);
    }

    public function academicInstituteManagementType()
    {
        return $this->belongsTo(AcademicInstituteManagementType::class);
    }

    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }






}
