<?php

namespace App\Models\Department;

use App\Models\Company\Company;
use App\Models\Designation\Designation;
use App\Models\ProjectModel;
use App\Models\Shift\Shift;
use App\Models\Student\StudentClass;
use Illuminate\Database\Eloquent\Model;
use App\User;

class Department extends ProjectModel
{

   public $timestamps = false;

   const NAME = 'name';
    const TYPE = 'type';
    const STATUS = 'status';
   const POSITION = 'position';

   protected $fillable = [self::NAME,self::TYPE,self::STATUS,self::POSITION];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function company()
    {
       return $this->belongsTo(Company::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function designations()
    {
        return $this->hasMany(Designation::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function shifts()
    {
        return $this->belongsToMany(Shift::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function studentClasses()
    {
        return $this->hasMany(StudentClass::class);
    }
}
