<?php

namespace App\Models\Company\Role;

use Illuminate\Database\Eloquent\Model;

class GlobalCompanyRole extends Model
{
    protected $table='company_roles';


    public $timestamps = true;

    const NAME = 'name';
    const KEY = 'key';
    const ROLE_DESCRIPTION = 'role_description';
    const COMPANY_ID = 'company_id';
    const STATUS = 'status';


    protected $fillable = [

        self::NAME,
        self::KEY,
        self::ROLE_DESCRIPTION,
        self::COMPANY_ID,
        self::STATUS,
    ];
    public $ownFields = [

        self::NAME,
        self::NAME,
        self::KEY,
        self::ROLE_DESCRIPTION,
        self::COMPANY_ID,
        self::STATUS,
    ];



    public function roleAccess(){
        return $this->hasOne(GlobalCompanyRoleAccess::class,'company_role_id');
    }



}
