<?php

namespace App\Models\Company;

use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class GlobalCompany extends Model
{
    use Translatable;

    protected $table = 'company_details';
    public $translationModel = 'App\Models\Company\CompanyTranslation';
    public $translationForeignKey = 'company_id';

    /*    public $translationModel = 'App\Models\User\UserTranslation';
        public $translationForeignKey = 'user_id';*/


    public $timestamps = true;

    const NAME = 'name';
    const ADDRESS = 'address';
    const ALIAS = 'alias';
    const PHONE = 'phone';
    const TYPE = 'type';
    const EMAIL = 'email';
    const LOGO = 'logo';
    const EDU_PACKAGE_ID = 'edu_package_id';
    const PAYMENT_TYPE = 'payment_type';
    const PAYMENT_TYPE_DURATION = 'payment_type_duration';
    const PAYMENT_AMOUNT = 'payment_amount';
    const PAYMENT_INSTALLMENT = 'payment_installment';
    const LATE_PAYMENT_STATUS = 'late_payment_status';
    const LATE_PAYMENT_DAYS = 'late_payment_days';
    const LATE_FEE = 'late_fee';
    const DISCOUNT_TYPE = 'discount_type';
    const DISCOUNT = 'discount';
    const STATUS = 'status';

    //public $translatedAttributes = ['name'];
    public $translatedAttributes = [self::NAME, self::ADDRESS];

    protected $fillable = [


        self::ALIAS,
        self::PHONE,
        self::TYPE,
        self::EMAIL,
        self::LOGO,
        self::EDU_PACKAGE_ID,
        self::PAYMENT_TYPE,
        self::PAYMENT_TYPE_DURATION,
        self::PAYMENT_AMOUNT,
        self::PAYMENT_INSTALLMENT,
        self::LATE_PAYMENT_STATUS,
        self::LATE_PAYMENT_DAYS,
        self::LATE_FEE,
        self::DISCOUNT_TYPE,
        self::DISCOUNT,
        self::STATUS,
    ];
    public $ownFields = [

        self::NAME,
        self::ADDRESS,
        self::ALIAS,
        self::PHONE,
        self::TYPE,
        self::EMAIL,
        self::LOGO,
        self::EDU_PACKAGE_ID,
        self::PAYMENT_TYPE,
        self::PAYMENT_TYPE_DURATION,
        self::PAYMENT_AMOUNT,
        self::PAYMENT_INSTALLMENT,
        self::LATE_PAYMENT_STATUS,
        self::LATE_PAYMENT_DAYS,
        self::LATE_FEE,
        self::DISCOUNT_TYPE,
        self::DISCOUNT,
        self::STATUS,
    ];


    /**
     * Get the user's full name.
     *
     * @return string
     */
    public function getSiteGroupsIdsAttribute($value)
    {
        return explode(',',$value);
    }

    public function getSiteIdsAttribute($value)
    {
        return explode(',',$value);
    }


    public function getAddressAttribute($value)
    {
        return ucfirst($value);
    }


}
