<?php

namespace App\Models\AssessmentResult;

use App\Models\Academic\AcademicAssessmentCombineResultType;
use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use Illuminate\Database\Eloquent\Model;

class AssessmentCombineResultSetting extends Model
{
    public $timestamps = false;
    protected $table='assessment_combine_result_settings';
    protected $appends = array('combine_result_type');

    const Academic_assessment_result_combine_type_id = 'academic_assessment_result_combine_type_id';
    const Academic_assessment_result_primary_type_id = 'academic_assessment_result_primary_type_id';
    const Show_position = 'show_position';
    const Status = 'status';


    protected $fillable = [
        self::Academic_assessment_result_combine_type_id,
        self::Academic_assessment_result_primary_type_id,
        self::Show_position,
        self::Status,
    ];

    
    public function getAssessmentNameAttribute()
    {
        return $this->attributes['combine_result_type'] = $this->academicAssessmentCombineResultType->name ?? '';
    }

    public function academicAssessmentCombineResultType()
    {
        return $this->belongsTo(AcademicAssessmentCombineResultType::class,'academic_assessment_result_combine_type_id');
    }

    public function academicAssessmentPrimaryResultType()
    {
        return $this->belongsTo(AcademicAssessmentPrimaryResultType::class,'academic_assessment_result_primary_type_id');
    }

}
