<?php

namespace App\Models\Assessment;

use App\Models\Academic\AcademicClass;

use Illuminate\Database\Eloquent\Model;

class AssessmentTypeNo extends Model
{
    protected $table = 'assessment_type_nos';

    const Academic_class_id = 'academic_class_id';
    const Type_id = 'assessment_type_id';
    const Type_no = 'type_no';
    const Type_no_key = 'type_no_key';
    const Serial = 'serial';
    const Description = 'description';
    const Status = 'status';

    protected $fillable = [
        self::Academic_class_id,
        self::Type_id,
        self::Type_no,
        self::Type_no_key,
        self::Description,
        self::Serial,
        self::Status,
    ];
    
    protected $ownFields = [
        self::Academic_class_id,
        self::Type_id,
        self::Type_no,
        self::Type_no_key,
        self::Description,
        self::Serial,
        self::Status,
    ];

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class,'academic_class_id');
    }
    public function assessmentType()
    {
        return $this->belongsTo(AssessmentType::class,'assessment_type_id');
    }
}
