<?php

namespace App\Models\AcademicYear;

use App\Models\Edu\ClassRoom\EduClassRoom;
use App\Models\ProjectModel;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use Illuminate\Database\Eloquent\Model;


class AcademicYear extends Model
{
//    use SoftDeletes, Translatable;


    const Start_Date = 'start_date';
    const End_Date = 'end_date';
    const Year_Name = 'year_name';
    const Serial_no = 'serial_no';
    const Status = 'status';

    public $timestamps = true;

    //টেবিলের নামের সাথে যদি মডেলের নামের মিল না থাকে তাহলে নিচের লাইনটা দিতে হয়
    //protected $table = 'academic_qualifications';

    //protected $dates = ['deleted_at'];

    protected $fillable = [
        self::Start_Date,
        self::End_Date,
        self::Year_Name,
        self::Serial_no,
        self::Status
    ];

    public function classRoom()
    {
        return $this->hasMany(ClassRoom::class);
    }

    public function eduClassRoom()
    {
        return $this->hasMany(EduClassRoom::class);
    }

/*    public $translatedAttributes = [
        self::Start_Date,
        self::End_Date,
        self::Year_Name
    ];*/

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
//     */
//    public function academicYearForYearSession()
//    {
//        return $this->belongsTo(EducationLevel::class, 'education_level_id');
//    }
}
