<?php

namespace App\Models\Academic;

use App\Models\Site\Exam\SiteExamQuestionInfo;
use Illuminate\Database\Eloquent\Model;
use Dimsav\Translatable\Translatable;

class AcademicSubjectTopic extends Model
{
    use Translatable;
    public $translationModel = AcademicSubjectTopicTranslation::class;
    public $translationForeignKey = 'academic_subject_topic_id';

    public $timestamps = true;
    protected $table = 'academic_subject_topics';



    const ACADEMIC_SUBJECT_ID = 'academic_subject_id';
    const HEAD_KEY = 'head_key';
    const MODULE_KEY = 'module_key';
    const TOPIC_NAME = 'topic_name';
    const SITE_ID = 'site_id';
    const Site_group_id = 'site_group_id';
    const CREATED_BY = 'created_by';
    const CREATED_DATE = 'created_date';
    const STATUS = 'status';


    protected $fillable = [
        self::ACADEMIC_SUBJECT_ID,
        self::HEAD_KEY,
        self::MODULE_KEY,
        self::TOPIC_NAME,
        self::SITE_ID,
        self::Site_group_id,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
    ];

    public $translatedAttributes = [
        self::TOPIC_NAME,
    ];

    public $ownFields = [
        self::ACADEMIC_SUBJECT_ID,
        self::HEAD_KEY,
        self::MODULE_KEY,
        self::TOPIC_NAME,
        self::SITE_ID,
        self::Site_group_id,
        self::CREATED_BY,
        self::CREATED_DATE,
        self::STATUS,
    ];

//    public function classes()
//    {
//        return $this->belongsToMany(AcademicClass::class);
//    }

    public function siteExamQuestionInfo()
    {
        return $this->hasMany(SiteExamQuestionInfo::class);
    }

}
