<?php

namespace App\Models\Academic;

use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class AcademicShift extends Model
{
    use Translatable;

    protected $table='academic_shifts';

    const NAME = 'shift_name';
    const STATUS = 'status';

    public $timestamps = false;

    protected $fillable = [self::NAME, self::STATUS];

    public $ownFields = [

        self::NAME,
        self::STATUS

    ];

    public $translatedAttributes = [self::NAME];



    public function scopeActive($query)
    {
        return $query->where('status','Active');
    }


}
