<?php

namespace App\Models\Academic;

use Illuminate\Database\Eloquent\Model;

class AcademicPaymentType extends Model
{
    public $timestamps = true;
    protected $table='academic_payment_types';

    const NAME = 'name';
    const NAME_KEY = 'name_key';
    const STATUS = 'status';

    protected $fillable = [

        self::NAME,
        self::NAME_KEY,
        self::STATUS,

    ];

    public $ownFields = [
        self::NAME,
        self::NAME_KEY,
        self::STATUS,

    ];

    public function academicOnlinePaymentMethod()
    {
        return $this->hasMany(AcademicOnlinePaymentMethod::class, 'payment_type_key');
    }
}
