<?php

namespace App\Models\Academic;

use App\Models\Site\Payment\PaymentGateway;
use Illuminate\Database\Eloquent\Model;

class AcademicOnlinePaymentMethod extends Model
{
    public $timestamps = true;
    protected $table='academic_online_payment_methods';

    const NAME = 'name';
    const NAME_KEY = 'name_key';
    const PAYMENT_TYPE_KEY = 'payment_type_key';
    const STATUS = 'status';

    protected $fillable = [
        self::NAME,
        self::NAME_KEY,
        self::PAYMENT_TYPE_KEY,
        self::STATUS,

    ];

    public $ownFields = [
        self::NAME,
        self::NAME_KEY,
        self::PAYMENT_TYPE_KEY,
        self::STATUS,
    ];

    public function paymentGateway()
    {
        return $this->hasMany(PaymentGateway::class);
    }

    public function academicOnlinePaymentMarchentType()
    {
        return $this->belongsTo(AcademicOnlinePaymentMarchentType::class, 'academic_online_payment_marchent_type_id');
    }
    public function academicPaymentType()
    {
        return $this->belongsTo(AcademicPaymentType::class, 'payment_type_key', 'name_key');
    }
    public function accOnlinePaymentMarchentType()
    {
        return $this->hasMany(AcademicOnlinePaymentMarchentType::class);
    }
}
