<?php

namespace App\Models\Academic;

use App\Models\Site\EmployeeLeave\SiteLeavePolicy;
use Illuminate\Database\Eloquent\Model;

class AcademicLeaveType extends Model
{

    public $timestamps = true;
    protected $table='academic_leave_types';

    const NAME = 'name';
    const SHORT_NAME = 'short_name';
    const HEAD_KEY = 'head_key';
    const STATUS = 'status';


    protected $fillable = [
        self::NAME,
        self::SHORT_NAME,
        self::HEAD_KEY,
        self::STATUS
    ];

    public $ownFields = [
        self::NAME,
        self::SHORT_NAME,
        self::HEAD_KEY,
        self::STATUS
    ];

    public function siteLeavePolicy()
    {
        return $this->hasMany(SiteLeavePolicy::class);
    }
}
