<?php

namespace App\Models\Academic;

use App\Models\Site\EmployeeLeave\SiteLeavePolicy;
use Illuminate\Database\Eloquent\Model;

class AcademicLeaveCategory extends Model
{
    public $timestamps = true;
    protected $table='academic_leave_categories';

    const NAME = 'name';
    const HEAD_KEY = 'head_key';
    const STATUS = 'status';


    protected $fillable = [
        self::NAME,
        self::HEAD_KEY,
        self::STATUS
    ];

    public $ownFields = [
        self::NAME,
        self::HEAD_KEY,
        self::STATUS
    ];

    public function siteLeavePolicy()
    {
        return $this->hasMany(SiteLeavePolicy::class);
    }
}
