<?php

namespace App\Models\Academic;

use App\Models\Event\Event;
use Illuminate\Database\Eloquent\Model;

class AcademicCalendarHead extends Model
{

    public $timestamps = false;
    protected $table='academic_calendar_heads';

    const NAME = 'name';
    const COLOR_ID = 'color_id';
    const COLOR_NAME='color_name';
    const STATUS = 'status';
    const Head_key = 'head_key';

    protected $fillable = [

        self::NAME,
        self::COLOR_ID,
        self::COLOR_NAME,
        self::STATUS,
        self::Head_key

    ];

    public $ownFields = [

        self::NAME,
        self::COLOR_ID,
        self::COLOR_NAME,
        self::STATUS,
        self::Head_key

    ];


    public function academicCalendarSubHeadColor()
    {
        return $this->hasMany(AcademicCalendarSubheadColor::class);
    }

    public function event()
    {
        return $this->hasMany(Event::class);
    }

}