<?php

namespace App\Mail\Site;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendSiteInfo extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $tries = 2;
    public $sub;
    public $data;
    public function __construct($subject,$data)
    {
        $this->sub=$subject;
        $this->data=$data;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {

        $name1=   $this->data['name'] ?? 'no name';


        return $this->view('user-credentials-mail',
            [
             'name' =>$name1 ,
            'username' => $this->data['username'],
            'sub_domain' =>$this->data['sub_domain'],
            'password' => $this->data['password'],
            'body_text' => $this->data['message'],
            'by' => $this->data['user_id'],
            ]
        )->subject($this->sub);
    }
}
