<?php

namespace App\Listeners;

use App\Http\Requests\Request;
use App\Models\Edu\Issue\IssueDetail;
use DateTime;
use DateTimeZone;
use Illuminate\Auth\Events\Login;
use Illuminate\Foundation\Application;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Session;

class LogSuccessfulLogin
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    private $app;

    public function __construct(Application $app)
    {
        $this->app = $app;

    }

    /**
     * Handle the event.
     *
     * @param  Login  $event
     * @return void
     */
    public function handle(Login $event)
    {
        $dt = new DateTime(date('Y-m-d H:i:s'));
        $tz = new DateTimeZone('Asia/Dhaka'); // or whatever zone you're after
        $dt->setTimezone($tz);
        $this->app->setLocale('bn');

        $event->user->last_login = $dt->format('Y-m-d H:i:s');
        $event->user->last_academic_group_id = Session::get('ACADEMIC_GROUP_ID');
        $event->user->save();



        $issue = new    IssueDetail();
        $issue->username = $event->user->username;
        $issue->bearer_type = 'edu';
        $issue->issue_type = 'user:log';
        $issue->issue_details = 'ip:' . \Request::ip();
        $issue->ip_address = \Request::ip();
        $issue->save();
/*
last_academic_group_id
        if($event->user->locale){
            $locale = Session::get($event->user->locale);
        }else{
            $locale = $this->app->config->get('app.fallback_locale');
            Session::put('locale',$locale);
        }
      //  dd($locale);
      //  Session::put('language',$this->app->config->get('app.locales')[$locale]);
        $this->app->setLocale($locale);*/


    }
}
