<?php

namespace App\Jobs\Site;

use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Student\Attendance\GlobalStudentAbsentDetail;
use App\Traits\SmsApiTrait;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class StudentAbsentSmsJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, SmsApiTrait;


    public $tries = 1;

    protected $details;
    protected $numbers_array;


    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($numbers, $details)
    {
        $this->numbers_array = $numbers;
        $this->details = $details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $sms_responses = $this->sendSmsDynamicApi($this->numbers_array, $this->details);// got to the method to see what it returns
        $msg_id = $sms_responses['sms_api_id'];
        $status = $sms_responses['sms_sent_status'];

        $absent_detail = (new GlobalStudentAbsentDetail())->where('id', $this->details['table_id'])->first();

        if ($absent_detail) {
            if ($status) {// sms sent
                $absent_detail->sms_followup_id = $sms_responses['followup_id'];
                $absent_detail->sms_status = 1;
                $absent_detail->sms_sent_time = $sms_responses['sent_time'];
                $absent_detail->save();


            } else {
                $absent_detail->sms_followup_id = -$sms_responses['followup_id'];
                $absent_detail->sms_status = -1;
                $absent_detail->save();

            }
        } else {
            $issue = new    IssueDetail();
            $issue->issue_details = 'absent details table not found for update in job';
            $issue->issue_type = 'attendance';
            $issue->bearer_type = $this->details['sms_bearer'];
            $issue->bearer_id = $this->details['sms_bearer_id'];
            $issue->save();
        }


        /*   $issue = new    IssueDetail();
           $issue->username = $the_student_his->student->username;
           $issue->issuer_type = 'site';
           $issue->issue_type = 'attendance';
           $issue->issue_details = 'contact_number not found(absent sms)';
           $issue->attendance_date = date('d-m-Y', strtotime($time));
           $issue->site_id = $the_student_his->student->site_id;
           $issue->save();*/


    }


    public function failed(Exception $exception)
    {
        // Send user notification of failure, etc...


        $issue = new    IssueDetail();
        $issue->issue_details = $exception->getMessage();
        $issue->issue_type = 'sms_failed';
        $issue->bearer_type = $this->details['sms_bearer'];
        $issue->bearer_id = $this->details['sms_bearer_id'];
        $issue->save();

        $table_id = $this->details['table_id'];//table id for update

        (new GlobalStudentAbsentDetail)
            ->where('id', $table_id)
            ->update([
                'sms_status' => -1
            ]);
    }
}
