<?php

namespace App\Jobs\Site;

use App\Models\Site\Role\SiteRole;
use App\Models\Student\StudentHistory;
use App\Notifications\Site\StudentDemandSlipGenerateNotification;
use App\Notifications\Site\StudentPaymentHistoryNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;

class PaymentHistoryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $tries = 1;

    protected $payment_history_details;

    public function __construct($payment_history_details)
    {
        $this->payment_history_details = $payment_history_details;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

            $user_id = StudentHistory::where('id', $this->payment_history_details->student_history_id)->first()->user_id ?? 0;

            $user_role = SiteRole::with('users')->where('name', 'admin')->first();
            $admin_user_details =  $user_role->users;
            $admin_user_id =  $admin_user_details[0]->id;

            $id = [$admin_user_id, $user_id];

            $users = User::whereIn('id', $id)->get();

            $route=route('site-notice-view',['']);
//        $users->notify(new StudentPaymentHistoryNotification($this->payment_history_details,$route));

            //$user->notify(new InvoicePaid($invoice));
            foreach ($users as $key => $value){

                $user = User::where('id', $value->id)
                ->select(['id'])
                ->first();
                $user->notify(new StudentPaymentHistoryNotification($this->payment_history_details,$route));
            }

           // Notification::send($user, new StudentPaymentNotification($value));


    }
}
