<?php

namespace App\Jobs;

use App\Models\Edu\Issue\IssueDetail;
use App\Traits\SmsApiTrait;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendSmsDynamicJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, SmsApiTrait;


    public $tries = 1;
    public $timeout = 180;

    protected $details;
    protected $numbers_array;
    protected $response;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($numbers_array, $details)
    {
        $this->details = $details;
        $this->numbers_array = $numbers_array;


    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        $response = $this->sendSmsDynamicApi($this->numbers_array, $this->details);// got to the method to see what it returns

    }

    public function failed(Exception $exception)
    {

    }
}
