<?php

namespace App\Jobs\EmployeeLeaveApplication;

use App\Models\Site\Role\SiteRole;
use App\Models\Student\StudentHistory;
use App\Models\User\EmployeeHistory;
use App\Notifications\EmployeeLeaveApplication\EmployeeLeaveApplicationApproveNotification;
use App\Notifications\EmployeeLeaveApplication\EmployeeLeaveApplicationNotification;
use App\Notifications\Site\StudentDemandSlipGenerateNotification;
use App\Notifications\Site\StudentPaymentHistoryNotification;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Notification;

class EmployeeLeaveApplicationApproveJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public $tries = 1;

    protected $employee_leave_application_approve_details;
    protected $user_id;
    protected $route;

    public function __construct($employee_leave_application_approve_details, $user_id, $route)
    {
        $this->employee_leave_application_approve_details = $employee_leave_application_approve_details;
        $this->user_id = $user_id;
        $this->route = $route;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

            $user = User::where('id',  $this->user_id)->first();
            $user->notify(new EmployeeLeaveApplicationApproveNotification($this->employee_leave_application_approve_details,$this->route));



    }
}
