<?php

namespace App\Imports\Site;

use App\Models\Image\Photo;
use App\Models\Site\Student\StudentHistoryExcel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Intervention\Image\Facades\Image;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
 use PhpOffice\PhpSpreadsheet\Shared\Date;
use PHPExcel_Shared_Date;



class SiteStudentListImport implements ToModel, WithHeadingRow
{
    private $rows = 0;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */


    public function model(array $row)
    {

        if ($row['student_name']) {

            $data = StudentHistoryExcel::where('student_name', $row['student_name'])
                ->where('mobile', $row['mobile'])
                ->first();
            if (empty($data)) {
                ++$this->rows;

                $formats = ['Y-m-d', 'd/m/Y', 'm-d-Y'];
                $excelDate = date($row['date_of_birth']);
            //    dd($formats);

                $data_formate_status=false;
                $data_formate=null;
                foreach ($formats as $format) {
                    $date = \DateTime::createFromFormat($format, $excelDate);
                    if ($date && $date->format($format) === $excelDate) {
                        $data_formate_status=true;
                        $data_formate=$row['date_of_birth'];
                    }
                }

                // if(!$data_formate_status){
                //     $excelDate = date($row['date_of_birth']); //2018-11-03
                //     $miliseconds = ($excelDate - (25567 + 2)) * 86400 * 1000;
                //     $seconds = $miliseconds / 1000;
                //     $data_formate=date("Y-m-d", $seconds);

                // }

                if (!$data_formate_status) {
                    $excelDate = $row['date_of_birth']; // যদি Excel serial number হয়
                    if (is_numeric($excelDate)) {
                        $unixTimestamp = ($excelDate - 25569) * 86400; // Excel তারিখ থেকে Unix timestamp-এ রূপান্তর
                        $data_formate = date("Y-m-d", $unixTimestamp);
                    } else {
                        $data_formate = date("Y-m-d", strtotime($excelDate)); // যদি এটি ইতোমধ্যে তারিখ ফরম্যাটে থাকে
                    }
                }

 
            
                return new StudentHistoryExcel([

                    'student_name' => $row['student_name'],
                    'father_name' => $row['father_name'],
                    'mother_name' => $row['mother_name'],
                    'roll_number' => $row['roll_number'],
                    'student_id' => $row['student_id'],
                    'date_of_birth' =>$data_formate,

                    'shift' => $row['shift'],
                    'gender' => $row['gender'],
                    'religion' => $row['religion'],
                    'mobile' => $row['mobile'],
                    'board_registration_number' => $row['board_registration_number'],
                    'site_id' => \Session::get('SITE_ID'),

                ]);
            }
        }
   

    }


    public function getRowCount(): int
    {
        return $this->rows;
    }
}
