<?php

namespace App\Http\Middleware;

use Closure;

use Illuminate\Contracts\Auth\Guard;
use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Session;


class LanguageChooser
{

    private $app;
    private $auth;


    public function __construct(Application $app, Guard $auth)
    {
        $this->app = $app;
        $this->auth = $auth;;


    }


    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        //Session::put('locale','bn');
       // $this->app->setLocale('bn');

       // \App::setLocale(Session::get('locale'));

       //dd(app()->getLocale());
       //dd(Session::get('locale'));
        // Make sure current locale exists.

        if (!$this->auth->guest()) {

            if (Session::get('locale')) {
                $locale = Session::get('locale');
            } else {
                if (!$this->auth->guest() && $request->user()->getLocale()) {
                    $locale = $request->user()->getLocale();
                } else {
                    $locale = $this->app->config->get('app.fallback_locale');
                }
                Session::put('locale', $locale);
            }
            Session::put('language', $this->app->config->get('app.locales')[$locale]);
            $this->app->setLocale($locale);
        }

        return $next($request);
    }
}
