<?php

namespace App\Http;

use App\Http\Middleware\CheckEduWorldUserMiddleware;
use App\Http\Middleware\SiteGroupPageCheckerMiddleware;
use App\Http\Middleware\SitePageVisitorCheckerMiddleware;
use Illuminate\Foundation\Http\Kernel as HttpKernel;
use Laravel\Passport\Http\Middleware\CheckClientCredentials;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        \App\Http\Middleware\CheckForMaintenanceMode::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        \App\Http\Middleware\TrustProxies::class,



//        \Erp\Http\Middleware\MySite::class
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            // \Illuminate\Session\Middleware\AuthenticateSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            \App\Http\Middleware\GrantAccessMiddleware::class,
            \Laravel\Passport\Http\Middleware\CreateFreshApiToken::class,

            \App\Http\Middleware\LanguageChooser::class,
            \App\Http\Middleware\MySite::class,
            \App\Http\Middleware\EduStudentTransactionCheck::class
        ],

        'api' => [
            'throttle:60,1',
            'bindings'
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'bindings' => \Illuminate\Routing\Middleware\SubstituteBindings::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'client' => CheckClientCredentials::class,

        'eduworlduserchecker' => CheckEduWorldUserMiddleware::class,
        'sitegrouppagechecker' => SiteGroupPageCheckerMiddleware::class,
        'sitepagechecker' => SitePageVisitorCheckerMiddleware::class,
        'api.access' => \App\Http\Middleware\ApiAccessMiddleware::class,
        'api.app.access' => \App\Http\Middleware\ApiAppAccessMiddleware::class,
        'site_id.check' => \App\Http\Middleware\SiteIDCheckMiddleware::class,
        'employee.check' => \App\Http\Middleware\CheckEmployeeMiddleware::class,
        'eduworlduserchecker2' => \App\Http\Middleware\CheckEduWorldUserMiddleware2::class,
        'sitepagechecker2' => \App\Http\Middleware\SitePageVisitorCheckerMiddleware2::class,
        'siteStudentchecker' => \App\Http\Middleware\SiteStudentCheckerMiddleware::class,
    ];
}
