<?php

namespace App\Http\Controllers\Thana;


use App\Http\Controllers\Controller;
use App\Forms\DistrictForm;
use App\Forms\ThanaForm;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\District\District;
use App\Models\Thana\Thana;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests;
use League\Flysystem\Exception;
use Response;


class ThanaController extends ProjectController
{

    use Lang,FormControll;

    private $thana;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct(Thana $thana)
    {
        $this->middleware('auth')->except('getThanaByDistrictId');
        $this->thana = $thana;
    }

    public function index()
    {

        $viewType = 'Thana List';

        return view('default.admin.layouts.master', compact('viewType'));

        return view('default.admin.thana.index',compact('viewType', 'thanaList'));
    }

    public function getThanaList()
    {
        $thanaList = $this->thana->with('district')->get();
        return $thanaList;
    }

    public function getThanaListPagination(Request $request)
    {

        $paginate = $request->paginate;
        $search_country_id = $request->search_country_id;
        $search_division_id = $request->search_division_id;
        $search_district_id = $request->search_district_id;
        $search_thana_id = $request->search_thana_id;
//        return $search_country_id;

        $thanaList = $this->thana->with(['district'=>function ($qq){
                $qq->with(['division'=>function ($qqq){
                    $qqq->with('country');
                }]);
            }])
            ->when($search_country_id, function ($q) use($search_country_id){
                $q->whereHas('district', function ($q1) use ($search_country_id) {
                     $q1->whereHas('division', function ($q1) use ($search_country_id) {
                        return $q1->where('country_id', $search_country_id);
                    });
                });
            })
            ->when($search_division_id, function ($qr) use($search_division_id){
                $qr->whereHas('district', function ($qrr) use ($search_division_id) {
                    return $qrr->where('division_id', $search_division_id);
                });

            })
            ->when($search_district_id, function ($qu) use($search_district_id){
                return $qu->where('district_id', $search_district_id);

            })
            ->when($search_thana_id, function ($qur) use($search_thana_id){
                return $qur->where('id', $search_thana_id);

            })->paginate($paginate);
        return $thanaList;
    }

    public function getThanaByDistrictId($districtId)
    {
        try {
            $thanaOfDistrict = $this->thana->whereDistrictId($districtId)->get();
            //$subjectOfClass = $subject->whereStudentClassId($divisionId)->get();
            //return $districtOfDivision;


            return $thanaOfDistrict;
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Thana Not Found', 410]);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }


    public function createThana(Request $request)
    {
        $this->thana->govt_code = $request->get('govt_code');
        $this->thana->district_id = $request->get('district_id');
        $this->thana->thana_name = $request->get('thana_name');
        $this->thana->status = $request->get('status');

        if($this->thana->save()){
            $district_check = District::where('id', $request->get('district_id'))->first();
            $district_check->update([
                'thana_check' => 1
            ]);
            return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function editThana($id, Request $request)
    {
        $thanaToEdit = $this->thana->findOrFail($id);

        $thanaToEdit->govt_code = $request->get('govt_code');
        $thanaToEdit->district_id = $request->get('district_id');
        $thanaToEdit->thana_name = $request->get('thana_name');
        $thanaToEdit->status = $request->get('status');
        if($thanaToEdit->save()){
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);


        }


    }

    public function viewThana($id)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $thanaData = $this->thana->with('country', 'division', 'district')->findOrFail($id);
        //dd($districtData);

        return view('default.admin.thana.view',compact('$thanaData','locale','defaultLocale'));
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deletethana($id)
    {
        $thanaToDelete = $this->thana->findOrFail($id);
        if($thanaToDelete->delete()){
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);

        }
    }
}
