<?php

namespace App\Http\Controllers\Tabulation;

use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Models\Examinations\Examination;
use App\Models\Marks\MarksType;
use App\Models\Result\ResultSetting;
use App\Models\Result\TotalResultSetting;
use App\Models\Student\Section;
use App\Models\Student\StudentClass;
use App\Models\Subject\Subject;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TabulationReportController extends Controller
{

    use Lang, FormControll, DataHelper;


    public function __construct(Subject $subject)
    {
        $this->middleware('auth');
        $this->subject = $subject;
    }


    public function tabulationSheetPage()
    {
        $viewType = 'Get Tabulation Sheet';
        return view('default.admin.reports.tabulation-sheet', compact('viewType'));
    }

    public function generateTabulationSheetReport(Request $request, Examination $examination, StudentClass $studentClasses, Section $sections)
    {

        $examId = $request->examId;
        $studentClassId = $request->studentClassId;
        $sectionId = $request->sectionId;
        $markTypes = (new MarksType())->all();
        $resultSettings = new ResultSetting();
        $totalResultSettings = new TotalResultSetting();

        $subjectsOfTheClass = (new Subject())->whereStudentClassId($studentClassId)->get();

        //dd($subjectsOfTheClass);

        $studentClass = $studentClasses->findOrFail($request->studentClassId);
        $exam = $examination->findOrFail($request->examId);
        $studentSection = $sections->findOrFail($request->sectionId);

        $studentsOfTheClass = $studentClass->students;
        $totalResultSystemDetails = $studentSection->totalResultSystem;
        $totalResultSystem = $studentSection->totalResultSystem->result_rule ?? '';//grade or division

        if (!$totalResultSystemDetails) {
            return \Response::json('Total Result Setting Missing!', 300);
        }
        if (!$totalResultSystem) {
            return \Response::json('Total Result Setting Rule Missing!', 300);
        }


        $subjectDetailsWithMarkTypes = [];

        $subjectGrades = [];

        $gradePointAvg = 0;
        $studentResult = [];


        if ($totalResultSystem == 'grade') {

            foreach ($studentsOfTheClass as $studentOfTheClass) {//all students
                $totalGradePoint = 0;
                $subjectTotal = 0;
                $failedInOneSubject = false;
                $totalCredit = 0;

                $studentId = $studentOfTheClass->id;
                $studentMarks = $this->marksInfo($examId, $studentClassId, $sectionId, $studentId);

                if (isset($studentMarks) && !empty($studentMarks)) {
                    //  dd($studentMarks);
                    foreach ($studentMarks as $subjectId => $markDetails) {//all subject of a student

                        if ($markDetails->result_rule != 'grade') {
                            return \Response::json('Set Result System Grade for the Subject ' . $markDetails->subject_name, 300);
                        }
                        if ($markDetails->combine_subject) {

                        } else {

                            $theCombinedSubject = $this->checkSubjectBelongsToCombine($markDetails->subjectid, $studentMarks);

                            if ($theCombinedSubject) {
                                //main sub then combine/ 1st then 2nd paper----------------------
                                $mainSubResult = $this->mainSubjectMark($markDetails, $subjectsOfTheClass);

                                $subjectMarksTypeName = $this->subjectMarksTypeInArray($markDetails);


                                $subjectDetailsWithMarkTypes[$markDetails->subject_name] = [
                                    'markTypes' => $subjectMarksTypeName,
                                    'markTypeWisePssMark' => $mainSubResult['markTypeWisePssMark'],
                                ];
                                $totalGradePoint += $mainSubResult['totalGradePoint'];
                                $subjectGrades[$markDetails->subject_name] = [
                                    'subjectGrade' => $mainSubResult['subjectGrade'],
                                    'subjectGradePoint' => $mainSubResult['subjectGradePoint'],
                                    'markTypesWiseMark' => $mainSubResult['subjectMarkTypesWiseMarks'],
                                    'markTypeWisePssMark' => $mainSubResult['markTypeWisePssMark'],
                                    'subjectTotal' => isset($markDetails->total) ? $markDetails->total : 0
                                ];

                                //2nd sub/ means combined sub---------------------
                                $combineSubResult = $this->combineSubjectMark($theCombinedSubject, $subjectsOfTheClass, $markDetails);

                                $markTypeWisePssMark = $combineSubResult['markTypeWisePssMark'];
                                $combineName = $combineSubResult['combineName'];
                                $subjectGrade = $combineSubResult['subjectGrade'];
                                $subjectGradePoint = $combineSubResult['subjectGradePoint'];
                                $subjectMarkTypesWiseMarks = $combineSubResult['subjectMarkTypesWiseMarks'];
                                $failedInOneSubject = $combineSubResult['failedInOneSubject'] || $failedInOneSubject;


                                $subjectMarksTypeName = $this->subjectMarksTypeInArray($theCombinedSubject);

                                $subjectDetailsWithMarkTypes[$theCombinedSubject->subject_name] = [
                                    'markTypes' => $subjectMarksTypeName,
                                    'markTypeWisePssMark' => $markTypeWisePssMark,
                                    'combineName' => $combineName,
                                ];
                                $totalGradePoint += $combineSubResult['totalGradePoint'];
                                $subjectGrades[$theCombinedSubject->subject_name] = [
                                    'subjectGrade' => $subjectGrade,
                                    'subjectGradePoint' => $subjectGradePoint,
                                    'markTypesWiseMark' => $subjectMarkTypesWiseMarks,
                                    'markTypeWisePssMark' => $markTypeWisePssMark,
                                    'subjectTotal' => $combineSubResult['subjectTotal']
                                ];

                            } else {//individual subject/not belongs any combine sub-- like math,


                                $subjectGradePoint = 0;
                                $subjectGrade = 'F';


                                $subjectTotal = isset($markDetails->total) ? $markDetails->total : 0;
                                $marksTypeInfo = isset($markDetails->marks_type_info) ? json_decode($markDetails->marks_type_info) : null; //{"1":{"markTypeMax":"40","markTypePass":"12"},"2":{"markTypeMax":"25","markTypePass":"9"}
                                $subjectMarkTypesWiseMarks = isset($markDetails->mark_types) ? json_decode($markDetails->mark_types) : null;//student's original marks --{"1":"11","2":"7","3":"12","4":"12"}
                                $resultSettingIds = isset($markDetails->setting_ids) ? explode(',', json_decode($markDetails->setting_ids)) : [];
//dd($subjectMarkTypesWiseMarks);


                                if (isset($resultSettingIds) && !empty($resultSettingIds)) {
                                    foreach ($resultSettingIds as $resultSettingId) {

                                        $resultSettingObject = $resultSettings->find($resultSettingId);
                                        $resultSetting = !is_null($resultSettingObject) ? json_decode($resultSettingObject->settings) : null;

                                        if (!is_null($resultSetting) && $subjectTotal >= $resultSetting->sub_min && $subjectTotal <= $resultSetting->sub_max) {
                                            $subjectGradePoint = $resultSetting->gpa;


                                            $subject_credit = 0;

                                            if ($markDetails->subject_credit >= 1) {
                                                $subject_credit = $markDetails->subject_credit;
                                            } else if ($markDetails->subject_credit == -1) {
                                                $subject_credit = 1;
                                            }
                                            $totalGradePoint += ($resultSetting->gpa * $subject_credit);
                                            //   $totalGradePoint += $resultSetting->gpa * (isset($markDetails->subject_credit) ? $markDetails->subject_credit : 0);

                                            $subjectGrade = $resultSetting->grade_class;
                                        }

                                        $markTypeWisePssMark = [];
                                        if (!is_null($resultSetting)) {
                                            foreach ($marksTypeInfo as $markTypeId => $marks_type) {
                                                // dd($subjectMarkTypesWiseMarks->{$markTypeId} >= $marks_type->markTypePass);
                                                $markTypeWisePssMark[$markTypeId] = $marks_type->markTypePass;
                                                if ($subjectMarkTypesWiseMarks->{$markTypeId} <= $marks_type->markTypeMax && $subjectMarkTypesWiseMarks->{$markTypeId} >= $marks_type->markTypePass) {
                                                    //passed
                                                } else {//failed in at least one subject means failed
                                                    $failedInOneSubject = true;
                                                    $subjectGrade = 'F';
                                                }
                                            }
                                        }
                                        $subjectMarksTypeName = $this->subjectMarksTypeInArray($markDetails);

                                        $subjectDetailsWithMarkTypes[$markDetails->subject_name] = [
                                            'markTypes' => $subjectMarksTypeName,
                                            'markTypeWisePssMark' => $markTypeWisePssMark,
                                            'combineName' => null,

                                        ];

                                        $subjectGrades[$markDetails->subject_name] = [
                                            'subjectGrade' => $subjectGrade,
                                            'subjectGradePoint' => $subjectGradePoint,
                                            'markTypesWiseMark' => $subjectMarkTypesWiseMarks,
                                            'markTypeWisePssMark' => $markTypeWisePssMark,
                                            'subjectTotal' => $subjectTotal
                                        ];

                                    }
                                    //grade point average with subject type marks...

                                }

                            }
                        }
                    }//all subject mark getting finished

                    //get final result based on total result setting
                    $totalCredit = $this->getSubjectTotalCredit($subjectsOfTheClass);
                    // dd($totalCredit);

                    $gradePointAvg = ($totalGradePoint / $totalCredit);

                    $totalResultSystemSettingIds = explode(',', $totalResultSystemDetails->setting_ids);

                    if (isset($totalResultSystemSettingIds) && !empty($totalResultSystemSettingIds)) {
                        foreach ($totalResultSystemSettingIds as $totalResultSystemSettingId) {

                            $totalResultSettingObject = $totalResultSettings->find($totalResultSystemSettingId);
                            $totalResultSetting = !is_null($totalResultSettingObject) ? json_decode($totalResultSettingObject->settings) : null;

                            if (!is_null($totalResultSetting) && !$failedInOneSubject && $gradePointAvg >= $totalResultSetting->sub_min && $gradePointAvg <= $totalResultSetting->sub_max) {
                                $studentOfTheClass->finalGrade = $totalResultSetting->grade_class;
                            }
                        }
                    }
                    //dd($failedInOneSubject);
                    //if student fails in any mark type of any subject
                    if ($failedInOneSubject) {
                        $studentOfTheClass->finalGrade = "F";
                    }

                    $studentOfTheClass->subject_grades = $subjectGrades;
                    $studentResult[$studentId] = $studentOfTheClass;
                    $studentOfTheClass->finalPoint = $gradePointAvg;


                } else {
                    $subjectGrades = [];
                }


            }
          //  dd($studentResult);

            return view('default.admin.reports.tabulation-sheet-report', compact('students', 'studentMarks', 'subjectDetailsWithMarkTypes', 'markTypes', 'studentResult', 'exam', 'studentClass', 'studentSection'));

        } else {//division

            return view('default.admin.reports.tabulation-sheet-report', compact('students', 'studentMarks', 'subjectMarksTypeName', 'markTypes', 'studentResult', 'exam', 'studentClass', 'studentSection'));
        }
    }


    public function getSubjectTotalCredit($subjects)
    {
        $total = 0;
        if ($subjects) {

            foreach ($subjects as $subject) {
                //\Log::info($subject->subject_credit);
                if ($subject->subject_credit >= 0) {
                    $total += $subject->subject_credit;
                } else if ($subject->subject_credit == -1) {
                    // $total += 1;
                }
            }
        }
        //dd($total);
        return $total;
    }

    private function mainSubjectMark($markDetails, $subjectsOfTheClass)//bn 2nd
    {
        $resultSettings = new ResultSetting();

        // dd($markDetails);
        $subjectGradePoint = 0;
        $subjectGrade = 'F';
        $failedInOneSubject = false;
        $markTypeWisePssMark = [];

        $subjectTotal = 0;
        $marksTypeInfo = isset($markDetails->marks_type_info) ? json_decode($markDetails->marks_type_info) : null; //{"1":{"markTypeMax":"40","markTypePass":"12"},"2":{"markTypeMax":"25","markTypePass":"9"}
        $subjectMarkTypesWiseMarks = isset($markDetails->mark_types) ? json_decode($markDetails->mark_types) : null;//student's original marks --{"1":"11","2":"7","3":"12","4":"12"}
        $resultSettingIds = isset($markDetails->setting_ids) ? explode(',', json_decode($markDetails->setting_ids)) : [];

        if (isset($markDetails->result_rule) && $markDetails->result_rule = 'grade') {
            $totalCredit = $subjectsOfTheClass->pluck('subject_credit')->reduce(function ($total, $value) {
                return $total + $value;
            });


            foreach ($marksTypeInfo as $markTypeId => $marks_type) {

                $markTypeWisePssMark[$markTypeId] = $marks_type->markTypePass;

                if ($marksTypeInfo->{$markTypeId}->markTypePass) {//has individual type wise pass
                    $totalMarkForTheType = $subjectMarkTypesWiseMarks->{$markTypeId};
                    if ($subjectMarkTypesWiseMarks->{$markTypeId} >= $marksTypeInfo->{$markTypeId}->markTypePass) {//passed
                        $subjectTotal += $totalMarkForTheType;

                    } else { //mark type pass is 0

                        if ($marksTypeInfo->{$markTypeId}->markTypePass) {
                            $totalMarkForTheType = $subjectMarkTypesWiseMarks->{$markTypeId} + $subjectMarkTypesWiseMarks->{$markTypeId};
                            if ($totalMarkForTheType >= $marksTypeInfo->{$markTypeId}->markTypePass) {//passed

                            } else {
                                $failedInOneSubject = true;
                                $subjectGrade = 'F';
                            }
                            $subjectTotal += $totalMarkForTheType;

                        } else {

                        }
                    }
                }
            }

            // dd($subjectTotal);

            if (isset($resultSettingIds) && !empty($resultSettingIds)) {
                foreach ($resultSettingIds as $resultSettingId) {

                    $resultSettingObject = $resultSettings->find($resultSettingId);
                    $resultSetting = !is_null($resultSettingObject) ? json_decode($resultSettingObject->settings) : null;

                    if (!is_null($resultSetting) && $subjectTotal >= $resultSetting->sub_min && $subjectTotal <= $resultSetting->sub_max) {

                        $subjectGradePoint = $resultSetting->gpa;
                        $totalGradePoint = $resultSetting->gpa * ($markDetails->subject_credit);
                        $subjectGrade = $resultSetting->grade_class;
                    }
                }


            }
        }

        $subjectDetailsWithMarkTypes = [
            'markTypeWisePssMark' => $markTypeWisePssMark,
            'subjectGrade' => $subjectGrade,
            'subjectGradePoint' => $subjectGradePoint,
            'subjectMarkTypesWiseMarks' => $subjectMarkTypesWiseMarks,
            'failedInOneSubject' => $failedInOneSubject,
            'totalGradePoint' => $totalGradePoint,
            'subjectTotal' => $subjectTotal
        ];

        // dd($subjectDetailsWithMarkTypes);
        return $subjectDetailsWithMarkTypes;

    }

    private function combineSubjectMark($markDetails, $subjectsOfTheClass, $firstSubject)//bn 2nd
    {
        $resultSettings = new ResultSetting();

//         dd($markDetails->combine_name);
        $subjectGradePoint = 0;
        $subjectGrade = 'F5';
        $failedInOneSubject = false;
        $totalGradePoint = 0;
        $markTypeWisePssMark = [];
        //first paper
        $marksTypeInfo1 = isset($firstSubject->marks_type_info) ? json_decode($firstSubject->marks_type_info) : null; //{"1":{"markTypeMax":"40","markTypePass":"12"},"2":{"markTypeMax":"25","markTypePass":"9"}
        $subjectMarkTypesWiseMarks1 = isset($firstSubject->mark_types) ? json_decode($firstSubject->mark_types) : null;//student's original marks --{"1":"11","2":"7","3":"12","4":"12"}

//second paper
        $subjectTotal = 0; //isset($markDetails->total) ? $markDetails->total : 0;
        $marksTypeInfo = isset($markDetails->marks_type_info) ? json_decode($markDetails->marks_type_info) : null; //{"1":{"markTypeMax":"40","markTypePass":"12"},"2":{"markTypeMax":"25","markTypePass":"9"}
        $subjectMarkTypesWiseMarks = isset($markDetails->mark_types) ? json_decode($markDetails->mark_types) : null;//student's original marks --{"1":"11","2":"7","3":"12","4":"12"}
        $resultSettingIds = isset($markDetails->setting_ids) ? explode(',', json_decode($markDetails->setting_ids)) : [];

        if (isset($markDetails->result_rule) && $markDetails->result_rule = 'grade') {

            foreach ($marksTypeInfo as $markTypeId => $marks_type) {
                $markTypeWisePssMark[$markTypeId] = $marks_type->markTypePass;

                if ($marksTypeInfo1->{$markTypeId}) {//both sub has same mark type

                    if ($marksTypeInfo1->{$markTypeId}->markTypePass) {//if 1st paper has individual type wise pass
                        //dd($subjectMarkTypesWiseMarks1->{$markTypeId} >=$marksTypeInfo1->{$markTypeId}->markTypePass);
                        $totalMarkForTheType = $subjectMarkTypesWiseMarks1->{$markTypeId} + $subjectMarkTypesWiseMarks->{$markTypeId};
                        if ($subjectMarkTypesWiseMarks1->{$markTypeId} >= $marksTypeInfo1->{$markTypeId}->markTypePass) {//passed
                            if ($totalMarkForTheType >= $marksTypeInfo->{$markTypeId}->markTypePass) {//passed

                            } else {
                                $failedInOneSubject = true;
                                $subjectGrade = 'F';
                            }
                            $subjectTotal += $totalMarkForTheType;
                        } else {//failed in at least one subject means failed
                            $failedInOneSubject = true;
                            $subjectGrade = 'F';
                            $subjectTotal += $totalMarkForTheType;
                        }
                    } else { //1st paper mark type pass is 0

                        //check 2nd paper type wise pass
                        if ($marksTypeInfo->{$markTypeId}->markTypePass) {
                            $totalMarkForTheType = $subjectMarkTypesWiseMarks1->{$markTypeId} + $subjectMarkTypesWiseMarks->{$markTypeId};
                            if ($totalMarkForTheType >= $marksTypeInfo->{$markTypeId}->markTypePass) {//passed

                            } else {
                                $failedInOneSubject = true;
                                $subjectGrade = '7F';
                            }
                            $subjectTotal += $totalMarkForTheType;

                        } else {

                        }
                    }
                }
            }

            if (isset($resultSettingIds) && !empty($resultSettingIds)) {

                foreach ($resultSettingIds as $resultSettingId) {
                    $resultSettingObject = $resultSettings->find($resultSettingId);
                    $resultSetting = !is_null($resultSettingObject) ? json_decode($resultSettingObject->settings) : null;


                    if (!is_null($resultSetting)) {
                        if (!is_null($resultSetting) && $subjectTotal >= $resultSetting->sub_min && $subjectTotal <= $resultSetting->sub_max) {
                            $subjectGradePoint = $resultSetting->gpa;
                            $totalGradePoint = $resultSetting->gpa * (isset($markDetails->subject_credit) ? $markDetails->subject_credit : 1);
                            $subjectGrade = $resultSetting->grade_class;
                        }
                    }
                }
            }

            if ($failedInOneSubject) {
                $subjectGrade = 'F';
            }

        }else{//division start in else

        }

        $subjectDetailsWithMarkTypes = [
            'markTypeWisePssMark' => $markTypeWisePssMark,
            'subjectGrade' => $subjectGrade,
            'subjectGradePoint' => $subjectGradePoint,
            'subjectMarkTypesWiseMarks' => $subjectMarkTypesWiseMarks,
            'failedInOneSubject' => $failedInOneSubject,
            'totalGradePoint' => $totalGradePoint,
            'subjectTotal' => $subjectTotal,
            'combineName' => $markDetails->combine_name
        ];
        // dd($subjectDetailsWithMarkTypes);
        return $subjectDetailsWithMarkTypes;

    }


    private function checkSubjectBelongsToCombine($subjectsId, $subjectArray)//get subject's mark type in multidimensional array
    {
        foreach ($subjectArray as $k => $subject) {
            if ($subjectsId == $subject->combine_subject) {
                return $subject;
                // dd($subject);
            }
        }
        return false;
    }


    private function subjectMarksTypeInArray($subjects, $belongsCombine = null)
    {
        // dd($subjects);
        $markTypeName = [];
        if ($subjects != null) {

            $subjectMarkTypes = explode(',', $subjects->subject_marks_type);
            //  dd($subjectMarkTypes);

            if (is_array($subjectMarkTypes) && !empty($subjectMarkTypes)) {
                foreach ($subjectMarkTypes as $subjectMarkTypeId) {
                    $markTypes = (new MarksType())->find($subjectMarkTypeId);
                    if (!is_null($markTypes) && isset($markTypes->marks_type)) {
                        $markTypeName[$markTypes->id] = $markTypes->marks_type;
                    }
                }
            }
        }
        /*    if (!$subjects->isEmpty()) {
            foreach ($subjects as $subject) {
                $subjectMarkTypes = explode(',', $subject->subject_marks_type);
                if (is_array($subjectMarkTypes) && !empty($subjectMarkTypes)) {
                    foreach ($subjectMarkTypes as $subjectMarkTypeId) {
                        $markTypes = (new MarksType())->find($subjectMarkTypeId);
                        if (!is_null($markTypes) && isset($markTypes->marks_type)) {
                            $markTypeName[$subject->subject_name][$markTypes->id] = $markTypes->marks_type;
                        }
                    }
                }
            }
        }*/


        return $markTypeName;
    }


    private function marksInfo($examId, $studentClassId, $sectionId, $studentId)
    {
        $marksInfo = \DB::table('users')
            ->join('student_classes', 'users.student_class_id', '=', 'student_classes.id')
            ->join('user_translations', 'users.id', '=', 'user_translations.user_id')
            ->join('sections', 'users.section_id', '=', 'sections.id')
            ->join('marks', 'marks.user_id', '=', 'users.id')
            ->join('examinations', 'marks.examination_id', '=', 'examinations.id')
            ->join('subjects', 'marks.subject_id', '=', 'subjects.id')
            //  ->join('subject_groups', 'users.subject_group_id', '=', 'subject_groups.id')
//            ->join('result_systems','result_systems.id','=','student_classes.result_system_id' )
            ->join('result_systems', 'result_systems.id', '=', 'subjects.result_system_id')
            ->select(
                'user_translations.first_name',
                'user_translations.last_name',
                'student_classes.class_name',
                'student_classes.total_result_system_id',
                'sections.section_name',
                'examinations.examination_name',
                'subjects.subject_name',
                'subjects.id as subjectid',
                'subjects.marks_type_info',
                'subjects.result_system_id as subject_result_system',
                'result_systems.result_rule',
                'result_systems.setting_ids',
                'marks.mark_types',
                'marks.total',
                'users.id as userid',
                'marks.id as marksid',
                'subjects.subject_credit',
                'subjects.combine_name',
                'subjects.subject_marks_type',
                'subjects.combine_subject'
            )
            ->where([
                'marks.student_class_id' => $studentClassId,
                'marks.section_id' => $sectionId,
                'marks.examination_id' => $examId,
                'marks.user_id' => $studentId,
                'users.section_id' => $sectionId,
                'users.student_class_id' => $studentClassId,
            ])
            ->orderBy('marks.user_id')
            ->get();

        $marksOfStudent = [];
        if (!empty($marksInfo)) {

            foreach ($marksInfo as $studentMark) {

                if (!is_null($studentMark)) {
                    $marksOfStudent[$studentMark->subjectid] = $studentMark;
                }
            }
        }
        return $marksOfStudent;
    }

}
