<?php

namespace App\Http\Controllers\SitePublic\Site;




use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicOccupation;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentQuata;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Country\Country;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Gender\Gender;
use App\Models\Relation\Relation;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Religion\Religion;
use App\Models\Site\Batch\BatchDetail;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\StudentRegistration\GlobalSiteBaseStudentRegistrationDeclare;
use App\Models\Site\StudentRegistration\SiteBaseStudentRegistrationDeclare;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\GlobalSiteSubjectConditionLimit;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Thana\Thana;
use App\Models\WebSite\SiteStudentRegistrationApplication;
use Carbon\Carbon;
use DB;
use Error;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionDeclare;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Image;
use Session;

use Response;

class SiteStudentEntryApplicationFormController extends ProjectController
{
    public function __construct()
    {

    }


    public function index()
    {
        $viewType = 'Site Student Remote Registration';

        return view('web.index', compact('viewType'));
        return view('default.web_site.site.site-student-entry-application-form', compact('viewType'));

    }

    private function getSiteId(){
        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }

        $get_site_id=SiteInfo::select('id', 'site_logo')->where('site_alias', $domain)->first();

        return $get_site_id;
    }





    public function globalGetSiteAcademicGroupList(){


        $site_list=$this->getSiteId();


        $date_formate = Carbon::today();
        $today=$date_formate->format('Y-m-d');


        $registration_declare_group_ids=GlobalSiteBaseStudentRegistrationDeclare::where('site_id', $site_list->id)
            ->where('duration_from_date', '<=', $today)
            ->where('duration_to_date', '>=', $today)
            ->where('status', true)
            ->pluck('academic_group_id')->unique();

        if(count($registration_declare_group_ids)>0){
            $registration_declare_group_list=GlobalSiteBaseStudentRegistrationDeclare::with(['academicGroup'])
                ->select('id', 'duration_from_date',
                'duration_to_date', 'extended_date', 'academic_group_id')
                ->where('site_id', $site_list->id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->get();

            $declared_time_present=1;
        }else{
            $declared_time_present='No Online Registration.!';
            $registration_declare_group_list=[];
        }


        $site_group_ids=GlobalSiteInfoSetting::where('site_id', $site_list->id)
            ->pluck('academic_group_id');


        $declared_group_ids = array_intersect($registration_declare_group_ids->toArray(), $site_group_ids->toArray());


        $academic_group_list=AcademicGroup::whereIn('id', $declared_group_ids)->get();

//        return Response::json('academic_group_list', 'declared_time_present', 'registration_declare_group_list', 'site_list', 200);

        return response()->json(
            [
                'academic_group_list' => $academic_group_list,
                'declared_time_present' => $declared_time_present,
                'registration_declare_group_list' => $registration_declare_group_list,
                'site_list' => $site_list,
            ]);



        // return compact('academic_group_list', 'declared_time_present', 'registration_declare_group_list', 'site_list');
    }



    private function getDeclaredList($group_id){
        $site_list=$this->getSiteId();
        $registration_declare_list=GlobalSiteBaseStudentRegistrationDeclare::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('status', true)
            ->first();


        return $registration_declare_list;
    }




    public function globalSiteYearShiftVersionAdmissiontypeStudenttypeLoad($group_id){


        $site_list=$this->getSiteId();
        $getDeclaredList=$this->getDeclaredList($group_id);

      //  dd($getDeclaredList);

        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->first();
        if (!$SiteInfoTableData) {
            return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
        }

        $siteGroupShift = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->distinct('academic_shift_id')
            ->select('academic_shift_id')
            ->pluck('academic_shift_id');


        $previousAcademicShiftList = AcademicShift::whereIn('id', $siteGroupShift)->get();

        $previousAcademicYear = explode(',', $SiteInfoTableData->academic_year_ids ?? null);
        $previousAcademicYearList = AcademicYear::whereIn('id', $previousAcademicYear)->get();


//        $academicVersionIDs = explode(',', $SiteInfoTableData->academic_version_ids);
//        $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();


        $academicShiftList=$getDeclaredList->academic_shift_ids[0];
        $academicYearList=$getDeclaredList->academic_year_ids[0];
        $academicVersionList=$getDeclaredList->academic_version_ids[0];
    //    $academicVersionList=$getDeclaredList->academic_version_ids[0];

        $oldStudentInformationAdd=$getDeclaredList->old_student_information_add;


        $guardian_information_add=$getDeclaredList->guardian_information_add;
        $address_information_add=$getDeclaredList->address_information_add;
        $communication_information_add=$getDeclaredList->communication_information_add;
        $previous_institute_information_add=$getDeclaredList->previous_institute_information_add;
        $local_guardian_detail_information_add=$getDeclaredList->local_guardian_detail_information_add;
        $student_registration_number_box_show=$getDeclaredList->student_registration_number_box_show;

        $terms_condition=$getDeclaredList->terms_condition;
        $terms_condition_show_top=$getDeclaredList->terms_condition_show_top;
        $terms_condition_show_bellow=$getDeclaredList->terms_condition_show_bellow;
        $last_name_show_status=$getDeclaredList->last_name_show_status;


        $academicAdmissionTypeIDs = explode(',', $SiteInfoTableData->academic_admission_type_ids);
        $admissionlistdata = AcademicAdmissionType::whereIn('id', $academicAdmissionTypeIDs)
            ->where('status', 1)
            ->get();


        $academicStudentTypeIDs = explode(',', $SiteInfoTableData->academic_student_type_ids);
        $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();

        $relationList = Relation::all();



        return compact('academicVersionList', 'academicYearList','academicShiftList','admissionlistdata',
            'academicStudentTypeList','relationList', 'previousAcademicShiftList', 'previousAcademicYearList',
            'oldStudentInformationAdd', 'guardian_information_add','address_information_add','communication_information_add',
            'previous_institute_information_add','local_guardian_detail_information_add','student_registration_number_box_show');



    }


    /**
     * @param $version_id
     * @param $year_id
     * @return array|\Illuminate\Http\JsonResponse
     */
    public function globalGetSiteYearVersionBaseDepartmentClass($version_id, $year_id, $group_id, $shift_id)
    {


        $academicClassList = [];
        $academicDepartmentList = [];
        $academicSectionList = [];

        $site_list=$this->getSiteId();
        $getDeclaredList=$this->getDeclaredList($group_id);

      //  $academicSectionIds=$getDeclaredList->academic_section_ids[0];
       // dd($academicSectionIds);


        if ($version_id) {


            $academicDepartment = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->groupBy('academic_department_id', 'academic_class_id')
                ->pluck('academic_department_id')
                ->filter();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];


            if (count($academicDepartment) > 0) {
//                $academicDepartmentList = AcademicDepartment::whereIn('id', $academicDepartment)
//                    ->get();
                $academicDepartmentList=$getDeclaredList->academic_department_ids[0];


            } else {


                $academicClass=$getDeclaredList->academic_class_ids[1];
             //   $academicSectionIds=$getDeclaredList->academic_section_ids[1];

                $academicClass_ids = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_shift_id', $shift_id)
                    ->whereIn('academic_class_id', $academicClass)
                    ->pluck('academic_class_id');

                $academicClassList = AcademicClass::whereIn('id', $academicClass_ids)
                    ->orderBy('serial_no', 'ASC')
                    ->get();

           //     $academicSectionList = AcademicSection::whereIn('id', $academicSectionIds)->get();

            }


        } else {

            $academicDepartment = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->groupBy('academic_department_id', 'academic_class_id')
                ->pluck('academic_department_id')
                ->filter();



            if (count($academicDepartment) > 0) {
//                $academicDepartmentList = AcademicDepartment::whereIn('id', $academicDepartment)
//                    ->get();
                $academicDepartmentList=$getDeclaredList->academic_department_ids[0];
            } else {

                $academicClass=$getDeclaredList->academic_class_ids[1];
                $academicSectionIds=$getDeclaredList->academic_section_ids[1];

                $academicClass_ids = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_shift_id', $shift_id)
                    ->whereIn('academic_class_id', $academicClass)
                    ->pluck('academic_class_id');



                $academicClassList = AcademicClass::whereIn('id', $academicClass_ids)
                    ->orderBy('serial_no', 'ASC')
                    ->get();
              //  $academicSectionList = AcademicSection::whereIn('id', $academicSectionIds)->get();


                if (count($academicClass) == 0) {
                    return Response::json(['message' => 'No Class Found For The Year! Go: <a href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

                }

            }


        }


        return [$academicClassList, $academicDepartmentList, $academicSectionList];
    }





    public function globalGetDepartmentBaseClass($department_id, $year_id, $group_id){



        try {

            $site_list=$this->getSiteId();
            $getDeclaredList=$this->getDeclaredList($group_id);


            $siteClassIds =GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_department_id', $department_id)
                ->pluck('academic_class_id')->toArray();

            $declared_class_ids=$getDeclaredList->academic_class_ids[1];
            $final_class_ids = array_intersect($declared_class_ids, $siteClassIds);

            $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $final_class_ids)->get();


            return response()->json($academicClassList, 200);

        } catch (Exception $exception) {

            // dd('ggg');
            return response()->json(["message" => $exception->getMessage()], 420);


        }

    }





    public function globalGetGenderReligionBloodStudentCategoryQuataOccupationList($group_id)
    {

        $site_list=$this->getSiteId();

        $siteInfoSettinglist = GlobalSiteInfoSetting::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->first();




        $genderlistsplite = explode(',', $siteInfoSettinglist->gender_ids);
        $genderlist = Gender::whereIn('id', $genderlistsplite)->get();


        $religionlistsplite = explode(',', $siteInfoSettinglist->religion_ids);
        $religionlist = Religion::whereIn('id', $religionlistsplite)->get();


        $bloodlist = BloodGroup::get();

        $studentCategorylistsplite = explode(',', $siteInfoSettinglist->academic_student_category_ids);
        $studentCategorylist = AcademicStudentCategory::whereIn('id', $studentCategorylistsplite)->get();


        $StudentQuatalistdata = AcademicStudentQuata::where('status', 1)->get();

        $fatherOccupationlistdata = AcademicOccupation::where('status', 1)->whereNotIn('id',[2])->get();
        $motherOccupationlistdata = AcademicOccupation::where('status', 1)->whereNotIn('id',[49])->get();


        $residencelistsplite = explode(',', $siteInfoSettinglist->academic_residence_ids);
        $residencelist = AcademicResidence::whereIn('id', $residencelistsplite)->get();

        $declareList=$this->getDeclaredList($group_id);

        return compact('genderlist', 'religionlist','bloodlist','studentCategorylist',
            'StudentQuatalistdata','fatherOccupationlistdata', 'motherOccupationlistdata', 'residencelist', 'declareList');




    }



    public function globalSiteClassBaseSection($class_id, $shift_id, $class_group_id, $year_id, $group_id, $version_id)
    {

        $site_list=$this->getSiteId();

        $declareList=$this->getDeclaredList($group_id);

       // dd($declareList->academic_session_ids);

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('academic_class_id', $class_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_year_id', $year_id)
            ->whereNotNull('academic_class_group_id')
//            ->get()
            ->count();


        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::where('academic_class_id', $class_id)
            ->where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->first();



        if ($sessionPresentCheck) {
            if ($sessionPresentCheck->session_present) {
                $SiteInfoTableData = GlobalSiteInfoSetting::select('id','academic_session_ids', 'batch_present_status')
                    ->where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->first();


                $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)
                        ->whereIn('id', $declareList->academic_session_ids[1])
                        ->get();
            } else {
                $Sessionlist = [];
            }

        } else {
            $Sessionlist = [];
        }


        if (!$groupPresentCount) {

            $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('site_id', $site_list->id)
                ->where('academic_group_id', $group_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_year_id', $year_id)
//                ->get()
                ->count();

            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_version_id', $version_id)
//                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_year_id', $year_id)
                    ->first();


            } else if ($shift_id && $class_id) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_year_id', $year_id)
                    ->first();

                 //   dd($SiteClassBaseSection);

            }
        } else {
            if (!$shift_id && !$class_group_id) {
                return 4001;
            } else if ($shift_id && !$class_group_id) {
                $SiteGroup = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                    ->where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_year_id', $year_id)
                    ->get();


                $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                    ->whereIn('id', $SiteGroup)
                    ->get();


                return [2001, $sectionDataList, $Sessionlist];
            } else {
                $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                    ->where('site_id', $site_list->id)
                    ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->get()
                    ->count();


                if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                    return 4001;
                } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('site_id', $site_list->id)
                        ->where('academic_group_id', $group_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->where('academic_version_id', $version_id)
//                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_year_id', $year_id)
                        ->first();


                } else if ($shift_id && $class_id) {
                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('site_id', $site_list->id)
                        ->where('academic_group_id', $group_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_version_id', $version_id)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();


                }
            }

        }


        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $SectionData)
           // ->whereIn('id', $declareList->academic_section_ids[1])
            ->get();
    //    dd($SectionData);

        return [$SectionDataList, $Sessionlist];
    }






    public function globalGetClassGroupBaseSubjectList($classid, $class_groupid, $yearid, $department_id, $group_id)
    {



        $dept_id = $department_id;
        $site_list=$this->getSiteId();

        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
        ->pluck('id');

      /// academic subject list

    $siteClassBaseSubjectDetail =GlobalSubjectGroupConditionSetting::where('site_id', $site_list->id)
        ->where('academic_group_id', $group_id)
        ->where('academic_class_id', $classid)
        ->where('academic_year_id', $yearid)
        ->when($department_id != 'null', function ($query) use ($dept_id) {
            return $query->where('academic_department_id', $dept_id);
        })
        ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
        ->where('status', true)
        ->get();



      $general_subject_ids = [];
      foreach ($siteClassBaseSubjectDetail as $key => $value) {

          $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

          $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

          if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
              $general_subject_ids[$key] = $value->academic_subject_id;
          }
      }

      $compulsory_subject_ids = [];
      if ($class_groupid) {

          foreach ($siteClassBaseSubjectDetail as $key => $value) {

              if ($value->academic_class_group_ids) {
                  $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                  if (in_array($class_groupid, $academicClassGroupIds)) {
                      $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                      $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                      if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                          $compulsory_subject_ids[$key] = $value->academic_subject_id;
                      }
                  }
              }
          }
      }

        $academic_subjects_ids = array_merge(
            $general_subject_ids,
            $compulsory_subject_ids
        );

 //   $academic_subjects_list=AcademicSubject::whereIn('id', $academic_subjects_ids)->get();

    $academic_subjects_list=$siteClassBaseSubjectDetail->whereIn('academic_subject_id', $academic_subjects_ids)->values();

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->whereNotNull('academic_class_group_id')
            ->get()
            ->count();

        $subjectCondition=SubjectCondition::get();


        $limit_list=GlobalSiteSubjectConditionLimit::where('site_id', $site_list->id)
            ->where('academic_group_id', $group_id)
            ->where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->where('status', true)
            ->get();

        //    dd($classid);



        $classBaseOptionalSubjectIDList = [];
        $classBaseSelectiveCompulsorySubjectIDList = [];

        $optional_subject_limit=0;
        $compulsory_subject_limit=0;
        if (!$groupPresentCount && !$class_groupid) {

            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $optional_id=$subjectCondition->where('condition_key', 'optional')
                    ->first();

                $optional_sub_limit=$limit_list->where('academic_subject_condition_id', $optional_id->id)
                    ->first();


                $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();

                if ($OptionalSubjectId) {
                    if($optional_sub_limit){
                        if($optional_sub_limit->not_show_academic_subject_ids){
                            $limited_subject_list=AcademicSubject::
                            whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show=$limited_subject_list->where('id', $value->academic_subject_id)->first();
                            if(!$check_limit_not_show){
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            }
                            $optional_subject_limit=$optional_sub_limit->limit_amount?$optional_sub_limit->limit_amount:0;
                        }
                        else{
                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            $optional_subject_limit=$optional_sub_limit->limit_amount?$optional_sub_limit->limit_amount:0;
                        }
                    }
                    else{
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }


                }


                $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $selectiveCompulsory_id=$subjectCondition->where('condition_key', 'selectiveCompulsory')
                    ->first();

                $selectiveCompulsory_sub_limit=$limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                    ->first();


                $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                    ->where('condition_key', 'selectiveCompulsory')
                    ->first();

                if ($SelectiveCompulsorySubjectId) {
                    if($selectiveCompulsory_sub_limit){
                        if($selectiveCompulsory_sub_limit->not_show_academic_subject_ids){
                            $limited_compulsory_subject_list=AcademicSubject::
                            whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show_compulsory=$limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                            if(!$check_limit_not_show_compulsory){
                                $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                            }
                            $compulsory_subject_limit=$selectiveCompulsory_sub_limit->limit_amount?$selectiveCompulsory_sub_limit->limit_amount:0;
                        }
                        else{
                            $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                            $compulsory_subject_limit=$selectiveCompulsory_sub_limit->limit_amount?$selectiveCompulsory_sub_limit->limit_amount:0;
                        }
                    }
                    else{
                        $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                    }


                }
            };
        } else if ($groupPresentCount && $class_groupid) {


            $group_sub_limit_list=$limit_list->where('academic_class_group_id', $class_groupid);


            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicClassGroupIds = explode(',', $value->academic_class_group_ids);

                $academicClassGroupPresent = array_keys($academicClassGroupIds, $class_groupid);

                if ($academicClassGroupPresent) {
                    $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
                    $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                        ->where('condition_key', 'optional')
                        ->first();


                    $optional_id=$subjectCondition->where('condition_key', 'optional')
                        ->first();


                    $optional_sub_limit=$group_sub_limit_list->where('academic_subject_condition_id', $optional_id->id)
                        ->first();

                    if ($OptionalSubjectId) {

                        if($optional_sub_limit){
                            if($optional_sub_limit->not_show_academic_subject_ids){
                                $limited_subject_list=AcademicSubject::
                                whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                    ->get();

                                $check_limit_not_show=$limited_subject_list->where('id', $value->academic_subject_id)->first();
                                if(!$check_limit_not_show){
                                    $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                                }
                                $optional_subject_limit=$optional_sub_limit->limit_amount?$optional_sub_limit->limit_amount:0;
                            }
                            else{
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                                $optional_subject_limit=$optional_sub_limit->limit_amount?$optional_sub_limit->limit_amount:0;
                            }
                        }
                        else{
                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                        }

                    }


                    $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
                    $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                        ->where('condition_key', 'selectiveCompulsory')
                        ->first();


                    $selectiveCompulsory_id=$subjectCondition->where('condition_key', 'selectiveCompulsory')
                        ->first();

                    $selectiveCompulsory_sub_limit=$group_sub_limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                        ->first();


                    if ($SelectiveCompulsorySubjectId) {

                        if($selectiveCompulsory_sub_limit){
                            if($selectiveCompulsory_sub_limit->not_show_academic_subject_ids){
                                $limited_compulsory_subject_list=AcademicSubject::
                                whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                                    ->get();

                                $check_limit_not_show_compulsory=$limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                                if(!$check_limit_not_show_compulsory){
                                    $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                                }
                                $compulsory_subject_limit=$selectiveCompulsory_sub_limit->limit_amount?$selectiveCompulsory_sub_limit->limit_amount:0;
                            }
                            else{
                                $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                                $compulsory_subject_limit=$selectiveCompulsory_sub_limit->limit_amount?$selectiveCompulsory_sub_limit->limit_amount:0;
                            }
                        }
                        else{
                            $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                        }

                    }
                }
            };
        }



        // $OptionalSubjectList = AcademicSubject::
        // whereIn('id', $classBaseOptionalSubjectIDList)->get();

        // $SelectiveCompulsorySubjectList = AcademicSubject::
        // whereIn('id', $classBaseSelectiveCompulsorySubjectIDList)->get();

        $OptionalSubjectList=$siteClassBaseSubjectDetail->whereIn('academic_subject_id',$classBaseOptionalSubjectIDList)->values();
        $SelectiveCompulsorySubjectList=$siteClassBaseSubjectDetail->whereIn('academic_subject_id',$classBaseSelectiveCompulsorySubjectIDList)->values();


        //================religion subject list======================
        $classBaseReligionSubjectIDList = [];
        foreach ($siteClassBaseSubjectDetail as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            $religionSubjectId = SubjectCondition::
            whereIn('id', $academicSubjectConditionIds)
                ->where('condition_key', 'religion')
                ->first();


            if ($religionSubjectId) {
                $classBaseReligionSubjectIDList[$key] = $value->academic_subject_id;
            }

        };

        $religionSubjectList=$siteClassBaseSubjectDetail->whereIn('academic_subject_id',$classBaseReligionSubjectIDList)->values();

        // $religionSubjectList = AcademicSubject::
        // whereIn('id', $classBaseReligionSubjectIDList)->withTranslation('bn')->get();

//return $religionSubjectList;


        //================Markingless subject list======================
        $classBaseMarkinglessSubjectIDList = [];
        foreach ($siteClassBaseSubjectDetail as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            $markinglessSubjectId = SubjectCondition::
            whereIn('id', $academicSubjectConditionIds)
                ->where('condition_key', 'selectiveMarkingless')
                ->first();


            if ($markinglessSubjectId) {
                $classBaseMarkinglessSubjectIDList[$key] = $value->academic_subject_id;
            }

        };


        $markinglessSubjectList = AcademicSubject::
        whereIn('id', $classBaseMarkinglessSubjectIDList)->withTranslation('bn')->get();

        $markinglessSubjectList=$siteClassBaseSubjectDetail->whereIn('academic_subject_id',$classBaseMarkinglessSubjectIDList)->values();


//return Markingless;
                    // validation End

          //  $data = $requests->all();

            $site_list = $this->getSiteId();
            $site_id = $site_list->id;

//            return $site_list->short_name;

            $date_formate = Carbon::today();
            $today = $date_formate->format('Y-m-d');

            $admission_declare_group_list = GlobalSiteStudentAdmissionDeclare::with(['academicGroup'])
                ->select('id', 'auto_roll_create_status', 'auto_roll_digit', 'education_qualification_ids',
                    'form_number_check', 'form_show_to_website', 'site_can_not_approve_student','group_wise_roll_create_status',
                    'conflig_compulsory_subject_ids')
                ->where('site_id', $site_id)
                ->where('academic_group_id', $group_id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->first();

           //     dd($admission_declare_group_list);

        // conflig subject list

      
        if(count($admission_declare_group_list->conflig_compulsory_subject_ids[0])){

        

            $allConfligSubject = collect($SelectiveCompulsorySubjectList)
                ->merge($OptionalSubjectList)
                ->unique()
                ->values()
                ->all();

       //     $request_subject_ids = array_merge($selective_compulsory_subject_ids, $optional_subject_ids);

               // dd($request_subject_ids);

            $checkConfligSubject = collect($allConfligSubject)->filter(function ($subject) use ($admission_declare_group_list) {
                    return in_array($subject['academic_subject_id'], $admission_declare_group_list->conflig_compulsory_subject_ids[1]);
                })->values();


            $subjectNames = $checkConfligSubject->pluck('subject_name')->values(); 

            if ($subjectNames->count() > 1) {
                $last = $subjectNames->pop(); 
                $subject_array = $subjectNames->implode(', ') . ' and ' . $last;
            } else {
                $subject_array = $subjectNames->first() ?? '';
            }

            $conflig_subject_message='';
            if(count($checkConfligSubject)>1){
                 $conflig_subject_message='You may take any one subject from '.$subject_array;
            }
        }else{
            $conflig_subject_message='';
        }




        return [$religionSubjectList, $SelectiveCompulsorySubjectList, $OptionalSubjectList, $markinglessSubjectList,
            $compulsory_subject_limit, $optional_subject_limit,$academic_subjects_list,$conflig_subject_message];

    }




    public function globalGetCountryList(){

        $site_list=$this->getSiteId();
        $site_country_id=GlobalSiteInfo::select('country_id')->where('id', $site_list->id)->first();
        $CountryList = Country::where('status', 1)
            ->where('id', $site_country_id->country_id)
            ->get();

        return $CountryList;
    }




    public function globalGetDivisionByCountryId($countryId)
    {

        $divisionOfCountry = Division::whereCountryId($countryId)->get();


        return $divisionOfCountry;
    }


    public function globalGetDistrictByDivisionId($divisionId){
        $districtOfDivision = District::whereDivisionId($divisionId)->get();
        return $districtOfDivision;
    }


    public function globalGetThanaListByDistrictId($distroctId){
        try {
            $thanaOfDistrict =Thana::whereDistrictId($distroctId)->get();
            //$subjectOfClass = $subject->whereStudentClassId($divisionId)->get();
            //return $districtOfDivision;


            return $thanaOfDistrict;
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Thana Not Found', 410]);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }

    public function createStudentEntryApplication(SiteStudentRegistrationApplication $student, Request $requests){

        DB::beginTransaction();


        try {

            $this->validate($requests, [
                "academic_version_id" => "required",
                "academic_year_id" => "required",
                "academic_shift_id" => "required",
                "academic_class_id" => "required",
                'first_name' => 'required',
                'father_name' => 'required',
                'mother_name' => 'required',
                "religion_id" => "required",
                "gender_id" => "required",
                "student_contact_number" => "required",
                "academic_student_category_id" => "required",
                "date_of_birth" => "required",
              //  "birth_certificate_no" => "required",
                "student_roll_number" => "required",

                "previous_exam_mark" => $requests->previous_institute_name ? "required" : "",
                "academic_section_id" => count($requests->AcademicSectionList)>0 ? "required" : "",
                "academic_class_group_id" => count($requests->AcademicClassGroupList)>0 ? "required" : "",

                "tc_number" => $requests->previous_institute_name ? "required" : "",
                "tc_date" => $requests->previous_institute_name ? "required" : "",
                "local_gurdian_name" => $requests->local_gurdian_name ? "required" : "",
//                "relation_id" => $requests->local_gurdian_name ? "required" : "",
                "local_gurdian_mobile" => $requests->local_gurdian_name ? "required" : "",


                "academic_session_id" => count($requests->AcademicSessionList) > 0 ? "required" : "",
                "religion_subject_id" => count($requests->ReligionSubjectList) > 0 ? "required" : "",
            ]);



            $data = $requests->all();
            $site_list=$this->getSiteId();
            $site_id = $site_list->id;

          

            if($requests->compulsory_subject_limit){
                if(is_array($requests->compulsory_subject_ids)){
                    $compulsory_subject_ids_list=$requests->compulsory_subject_ids;
                }else{
                    $compulsory_subject_ids_list[]=$requests->compulsory_subject_ids;
                }

                if($requests->compulsory_subject_limit<count($compulsory_subject_ids_list) ||
                    $requests->compulsory_subject_limit>count($compulsory_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->compulsory_subject_limit . ' Compulsory Subject!.',
                        'mode' => 'Error'], 412);
                }

            }

            if($requests->optional_subject_limit){
                if(is_array($requests->optional_subject_ids)){
                    $optional_subject_ids_list=$requests->optional_subject_ids;
                }else{
                    $optional_subject_ids_list[]=$requests->optional_subject_ids;
                }

                if($requests->optional_subject_limit<count($optional_subject_ids_list) ||
                    $requests->optional_subject_limit>count($optional_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->optional_subject_limit . ' Optional Subject!.',
                        'mode' => 'Error'], 412);
                }

            }



            $date_formate = Carbon::today();
            $today=$date_formate->format('Y-m-d');

            $registration_declare_group_list=GlobalSiteBaseStudentRegistrationDeclare::with(['academicGroup'])
                ->select('id')
                ->where('site_id', $site_list->id)
                ->where('academic_group_id', $requests->academic_group_id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->first();

        $date_formate = Carbon::parse($requests->date_of_birth);
        $date_of_birth=$date_formate->format('Y-m-d');


//            $studentList = SiteStudentRegistrationApplication::where('first_name', $requests->first_name)
//                ->where('father_name', $requests->father_name)
//                ->where('mother_name', $requests->mother_name)
//                ->where('site_id', $site_id)
//                ->where('date_of_birth', $date_of_birth)
//                ->first();


            $getStudentSameBirthDate=SiteStudentRegistrationApplication::where('site_id', $site_id)
                ->where('date_of_birth', $date_of_birth)
                ->select('id', 'first_name', 'last_name', 'father_name', 'mother_name')
                ->get();



            $full_name_request=($requests->first_name) . ($requests->last_name?$requests->last_name:'');

            if(count($getStudentSameBirthDate)>0){

                foreach ($getStudentSameBirthDate as $key=>$value) {
                    $full_name_with_out_space = strtoupper(str_replace(' ', '',  $value->full_name));
                    $father_name_with_out_space = strtoupper(str_replace(' ', '',  $value->father_name));
                    $mother_name_with_out_space = strtoupper(str_replace(' ', '',  $value->mother_name));


                    $present_full_name_with_out_space = strtoupper(str_replace(' ', '',  $full_name_request));
                    $present_father_name_with_out_space = strtoupper(str_replace(' ', '',  $requests->father_name));
                    $present_mother_name_with_out_space = strtoupper(str_replace(' ', '',  $requests->mother_name));

//                    return [$full_name_with_out_space, $father_name_with_out_space, $mother_name_with_out_space,
//                    $present_full_name_with_out_space, $present_father_name_with_out_space,
//                        $present_mother_name_with_out_space];

                    if($full_name_with_out_space==$present_full_name_with_out_space &&
                        $father_name_with_out_space==$present_father_name_with_out_space &&
                        $mother_name_with_out_space==$present_mother_name_with_out_space){

                        $student_birth_date_present_array[]=1;

                    }else{
                        $student_birth_date_present_array[]=0;
                    }



                }

            }else{
                $student_birth_date_present_array[]=0;
            }



            $student_birth_date_present_count=collect($student_birth_date_present_array)->unique()->filter();
            if(count($student_birth_date_present_count)>0){
                $student_birth_date_present=1;
            }else{
                $student_birth_date_present=0;
            }




            $studentCheckList = SiteStudentRegistrationApplication::select('id')
                ->where('academic_group_id', $requests->academic_group_id)
                ->where('academic_version_id', $requests->academic_version_id)
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('student_roll_number', $requests->student_roll_number)
                ->where('site_id', $site_id)
                ->where('status', true)
                ->first();


            if($requests->student_image=='image-not.png'){
                return Response::json(['message' => 'You must be attach your passport size photo!'], 412);
            } else if (!$requests->date_of_birth && !$requests->student_roll_number) {
                return Response::json(['message' => 'You must be fill up Date of birth Or Roll Number Field!'], 412);

            } else if ($requests->date_of_birth && !$requests->student_roll_number) {

                if ($student_birth_date_present==1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }

            } else if (!$requests->date_of_birth && $requests->student_roll_number) {

                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number'], 412);

                }


            } else if ($requests->date_of_birth && $requests->student_roll_number) {
                if ($student_birth_date_present==1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }
                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number!'], 412);
                }
            }




        $academicSubjectIDs = $this->academicSubjectList($requests);

        $savePhoto=$this->savePhoto($requests);

        $unique_code= intval( "0" . rand(1,9) . rand(0,9) . rand(0,9) . rand(0,9) . rand(0,9). rand(1,9) .
                rand(0,9) . rand(0,9) . rand(0,9) ).$site_id;


            $clientIP = request()->ip();



        if (isset($student->ownFields)) {
                foreach ($student->ownFields as $studentField) {
                    if ($requests->{$studentField}) {
                        if (is_array($requests->{$studentField})) {
                            $student->{$studentField} = collect($requests->{$studentField})->implode(',');
                        } else {
                            $student->{$studentField} = $requests->{$studentField};

                        }
                    }
                }
                $student->academic_subject_ids = $academicSubjectIDs;
                $student->unique_code = $unique_code;
                $student->student_image = $savePhoto;
                $student->site_id = $site_id;
                $student->client_ip = $clientIP;
                $student->site_base_student_registration_declare_id = $registration_declare_group_list->id;
            }
            $student->save();




            $message = [$student->full_name, $unique_code];


        $registration_declare_list=GlobalSiteBaseStudentRegistrationDeclare::where('site_id', $site_id)
            ->where('academic_group_id', $requests->academic_group_id)
            ->where('status', true)
            ->first();



            if ($registration_declare_list->send_sms) {
                if ($requests->student_contact_number) {

                    $url = config('app.url');

                    $sms_txt = 'Congrats, ' . ucwords($student->full_name);
                    $sms_txt .= '[nl]' . $url;
                    $sms_txt .= '[nl]' . 'Your Unique Code: ' . $unique_code;
                    $sms_txt .= '[nl]' . 'Regards: ' . $site_list->site_name;

                    $tt = $this->sendSms($site_id, [$requests->student_contact_number], $sms_txt);
                } else {
                    DB::rollBack();
                    throw new Error('Please Input Contact Number Field');
                }
            }


            DB::commit();
            return Response::json(['message' => $message, 'mode' => 'Registred!'], 200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }









    }






    private function savePhoto(Request $requests)
    {


        if ($requests->student_image == "image-not.png") {
            $fileName = $requests->student_image;
        } else {
            $name = time() . '.' . explode('/', explode(':', substr($requests->student_image, 0, strpos($requests->student_image, ';')))[1])[1];
            $fileName = $name;
            Image::make($requests->student_image)->resize(440, 442)->save(public_path('uploads/') . $name);

        }



        return $fileName;

    }



    private function academicSubjectList($requests)
    {
        $data = $requests->all();
        $site_list=$this->getSiteId();
        $site_id = $site_list->id;

        $subjectList = GlobalSubjectGroupConditionSetting::where('academic_class_id', $data['academic_class_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('site_id', $site_id)
            ->where('academic_group_id', $data['academic_group_id'])
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->get();
        //    dd($subjectList);


        $general_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $general_markingless_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

            $markinglessSubjectCondition = SubjectCondition::where('condition_key', 'generalMarkingless')->first();

            if (in_array($markinglessSubjectCondition->id, $academicSubjectConditionIds)) {
                $general_markingless_subject_ids[$key] = $value->academic_subject_id;
            }
        }


        $compulsory_subject_ids = [];
        if ($requests->academic_class_group_id) {

            foreach ($subjectList as $key => $value) {

                if ($value->academic_class_group_ids) {
                    $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                    if (in_array($requests->academic_class_group_id, $academicClassGroupIds)) {
                        $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                        $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                        if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                            $compulsory_subject_ids[$key] = $value->academic_subject_id;
                        }
                    }
                }
            }
        }

        $compulsory_subject_idList = [];
        if ($requests->compulsory_subject_ids) {
            if (is_array($requests->compulsory_subject_ids)) {
                $compulsory_subject_idList = $requests->compulsory_subject_ids;
            }else{
                $compulsory_subject_idList[] = $requests->compulsory_subject_ids;
            }

        }

        $Optional_subject_idList = [];
        if($requests->optional_subject_ids){
            if (is_array($requests->optional_subject_ids)) {
                $Optional_subject_idList = $requests->optional_subject_ids;
            }else{
                $Optional_subject_idList[] = $requests->optional_subject_ids;
            }
        }


        $selective_markingless_subject_idList = [];
        if ($requests->selective_markingless_subject_ids) {
            if (is_array($requests->selective_markingless_subject_ids)) {
                $selective_markingless_subject_idList = $requests->selective_markingless_subject_ids;
            }else{
                $selective_markingless_subject_idList[] = $requests->selective_markingless_subject_ids;
            }
        }


        $religion_subject = [];
        if ($requests->religion_subject_id) {
            $religion_subject[] = $requests->religion_subject_id;
        }
        $Subjects = array_merge(
            $general_subject_ids, $general_markingless_subject_ids,
            $compulsory_subject_ids,
            $compulsory_subject_idList, $Optional_subject_idList,
            $selective_markingless_subject_idList,
            $religion_subject
        );

        $academicSubjectIds = (string)implode(',', $Subjects);
        $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));
        $finalAcademicSubjectIds = (string)implode(',', $academicSubjectIdst);

        return $finalAcademicSubjectIds;
    }





    public function globalGetAppliedStudentDetailForEdit($unique_code){

        $site_list=$this->getSiteId();
        $date_formate = Carbon::today();
        $today=$date_formate->format('Y-m-d');



        $student_list=SiteStudentRegistrationApplication::where('unique_code', $unique_code)
            ->where('status', true)
            ->where('site_id', $site_list->id)
            ->first();


        if($student_list){
            $registration_declare_group_present=GlobalSiteBaseStudentRegistrationDeclare::where('site_id', $site_list->id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->where('academic_group_id', $student_list->academic_group_id)
                ->first();

            if($registration_declare_group_present){

                if($student_list->approve_as_student==1){
                    $student_final_list=1;
                }else{
                    $student_final_list=$student_list;
                }



            }
            else{
                $student_final_list=0;
            }
        }
        else{
            $student_final_list=0;
        }





        return $student_final_list;

    }


    public function updateStudentEntryApplication(Request $requests)
    {

        try {
            DB::beginTransaction();


            $this->validate($requests, [
                'first_name' => 'required',
                'father_name' => 'required',
                'mother_name' => 'required',
                "religion_id" => "required",
                "gender_id" => "required",
                "academic_student_category_id" => "required",
                "student_contact_number" => "required",
                "date_of_birth" => "required",
              //  "birth_certificate_no" => "required",
                "student_roll_number" => "required",

                "academic_section_id" => count($requests->AcademicSectionList)>0 ? "required" : "",
                "academic_class_group_id" => count($requests->AcademicClassGroupList)>0 ? "required" : "",

                "previous_exam_mark" => $requests->previous_institute_name ? "required" : "",
                "tc_number" => $requests->previous_institute_name ? "required" : "",
                "tc_date" => $requests->previous_institute_name ? "required" : "",
                "local_gurdian_name" => $requests->local_gurdian_name ? "required" : "",
                "relation_id" => $requests->local_gurdian_name ? "required" : "",
                "local_gurdian_mobile" => $requests->local_gurdian_name ? "required" : "",

                "academic_session_id" => count($requests->AcademicSessionList) > 0 ? "required" : "",
                "religion_subject_id" => count($requests->ReligionSubjectList) > 0 ? "required" : "",

            ]);

            $data = $requests->all();
            $site_list = $this->getSiteId();
            $site_id = $site_list->id;

            if($requests->compulsory_subject_limit){
                if(is_array($requests->compulsory_subject_ids)){
                    $compulsory_subject_ids_list=$requests->compulsory_subject_ids;
                }else{
                    $compulsory_subject_ids_list[]=$requests->compulsory_subject_ids;
                }

                if($requests->compulsory_subject_limit<count($compulsory_subject_ids_list) ||
                    $requests->compulsory_subject_limit>count($compulsory_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->compulsory_subject_limit . ' Compulsory Subject!.',
                        'mode' => 'Error'], 412);
                }

            }

            if($requests->optional_subject_limit){
                if(is_array($requests->optional_subject_ids)){
                    $optional_subject_ids_list=$requests->optional_subject_ids;
                }else{
                    $optional_subject_ids_list[]=$requests->optional_subject_ids;
                }

                if($requests->optional_subject_limit<count($optional_subject_ids_list) ||
                    $requests->optional_subject_limit>count($optional_subject_ids_list)){
                    return Response::json(['message' => 'Please Choose ' . $requests->optional_subject_limit . ' Optional Subject!.',
                        'mode' => 'Error'], 412);
                }

            }



            $date_formate = Carbon::parse($requests->date_of_birth);
            $date_of_birth = $date_formate->format('Y-m-d');


            $getStudentSameBirthDate = SiteStudentRegistrationApplication::where('site_id', $site_id)
                ->where('date_of_birth', $date_of_birth)
                ->where('id', '!=', $requests->id)
                ->select('id', 'first_name', 'last_name', 'father_name', 'mother_name')
                ->get();


            $full_name_request = ($requests->first_name) . ($requests->last_name ? $requests->last_name : '');

            if (count($getStudentSameBirthDate) > 0) {

                foreach ($getStudentSameBirthDate as $key => $value) {
                    $full_name_with_out_space = strtoupper(str_replace(' ', '', $value->full_name));
                    $father_name_with_out_space = strtoupper(str_replace(' ', '', $value->father_name));
                    $mother_name_with_out_space = strtoupper(str_replace(' ', '', $value->mother_name));


                    $present_full_name_with_out_space = strtoupper(str_replace(' ', '', $full_name_request));
                    $present_father_name_with_out_space = strtoupper(str_replace(' ', '', $requests->father_name));
                    $present_mother_name_with_out_space = strtoupper(str_replace(' ', '', $requests->mother_name));

//                    return [$full_name_with_out_space, $father_name_with_out_space, $mother_name_with_out_space,
//                    $present_full_name_with_out_space, $present_father_name_with_out_space,
//                        $present_mother_name_with_out_space];

                    if ($full_name_with_out_space == $present_full_name_with_out_space &&
                        $father_name_with_out_space == $present_father_name_with_out_space &&
                        $mother_name_with_out_space == $present_mother_name_with_out_space
                    ) {

                        $student_birth_date_present_array[] = 1;

                    } else {
                        $student_birth_date_present_array[] = 0;
                    }


                }

            } else {
                $student_birth_date_present_array[] = 0;
            }


            $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
            if (count($student_birth_date_present_count) > 0) {
                $student_birth_date_present = 1;
            } else {
                $student_birth_date_present = 0;
            }


            //  throw new \Error($requests->user_id);
            //  throw new \Error($studentList);

            $studentCheckList = SiteStudentRegistrationApplication::select('id')
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('student_roll_number', $requests->student_roll_number)
                ->where('id', '!=', $requests->id)
                ->first();


            if($requests->student_image=='image-not.png'){
                return Response::json(['message' => 'You must be attach your passport size photo!'], 412);
            }
            else if (!$requests->date_of_birth && !$requests->student_roll_number) {
                return Response::json(['message' => 'You must be fill up Date of birth Or Roll Number Field!'], 412);

            } else if ($requests->date_of_birth && !$requests->student_roll_number) {

                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student already present!'], 412);
                }

            } else if (!$requests->date_of_birth && $requests->student_roll_number) {

                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number'], 412);
                }

            } else if ($requests->date_of_birth && $requests->student_roll_number) {
                if ($student_birth_date_present == 1) {
                    return Response::json(['message' => 'This Student Already Present.'], 412);
                }
                if ($studentCheckList) {
                    return Response::json(['message' => 'Please change roll number!'], 412);
                }

            }


            $academicSubjectIDs = $this->academicSubjectList($requests);


            $student = SiteStudentRegistrationApplication::where('id', $requests->id)->first();


            if ($student->student_image == $requests->student_image) {
                $image_name = $student->student_image;
            } else {
                if ($student->student_image != 'image-not.png') {
                    $image_path = "uploads/" . $student->student_image;  // Value is not URL but directory file path
                    if (File::exists($image_path)) {
                        File::delete($image_path);
                    }

                    $image_name = $this->savePhoto($requests);

                } else if ($student->student_image == 'image-not.png') {

                    $image_name = $this->savePhoto($requests);

                }

            }


            $clientIP = request()->ip();


            if (isset($student->ownFields)) {
                foreach ($student->ownFields as $studentField) {
                    if ($requests->{$studentField}) {
                        if (is_array($requests->{$studentField})) {
                            $student->{$studentField} = collect($requests->{$studentField})->implode(',');
                        } else {
                            $student->{$studentField} = $requests->{$studentField};

                        }
                    }
                }

                $student->site_id = $site_id;
                $student->student_image = $image_name;
                $student->academic_subject_ids = $academicSubjectIDs;
//            $student->client_ip = $clientIP;
            }
            $student->save();


//        if ($student->save()) {
//            if (strpos($requests->student_image, 'base64')) {
//                $this->savePhoto($student, $requests);
//            }
//
//        }

            DB::commit();
            return Response::json(['message' => 'Information Update Successfully!', 'mode' => 'Update!']);


        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();

            return Response::json(['message' => $exception->getMessage()], 410);


        }
    }




}
