<?php

namespace App\Http\Controllers\SitePublic\Site;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Examinations\Examination;
use App\Models\Session\PaymentSession;
use App\Models\Student\StudentHistory;
use Exception;
use Illuminate\Support\Facades\Auth;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Student\Student;
use App\Models\User\GlobalUser;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use App\Traits\Site\Fee\StudentFeeTrait;
use Response;
use Session;
use Carbon\Carbon;
use PDF;
use Carbon\CarbonPeriod;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Storage;
use File;
use Error;

class PublicStudentFeeController extends Controller
{
    use SonaliPayStudentFeeTrait, StudentFeeTrait;


    public function __construct()
    {


    }

   

    public function getStudentFeeInfo(Request $request){

   
            try{

            $site_id=$this->getSiteId();

            $siteInfo= GlobalSiteInfo::where('id',$site_id)->select('id','web_student_fee_collection_status','show_subhead_in_payment_slip')
                ->first();

            if($siteInfo->web_student_fee_collection_status==false){
                 return response()->json(['message'=>'permission denied!'],410);
            }

            $student=Student::where('username',$request->student_username)->where('site_id',$site_id)->first();


            if(!$student){
                return response()->json(['message'=>'Data not found!'],410);
            }


            $student_id = $student->id;
            $studentHistoryIDList=GlobalStudentHistory::where('user_id',$student_id)
                ->where('site_id',$site_id)
                ->where('status',true)
                ->pluck('id');


            $demand_slip = GlobalSiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
                $query->whereIn('student_history_id', $studentHistoryIDList)
                    ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
                })
                ->where('status', 1)
                ->where('site_id', $site_id)
                ->orderBy('id', 'desc')
                ->first();
     

            if(!$demand_slip){
                return response()->json(['message'=>'Payment not found!'],410);
            }

        

            $studentHistory=GlobalStudentHistory::whereIn('id',$studentHistoryIDList)->where('status',true)->first();

            $student_details=[
                'student_name'=>$studentHistory->full_name,
                'student_username'=>$student->username,
                'shift'=>$studentHistory->shift?$studentHistory->shift->shift_name:null,
                'year'=>$studentHistory->year?$studentHistory->year->year_name:null,
                'class_name'=>$studentHistory->stClass?$studentHistory->stClass->class_name:null,
                'group_name'=>$studentHistory->classGroup?$studentHistory->classGroup->group_name:null,
                'section_name'=>$studentHistory->section?$studentHistory->section->section_name:null,
                'session_name'=>$studentHistory->session?$studentHistory->session->session_name:null,
                'roll'=>$studentHistory->student_full_roll_number,
            ];

        


           $slipData =$this->studentSlipDetails($demand_slip->id);


            return ['fee_data'=>$slipData['fee_data'],'payment_method_list'=>$slipData['payment_method_list'],'student_details'=>$student_details, 'username'=>$request->student_username,'site_info'=>$siteInfo];

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

   
        
    public function convertNumberToWord($num = false)
    {
        $num = str_replace(array(',', ' '), '', trim($num));
        if (!$num) {
            return false;
        }
        $num = (int)$num;
        $words = array();
        $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven',
            'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
        );
        $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');
        $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion',
            'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion',
            'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion'
        );
        $num_length = strlen($num);
        $levels = (int)(($num_length + 2) / 3);
        $max_length = $levels * 3;
        $num = substr('00' . $num, -$max_length);
        $num_levels = str_split($num, 3);
        for ($i = 0; $i < count($num_levels); $i++) {
            $levels--;
            $hundreds = (int)($num_levels[$i] / 100);
            $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' hundred' . ' ' : '');
            $tens = (int)($num_levels[$i] % 100);
            $singles = '';
            if ($tens < 20) {
                $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
            } else {
                $tens = (int)($tens / 10);
                $tens = ' ' . $list2[$tens] . ' ';
                $singles = (int)($num_levels[$i] % 10);
                $singles = ' ' . $list1[$singles] . ' ';
            }
            $words[] = $hundreds . $tens . $singles . (($levels && ( int )($num_levels[$i])) ? ' ' . $list3[$levels] . ' ' : '');
        } //end for loop
        $commas = count($words);
        if ($commas > 1) {
            $commas = $commas - 1;
        }
        return implode(' ', $words);
    }
    

        public function getStudentBankSlipPdfForPublic($username)
        {
            $site_id=$this->getSiteId();
            $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

            if(!$siteInfo->web_student_fee_collection_status){
                    return response()->json(['message'=>'permission denied'],410);
            }

            //  dd($username);

            $student=Student::where('username',$username)->where('site_id',$site_id)->first();

            if(!$student){
                return 'Data not found!';
            }

            $student_id = $student->id;
            $studentHistoryIDList=GlobalStudentHistory::where('user_id',$student_id)->where('site_id',$site_id)->where('status',true)->pluck('id');
            // $demand_slip=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
            //     ->where('status',1)
            //     ->where('site_id',$site_id)
            //     ->orderBy('id', 'desc')
            //     ->first();


            $demand_slip = GlobalSiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
                $query->whereIn('student_history_id', $studentHistoryIDList)
                    ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
                })
                ->where('status', 1)
                ->where('site_id', $site_id)
                ->orderBy('id', 'desc')
                ->first();
     

             //   dd($demand_slip);

                if(!$demand_slip){
                    return 'Payment not found!';
                }
                       
    
            $studentSlip=$this->studentSlipDetails($demand_slip->id);
   
            $student_info = $studentSlip['student_info'];
            $fee_data = $studentSlip['fee_data'];
         //   $slip_quantity = [1,2,3];
    
            $title_view = 'Demand Slip';
            $slip_for = 'student';
            $slip_quantity = [1,2];
    
           $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-bank-slip-pdf',
                    compact('title_view','slip_quantity','fee_data','student_info','slip_for','siteInfo'));
            return $pdf->stream(time() . '-student-payment-bank-slip.pdf');


        }

        public function createStudentPayment(Request $request){

                try{
                $site_id=$this->getSiteId();

                $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

                if($siteInfo->student_fee_collection_status){
                    if(!$siteInfo->web_student_fee_collection_status){
                        return response()->json(['message'=>'permission denied'],410);
                    }

                }else{
                    return response()->json(['meessage'=>'The service is temporarily unavailable, please try again after some time.','status'=>'404'],404);
                }


                $username=$request->student_username;

                $student=Student::where('username',$username)->where('site_id',$site_id)->first();

                if(!$student){
                    return response()->json(['message'=>'Data not found!'],410);
                }

                $user_id = $student->id;
            

                if($request->gateway_name_key == 'nagad'){
                    $this->paymentTakeByNagadTransactionID($request);
                }else if($request->name_key == 'bkash'){
                    return response()->json(['message'=>'Developing This System ', 'status'=>'403', 'mode'=>'success']); 
                }else if($request->gateway_name_key == 'surecash'){
                    return response()->json(['message'=>'Developing This System ', 'status'=>'403', 'mode'=>'success']);    
                
                }else if($request->payment_method=='sonali_pay'){

                    $request_data=[
                        'site_id'=>$site_id,
                        'user_id'=>$user_id,
                        'username'=>$username,
                        'request_amount'=>$request->payable_amount,
                        'redirect_path'=>"/web/sonali-pay-message"
                    ];
            
                    $api_response = $this->studentFeeInfoForSonaliPay($request_data);

                
                    $data=[
                        'gateway_link'=>isset($api_response['RedirectToGateway'])?$api_response['RedirectToGateway']:null,
                        'message'=>$api_response['Message'],
                        'status'=>$api_response['Status'],
                     //   'time'=>isset($api_response['Time'])?$api_response['Time']:null
                    ];

                    return response()->json($data);
                                        
                    
                }

            } catch (ValidationException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
            }catch (ModelNotFoundException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
            } catch (Exception $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
            }
        }


        public function checkSonaliPayTokenModeForWeb(Request $request){


            $data=$request->all();

            $site_id=$this->getSiteId();

            $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('site_id',$site_id)
                ->where('transaction_token',$data['Token'])
                ->orderBy('id', 'desc')
                ->where('status',1)
                ->first();

            if(!$demand_slip_details){
                $response=[
                    'Status'=>'411',
                    'Message'=>'Slip not found!',
                ];
            }
            

            $studentHistory=GlobalStudentHistory::where('id',$demand_slip_details->student_history_id)->first();

            if(!$demand_slip_details){
                $response=[
                    'Status'=>'411',
                    'Message'=>'Student not found!',
                ];
            }
    
            //session check
            $currentTime = Carbon::now('Asia/Dhaka');
            $session=PaymentSession::where('user_id',$studentHistory->user_id)
                ->where('end_date_time','>',$currentTime)
                ->where('token',$data['Token'])
                ->where('ip_address',request()->ip())
                ->where('status',1)
                ->orderBy('id','DESC')
                ->first();
            
            if(!$session){      
                $response=[
                    'Status'=>'403',
                    'Message'=>'Payment Session expired!',
                ];
    
                return $response;
            }

            $user_id=$studentHistory->user_id;

            $user=Student::where('id',$user_id)->first();
    
    
            $site_id=$studentHistory->site_id;
        //    $academic_group_id=$studentHistory->academic_group_id;
            $username = $user->username;
            $user_id =$user_id;
           
           $req_data=[
                'site_id'=>$site_id,
            //    'academic_group_id'=>$academic_group_id,
                'username'=>$username,
                'user_id'=>$user_id,
            ];
    
            if($data['Mode']==='success'){ 
                
              $req_response=$this->feePaymentAndSonaliPayTokenVerify($data,$req_data);
    
              if($req_response['Status']=='200'){

                $host = request()->getSchemeAndHttpHost();
                $site_voucher_link=$host.'/site-public/get-site-public-payment-slip/'.$req_response['InvoiceNo'].'/'.$req_response['TransactionId'];
                $req_response['site_voucher_link']=$site_voucher_link;
                $response=$req_response;
              }else{
                $response=[
                    'Status'=>$req_response['Status'],
                    'Message'=>'Your transaction was unsuccessful',
                ];
              }
    
            }else{
                $response=[
                    'Status'=>'400',
                    'Message'=>'Your transaction was unsuccessful. Please check and retry!',
                    'Details'=>'Mode failed'
                ];
    
                $response_test=json_encode($response);
    
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$response_test;
                $issue->site_id=$req_data['site_id'];
                $issue->username=$req_data['username'];
                $issue->ip_address=request()->ip();
                $issue->save();
    
            }
    
            // session clear
            $session->status=0;
            $session->save();
    
            return $response;
        }
    

       
        public function getSiteId()
        {
    
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
         
            return $site_id;
        }

        public function getWebPaymentStatusMessage(){
            $viewType = 'Student Payment';
            return view('default.admin.layouts.master', compact('viewType'));
        }


        public function getPublicStudentPaymentSlip($voucher_no,$tr_id){

            try{
                $site_id=$this->getSiteId();

                

                $check_payment = GlobalSiteStudentFeePaymentHistory::where('voucher_no', $voucher_no)
                ->where('transaction_id',$tr_id)
                ->where('site_id',$site_id)
                ->first();

               // dd($check_payment);

                if (!$check_payment) {
                   return 'Data not found!';
                }
             

                $payment_details = $this->paymentSlipData($voucher_no);

               // dd($payment_details);

                if($payment_details['status']!=200){
                    return $payment_details['message'];
                }
                $payment_data=$payment_details['payment_data'];
                $student_info=$payment_details['student_info'];
        
                $report_tittle ='Student Fee Voucher';
                $report_tittle2  ='';
                $title_view='Student Fee Voucher';

                $siteInfo= GlobalSiteInfo::where('id',$site_id)
                ->select('id','web_student_fee_collection_status','show_subhead_in_payment_slip')
                ->first();
                
                $slip_key='student';
                
                $pdf = PDF::loadView('default.admin.site.student-fee.report.student-payment-voucher-pdf',
                    compact('title_view','report_tittle','report_tittle2','payment_data','student_info','siteInfo','slip_key'));
        
                return $pdf->stream(time() . '-student-payment-slip.pdf');
    
            } catch (ValidationException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
            }catch (ModelNotFoundException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
            } catch (Exception $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
            }
    
    }
   

}
