<?php

namespace App\Http\Controllers\SitePublic\Site;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Session\AdmissionPaymentSession;
use Exception;
use App\Models\Site\Fee\GlobalSiteAdmissionFeeGatewaySetting;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\StudentAdmission\GlobalSiteAdmissionPaymentHistory;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionFeeGenerate;
use App\Traits\Site\Fee\AdmissionFeeTrait;
use App\Traits\Site\Fee\SonaliPayAdmissionFeeTrait;
use Session;
use Carbon\Carbon;
use PDF;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use File;
use Error;

class PublicAdmissionFeeController extends ProjectController
{
    use SonaliPayAdmissionFeeTrait, AdmissionFeeTrait;


    public function __construct()
    {


    }

   

    public function getAdmissionFeeInfo(Request $request){

    
        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');
       
        $site_id=$this->getSiteId();

        $siteInfo= GlobalSiteInfo::where('id',$site_id)->select('id','admission_fee_collection_status','show_subhead_in_payment_slip')->first();
  
        if($siteInfo->admission_fee_collection_status==false){
             return response()->json(['message'=>'permission denied!'],410);
        }
  
        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');
  
        $borad_approve_student=GlobalSiteStudentAdmissionBoardApprove::with('siteStudentAdmissionDeclare','stClass','year','session','academicBoard','classGroup')
            ->where('site_id',$site_id)
            ->whereHas('siteStudentAdmissionDeclare')
            ->where('board_roll_number', $request->reference_id)
            ->where('payment_status',0)
            ->where('admission_status',0)
            ->where('status',1)
            ->first();
  
      //    dd($borad_approve_student);
  
        if(!$borad_approve_student){
             return response()->json(['message'=>'Data not found!'],410);
        }

        $chdckAdmissionFee = GlobalSiteStudentAdmissionFeeGenerate::where('site_id',$site_id)
            ->where('academic_group_id',$borad_approve_student->academic_group_id)
            ->where('site_student_admission_board_approve_id',$borad_approve_student->id)
            ->where('status',true)
            ->get();

        if(count($chdckAdmissionFee)==0){
             return response()->json(['message'=>'Amount not found!'],410);
        }

        $generated_sub_head_ids = GlobalSiteStudentAdmissionFeeGenerate::where('site_id',$site_id)
            ->where('academic_group_id',$borad_approve_student->academic_group_id)
            ->where('site_student_admission_board_approve_id',$borad_approve_student->id)
            ->where('status',true)
            ->orderBy('academic_fee_sub_head_id')
            ->pluck('academic_fee_sub_head_id')
            ->unique()
            ->filter()
            ->values();

        $bank_settings=GlobalSiteAdmissionFeeGatewaySetting::where('fee_type_key','admission_fee')
            ->where('academic_fee_head_id',1)
            ->whereIn('academic_fee_sub_head_id',$generated_sub_head_ids)
            ->where('status',true)
            ->get();

        //    dd($bank_settings);

        foreach($generated_sub_head_ids as $key=>$sub_head_id){
                $fee_sub_head=$bank_settings->where('academic_fee_sub_head_id',$sub_head_id)->first();
                if(!$fee_sub_head){
                    return response()->json(['message'=>'Your setup is not complete. Please contact the administrator','status'=>'410'],410);
                }
            }

     
        $fee_list=[];
        $total_amount=0;
        foreach($chdckAdmissionFee as $key=>$fee){
            $fee_list[$key]['academic_fee_sub_head']=$fee->academicFeeSubHead?$fee->academicFeeSubHead->name:'';
            $fee_list[$key]['amount']=$fee->amount;
            $total_amount+=$fee->amount;
        }

      //  dd($borad_approve_student,$total_amount,$borad_approve_student->admission_fee);

        if($total_amount==0){
            return response()->json(['message'=>'Amount null!','status'=>'410'],410);
        }

        if($total_amount!=$borad_approve_student->total_admission_fee){
            return response()->json(['message'=>'Fee amount mismatch!','status'=>'410'],410);
        }


        $condidate_info=[];
        $condidate_info['student_name'] = $borad_approve_student->first_name?$borad_approve_student->first_name:'';
        $condidate_info['father_name'] = $borad_approve_student->father_name?$borad_approve_student->father_name:'';
        $condidate_info['mother_name'] = $borad_approve_student->mother_name?$borad_approve_student->mother_name:'';
        $condidate_info['year_name'] = $borad_approve_student->year?$borad_approve_student->year->year_name:'';
        $condidate_info['shift_name'] = $borad_approve_student->shift?$borad_approve_student->shift->shift_name:'';
        $condidate_info['session_name'] = $borad_approve_student->session?$borad_approve_student->session->session_name:'';
        $condidate_info['class_name'] = $borad_approve_student->stClass?$borad_approve_student->stClass->class_name:'';
        $condidate_info['group_name'] = $borad_approve_student->classGroup?$borad_approve_student->classGroup->group_name:'';
        $condidate_info['roll'] = $borad_approve_student->board_roll_number?$borad_approve_student->board_roll_number:'';
    //    $condidate_info['contact_number'] = $borad_approve_student->contact_number?$borad_approve_student->contact_number:'';
        $condidate_info['contact_number'] =$request->contact_number;
        $condidate_info['board'] = $borad_approve_student->academicBoard?$borad_approve_student->academicBoard->key_name:'';
        $condidate_info['passing_year'] = $borad_approve_student->passing_year?$borad_approve_student->passing_year:'';
        $condidate_info['fee_list'] = $fee_list;
        $condidate_info['total_fee_amount'] = $borad_approve_student->total_admission_fee;
        $condidate_info['total_waiver_amount'] = '0';
        $condidate_info['total_payable_amount'] = $borad_approve_student->total_admission_fee;

        $total_in_word = $this->convertNumberToWord($borad_approve_student->total_admission_fee);

        $condidate_info['total_in_word'] = $total_in_word;

      //  dd($condidate_info);

   
        ///=======payment method list====
        $payment_method_keys = GlobalSitePaymentGateway::where('site_id',$site_id)->where('status',true)->pluck('academic_payment_method_key');
  
        $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)
                ->where('payment_type_key','online')
                ->where('status',true)
                ->get();

        return ['condidate_info'=>$condidate_info,'payment_method_list'=>$payment_method_list,'loaded_reference_id'=>$request->reference_id,'siteInfo'=>$siteInfo];
  
      }

        
 


        public function createAdmissionPayment(Request $request){

            try{
                
                $site_id=$this->getSiteId();

                $siteInfo= GlobalSiteInfo::where('id',$site_id)->select('id','admission_fee_collection_status')->first();

                if($siteInfo->admission_fee_collection_status==false){
                    return response()->json(['message'=>'permission denied!'],410);
               }
         

                
            $borad_approve_student=GlobalSiteStudentAdmissionBoardApprove::with('siteStudentAdmissionDeclare')
                ->whereHas('siteStudentAdmissionDeclare')
                ->where('board_roll_number', $request['reference_id'])
                ->where('site_id',$site_id)
                ->where('second_payment_status',0)
                ->where('admission_status',0)
                ->where('status',1)
                ->first();

           
                if(!$borad_approve_student){
                    return response()->json(['message'=>'Data not found!'],410);
                }

                $reference_id = $request['reference_id'];
                $request_amount = $request['request_amount'];
                $contact_number = $request['contact_number'];
            

                if($request->gateway_name_key == 'nagad'){
                    $this->paymentTakeByNagadTransactionID($request);
                }else if($request->name_key == 'bkash'){
                    return response()->json(['message'=>'Developing This System ', 'status'=>'403', 'mode'=>'success']); 
                }else if($request->gateway_name_key == 'surecash'){
                    return response()->json(['message'=>'Developing This System ', 'status'=>'403', 'mode'=>'success']);    
                
                }else if($request->payment_method=='sonali_pay'){

                    $request_data=[
                        'site_id'=>$site_id,
                        'request_amount'=>$request_amount,
                        'reference_id'=>$reference_id,
                        'contact_number'=>$contact_number,
                        'redirect_path'=>"/web/admission-sonali-pay-message"
                    ];

                
                    $api_response = $this->admissionFeeInfoForSonaliPay($request_data,$borad_approve_student);

                    $data=[
                        'gateway_link'=>isset($api_response['RedirectToGateway'])?$api_response['RedirectToGateway']:null,
                        'message'=>$api_response['Message'],
                        'status'=>$api_response['Status'],
                     //   'time'=>isset($api_response['Time'])?$api_response['Time']:null
                    ];

                    return response()->json($data);
                                        
                    
                }

            } catch (ValidationException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
            }catch (ModelNotFoundException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
            } catch (Exception $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
            }
        }


        public function checkAdmissionSonaliPayTokenModeForWeb(Request $request){


            $data=$request->all();

            $site_id=$this->getSiteId();

            $borad_approve_student=GlobalSiteStudentAdmissionBoardApprove::where('site_id',$site_id)
                ->where('transaction_token',$data['Token'])
                ->orderBy('id', 'desc')
                ->where('status',1)
                ->first();

            if(!$borad_approve_student){
                $response=[
                    'Status'=>'411',
                    'Message'=>'Slip not found!',
                ];
            }
            

            //session check
            $currentTime = Carbon::now('Asia/Dhaka');
            $session=AdmissionPaymentSession::where('site_student_admission_board_approve_id',$borad_approve_student->id)
                ->where('end_date_time','>',$currentTime)
                ->where('token',$data['Token'])
                ->where('ip_address',request()->ip())
                ->where('status',1)
                ->orderBy('id','DESC')
                ->first();
            
            if(!$session){      
                $response=[
                    'Status'=>'403',
                    'Message'=>'Payment Session expired!',
                ];

               
    
                return $response;
            }

            $user_id=$borad_approve_student->id;    
               
           $req_data=[
                'site_id'=>$site_id,
                'username'=>$user_id,
                'user_id'=>$user_id,
            ];
    
            if($data['Mode']==='success'){ 
                
              $req_response=$this->admissionPaymentAndSonaliPayTokenVerify($data,$req_data);
    
              if($req_response['Status']=='200'){

                $host = request()->getSchemeAndHttpHost();
                $site_voucher_link=$host.'/site-public/get-admission-payment-slip/'.$req_response['InvoiceNo'].'/'.$req_response['TransactionId'];
                $req_response['site_voucher_link']=$site_voucher_link;
                
                $response=$req_response;
              }else{
                $response=[
                    'Status'=>$req_response['Status'],
                    'Message'=>'Your transaction was unsuccessful',
                ];
              }
    
            }else{
                $response=[
                    'Status'=>'400',
                    'Message'=>'Your transaction was unsuccessful. Please check and retry!',
                    'Details'=>'Mode failed'
                ];
    
                $response_test=json_encode($response);
    
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$response_test;
                $issue->site_id=$req_data['site_id'];
                $issue->username=$req_data['username'];
                $issue->ip_address=request()->ip();
                $issue->save();
    
            }
    
            // session clear
            $session->status=0;
            $session->save();
    
            return $response;
        }
    

       
        private function getSiteId()
        {
    
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
         
            return $site_id;
        }

        public function getWebPaymentStatusMessage(){
            $viewType = 'Student Payment';
            return view('default.admin.layouts.master', compact('viewType'));
        }

        public function getAdmissionPaymentSlip($invoice_no,$tr_id){

            $site_id=$this->getSiteId();

            $site_info= GlobalSiteInfo::where('id',$site_id)->select('id','admission_fee_collection_status','show_subhead_in_payment_slip')->first();


            $payment_history=GlobalSiteAdmissionPaymentHistory::with('siteStudentAdmissionBoardApprove')
                ->where('site_id',$site_id)
                ->where('transaction_id',$tr_id)
                ->where('invoice_id',$invoice_no)
                ->first();

            if(!$payment_history){
                return 'Data not found!';
            }

            $admissionFee=GlobalSiteStudentAdmissionFeeGenerate::where('site_student_admission_board_approve_id',$payment_history->site_student_admission_board_approve_id)
                ->where('site_id',$site_id)
                ->where('status',1)
                ->get();

            $fee_list=[];
            foreach($admissionFee as $key=>$fee){
                $fee_list[$key]['academic_fee_sub_head']=$fee->academicFeeSubHead?$fee->academicFeeSubHead->name:'';
                $fee_list[$key]['amount']=$fee->amount;
            }

            $total_paid_amount_in_word = $this->convertNumberToWord($payment_history->total_paid_amount);


            $payment_details=[
                'candidate_name'=>$payment_history->siteStudentAdmissionBoardApprove->first_name,
                'father_name'=>$payment_history->siteStudentAdmissionBoardApprove->father_name,
                'mother_name'=>$payment_history->siteStudentAdmissionBoardApprove->mother_name,
                'year_name'=>$payment_history->siteStudentAdmissionBoardApprove->year?$payment_history->siteStudentAdmissionBoardApprove->year->year_name:'',
                'shift_name'=>$payment_history->siteStudentAdmissionBoardApprove->shift?$payment_history->siteStudentAdmissionBoardApprove->shift->shift_name:'',
                'session_name'=>$payment_history->siteStudentAdmissionBoardApprove->session?$payment_history->siteStudentAdmissionBoardApprove->session->session_name:'',
                'class_name'=>$payment_history->siteStudentAdmissionBoardApprove->stClass?$payment_history->siteStudentAdmissionBoardApprove->stClass->class_name:'',
                'group_name'=>$payment_history->siteStudentAdmissionBoardApprove->classGroup?$payment_history->siteStudentAdmissionBoardApprove->classGroup->group_name:'',
                'roll'=>$payment_history->siteStudentAdmissionBoardApprove->board_roll_number,
                'contact_number'=>$payment_history->siteStudentAdmissionBoardApprove->contact_number,
                'board'=>$payment_history->siteStudentAdmissionBoardApprove->academicBoard?$payment_history->siteStudentAdmissionBoardApprove->academicBoard->key_name:'',
                'passing_year'=>$payment_history->siteStudentAdmissionBoardApprove->passing_year,

                'invoice_date'=>$payment_history->siteStudentAdmissionBoardApprove->created_data?$payment_history->siteStudentAdmissionBoardApprove->created_data:'',

                'payment_date'=>$payment_history->transaction_date,
                'payment_by'=>$payment_history->paid_by,
                'payment_time'=>$payment_history->transaction_time,
                'transaction_gateway'=>$payment_history->transaction_gateway,
                'transaction_id'=>$payment_history->transaction_id,
                'total_paid_amount'=>$payment_history->total_paid_amount,
                'total_paid_amount_in_word'=>$total_paid_amount_in_word,
                'gateway_charge'=>$payment_history->gateway_charge,

                'extra_fine'=>'0.00',
                'waiver'=>'0.00',
                'special_waiver'=>'0.00',

                'transaction_amount'=>$payment_history->transaction_amount,
                'invoice_id'=>$payment_history->invoice_id,
                'fee_list'=>$fee_list,
            ];


           // dd($payment_details);

            $title_view='Admission Payment Voucher';
            $report_tittle='Admission Payment Voucher';
            $report_tittle2='';
            $slip_owner='student';
            // $site_info=GlobalSiteInfo::where('id',$site_id)->first();

        
            $pdf = PDF::loadView('default.site.student_admission.admission-payment-slip', compact('title_view','report_tittle','report_tittle2','payment_details','site_info','slip_owner'));
            return $pdf->stream($payment_history->transection_token.'.pdf');
        }



        // public function convertNumberToWord($num = false)
        // {
        //     $num = str_replace(array(',', ' '), '', trim($num));
        //     if (!$num) {
        //         return false;
        //     }
        //     $num = (int)$num;
        //     $words = array();
        //     $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven',
        //         'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
        //     );
        //     $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');
        //     $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion',
        //         'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion',
        //         'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion'
        //     );
        //     $num_length = strlen($num);
        //     $levels = (int)(($num_length + 2) / 3);
        //     $max_length = $levels * 3;
        //     $num = substr('00' . $num, -$max_length);
        //     $num_levels = str_split($num, 3);
        //     for ($i = 0; $i < count($num_levels); $i++) {
        //         $levels--;
        //         $hundreds = (int)($num_levels[$i] / 100);
        //         $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' hundred' . ' ' : '');
        //         $tens = (int)($num_levels[$i] % 100);
        //         $singles = '';
        //         if ($tens < 20) {
        //             $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
        //         } else {
        //             $tens = (int)($tens / 10);
        //             $tens = ' ' . $list2[$tens] . ' ';
        //             $singles = (int)($num_levels[$i] % 10);
        //             $singles = ' ' . $list1[$singles] . ' ';
        //         }
        //         $words[] = $hundreds . $tens . $singles . (($levels && ( int )($num_levels[$i])) ? ' ' . $list3[$levels] . ' ' : '');
        //     } //end for loop
        //     $commas = count($words);
        //     if ($commas > 1) {
        //         $commas = $commas - 1;
        //     }
        //     return implode(' ', $words);
        // }
        

}
