<?php

namespace App\Http\Controllers\SiteGroup;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\GroupBaseDetail;
use App\Models\ClassGroup\ClassGroup;
use App\Models\Controlling\ControllingName;
use App\Models\Site\SiteGroup;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\SiteGroup\SiteGroupModel;

class SiteGroupControllingController extends Controller
{
    

    private $siteGroup;
    private $siteInfo;
    private $siteGroupSetting;

    public function __construct(SiteGroupModel $siteGroup, SiteInfo $siteInfo, SiteGroupSetting $siteGroupSetting)
    {
        $this->middleware('auth');
        $this->siteGroup = $siteGroup;
        $this->siteInfo = $siteInfo;
        $this->siteGroupSetting = $siteGroupSetting;

    }


    public function getControllingDetailsBySiteGroupAndAcademicGroup($site_group_id, $academic_group_id)
    {
        try {

            $controlling_names = ControllingName::all();
            $academic_detail = GroupBaseDetail::where('academic_group_id', $academic_group_id)->first();
            $site_setting_details = SiteGroupSetting::where([
                ['academic_group_id', $academic_group_id],
                ['site_group_id', $site_group_id]
            ])->select(['id', 'controlling_name', 'controlling_values'])->get();

            // return $site_setting_details;

            $result = [];

            foreach ($controlling_names as $k => $v) {

                $result[$k]['key'] = $v->id;
                $result[$k]['description'] = $v->description;
                $result[$k]['name'] = $v->controlling_name;

                $key = 'controlling_name';
                $key_val = $v->controlling_name;

                if ($v->controlling_name == 'academic_class') {
                    $academic_class = explode(',', $academic_detail->academic_class_ids);
                    $academic_class_list = AcademicClass::whereIn('id', $academic_class)->get();
                    $result[$k]['data'] = $academic_class_list;
                    $result[$k]['saved'] =$site_setting_details->where($key, $key_val)->first() ? array_map('intval', explode(',', $site_setting_details->where($key, $key_val)->first()->controlling_values ?? '')) : [];

                }
                if ($v->controlling_name == 'academic_subject') {
                    $academic_subject = explode(',', $academic_detail->academic_subject_ids);
                    $academic_subject_list = AcademicSubject::whereIn('id', $academic_subject)->get();
                    $result[$k]['data'] = $academic_subject_list;
                    $result[$k]['saved'] = $site_setting_details->where($key, $key_val)->first() ? array_map('intval', explode(',', $site_setting_details->where($key, $key_val)->first()->controlling_values ?? '')) : [];

                }
                if ($v->controlling_name == 'academic_department') {
                    $academic_department = explode(',', $academic_detail->academic_department_ids);
                    $academic_department_list = AcademicDepartment::select('id', 'name')->whereIn('id', $academic_department)->get();
                    $result[$k]['data'] = $academic_department_list;
                    $result[$k]['saved'] = $site_setting_details->where($key, $key_val)->first() ? array_map('intval', explode(',', $site_setting_details->where($key, $key_val)->first()->controlling_values ?? '')) : [];

                }
                if ($v->controlling_name == 'academic_class_group') {
                    $academic_class_group = explode(',', $academic_detail->academic_class_group_ids);
                    $academic_class_group_list = ClassGroup::select('id', 'group_name')->whereIn('id', $academic_class_group)->get();
                    $result[$k]['data'] = $academic_class_group_list;
                    $result[$k]['saved'] = $site_setting_details->where($key, $key_val)->first() ? array_map('intval', explode(',', $site_setting_details->where($key, $key_val)->first()->controlling_values ?? '')) : [];

                }
                if ($v->controlling_name == 'emp_designation') {
                    $academic_class_group = explode(',', $academic_detail->academic_class_group_ids);
                    $academic_class_group_list = ClassGroup::select('id', 'group_name')->whereIn('id', $academic_class_group)->get();
                    $result[$k]['data'] = $academic_class_group_list;
                    $result[$k]['saved'] = $site_setting_details->where($key, $key_val)->first() ? array_map('intval', explode(',', $site_setting_details->where($key, $key_val)->first()->controlling_values ?? '')) : [];

                }


            }
            return $result;
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);

        }
    }

    public function store(Request $request)
    {
        try {

            $controlling_details = $request->controllingDetails;

            if (count($controlling_details)) {


                $controlling_names = ControllingName::get();
                $site_group_id = $request->selectedSiteGroupId;
                $academic_group_id = $request->selectedAcademicGroupId;

                \Log::info($request->controllingDetails);

                $site_setting_details = SiteGroupSetting::where([
                    ['academic_group_id', $academic_group_id],
                    ['site_group_id', $site_group_id]
                ])->select(['id', 'controlling_name', 'controlling_values'])->get();

                foreach ($controlling_details as $k => $v) {
                    $controlling_exist = $controlling_names->where('id', $k)->first();
                    if ($controlling_exist) {
                        $controlling_name = $controlling_exist->controlling_name;
                        $setting_exist = $site_setting_details->where('controlling_name', $controlling_name)->first();
                        if ($setting_exist) {
                            $this->siteGroupSetting->where('id', $setting_exist->id)->update([
                                'controlling_values' => implode(',', $v)
                            ]);
                        } else {
                            $this->siteGroupSetting=new SiteGroupSetting();
                            $this->siteGroupSetting->site_group_id = $site_group_id;
                            $this->siteGroupSetting->academic_group_id = $academic_group_id;
                            $this->siteGroupSetting->controlling_name = $controlling_name;
                            $this->siteGroupSetting->controlling_values = implode(',', $v);
                            $this->siteGroupSetting->save();

                        }

                    }

                }
                return JsonResponse::create(['message' => 'Successfully Updated Site Group Setting!'], 200);
            }
            return JsonResponse::create(['message' => 'Sorry, No Data Send! Please Change Academic Group Again'], 410);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);

        }
    }
}
