<?php

namespace App\Http\Controllers\SiteGroup;

use App\Http\Controllers\ProjectController;
use App\Mail\SendMailToUserWithQueue;
use App\Mail\Site\SendSiteInfo;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicGroup;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\Role\GlobalSiteGroupRole;
use App\Traits\SubDomainCreationTrait;
use Auth;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Image;
use Log;
use Mail;
use Response;

/**
 *
 */
class SiteGroupController extends ProjectController
{
    use SubDomainCreationTrait;

    private $siteGroup;
    private $siteInfo;

    public function __construct(GlobalSiteGroup $siteGroup, SiteInfo $siteInfo)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->siteGroup = $siteGroup;
        $this->siteInfo = $siteInfo;


    }




    public function createSiteGroupForm()
    {
        $viewType = 'Create Institution Group';
        return view('default.admin.site_group.create', compact('viewType'));
    }





}
