<?php

namespace App\Http\Controllers\SiteGroup\Settings;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\Academic\AcademicExamType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;

use Exception;
use Illuminate\Http\JsonResponse;
use Response;
use Session;
use DB;
use Illuminate\Support\Carbon;
use JsonSchema\Exception\ValidationException;
use PhpParser\Error;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SiteGroup\Settings\GroupSiteGroupSettings;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicFiscalYear;
use App\Models\Academic\AcademicLeaveCategory;
use App\Models\Academic\AcademicLeaveType;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicResultSystem;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentOfferType;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicWaiverType;
use App\Models\Academic\GroupBaseDetail;
use App\Models\ClassGroup\ClassGroup;
use App\Models\Designation\Designation;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Models\Site\SiteGroupSetting;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;

class SiteGroupSiteAcademicSettingController extends SiteGroupProjectController
{
    private $siteGroupSetting;

    public function __construct(SiteGroupSetting $siteGroupSetting)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->siteGroupSetting = $siteGroupSetting;
    }

    public function index()
    {
        $viewType = "Site Group Subject Settings";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getGroupSiteList(){
       //dd('sf');
        $siteList=GlobalSiteInfo::select('id')
        ->whereIn('id',$this->siteIds())
        ->get();

        $s_List=[];
        foreach($siteList as $key=>$item){
            $s_List[$key]['id']=$item->id;
            $s_List[$key]['site_name']=$item->site_name;
            $s_List[$key]['select']=false;
        }

        return $s_List;
    }

    public function getSiteGroupAcademicSettings()
    {

            $site_group_id=Session::get('SITE_GROUP_ID');
            $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        try {
            $groupSetting = $this->siteGroupSetting
                ->where([
                    ['site_group_id', $site_group_id],
                    ['academic_group_id', $academic_group_id]
                ])->first();

            if (!$groupSetting) {
                return Response::json(['message' => 'No Site Group Setting Found! <a class="btn btn-xs btn-warning" target="_blank" href=" ' . route("site-group-list") . '" >Click<a/>'], 301);
            }

         //   dd($groupSetting);

            $academicClassList = [];
            if ($groupSetting->academic_class_ids) {
                $academicClass = explode(',', $groupSetting->academic_class_ids) ?? null;
                $academicClassList = AcademicClass::select('id', 'class_name')->whereIn('id', $academicClass)->get();
            }

            $academicDepartmentList = [];
            if ($groupSetting->academic_department_ids) {
                $academicDepartment = explode(',', $groupSetting->academic_department_ids) ?? null;
                $academicDepartmentList = AcademicDepartment::select('id', 'name')->whereIn('id', $academicDepartment)->get();
            }

            $academicClassGroupList = [];
            if ($groupSetting->academic_class_group_ids) {
                $academicClassGroup = explode(',', $groupSetting->academic_class_group_ids);
                $academicClassGroupList = ClassGroup::select('id', 'group_name')->whereIn('id', $academicClassGroup)->get();
            }


            $academicSectionList = [];
            if ($groupSetting->academic_section_ids) {
                $academicSection = explode(',', $groupSetting->academic_section_ids);
                $academicSectionList = AcademicSection::select('id', 'section_name')->whereIn('id', $academicSection)->get();
            }

            $academicSubjectConditionList = [];
            if ($groupSetting->academic_subject_condition_ids) {
                $academicSubjectCondition = explode(',', $groupSetting->academic_subject_condition_ids);
                $academicSubjectConditionList = SubjectCondition::select('id', 'name')->whereIn('id', $academicSubjectCondition)->get();
            }
            if (count($academicSubjectConditionList) <= 0) {
                return Response::json(['message' => 'No Subject Condition Found For The Group Type'], 301);
            }

            $genderList = Gender::select('id')->get();
            $shiftList = AcademicShift::select('id')->get();

            if (count($genderList) <= 0 || count($shiftList) <= 0) {
                return Response::json(['message' => 'No Gender or Shift Found!'], 301);
            }

            $academic_subject_from_group_setting = explode(',', $groupSetting->academic_subject_ids);
            $academicSubject = AcademicSubject::select('id')
            ->whereIn('id', $academic_subject_from_group_setting)
            ->get();

            $academicVersionList = [];
            if ($groupSetting->academic_version_ids) {
                $academicVersion = explode(',', $groupSetting->academic_version_ids) ?? null;
                $academicVersionList = AcademicVersion::select('id', 'version_name')->whereIn('id', $academicVersion)->get();
            }

            $academicSessionList = [];
            if ($groupSetting->academic_session_ids) {
                $academicSession = explode(',', $groupSetting->academic_session_ids) ?? null;
                $academicSessionList = AcademicSession::select('id', 'session_name')->whereIn('id', $academicSession)->get();
            }

            $academicStudentCategoryList = [];
            if ($groupSetting->student_category_ids) {
                $academicCategory = explode(',', $groupSetting->student_category_ids) ?? null;
                $academicStudentCategoryList = AcademicStudentCategory::select('id', 'category_name')->whereIn('id', $academicCategory)->get();
            }

            $designationList = [];
            if ($groupSetting->designation_ids) {
                $designation = explode(',', $groupSetting->designation_ids) ?? null;
                $designationList = Designation::select('id', 'name')->whereIn('id', $designation)->get();
            }
            $academicYearList = AcademicYear::get();

            $academic_fee_head = [];
            if ($groupSetting->academic_fee_head_ids) {
                $fee_head = explode(',', $groupSetting->academic_fee_head_ids) ?? null;
                $academic_fee_head = AcademicFeeHead::select('id', 'name')->whereIn('id', $fee_head)->get();
            }

            $academic_fee_sub_head = [];
            if ($groupSetting->academic_fee_sub_head_ids) {
                $fee_sub_head = explode(',', $groupSetting->academic_fee_sub_head_ids) ?? null;
                $academic_fee_sub_head = AcademicFeeSubHead::select('id', 'name')->whereIn('id', $fee_sub_head)->get();
            }

            $academic_fee_group = [];
            if ($groupSetting->academic_fee_group_ids) {
                $fee_group = explode(',', $groupSetting->academic_fee_group_ids) ?? null;
                $academic_fee_group = AcademicFeeGroup::select('id', 'name')->whereIn('id', $fee_group)->get();
            }

            $academic_waiver_types = [];
            if ($groupSetting->academic_waiver_type_ids) {
                $waiver_type = explode(',', $groupSetting->academic_waiver_type_ids) ?? null;
                $academic_waiver_types = AcademicWaiverType::select('id', 'name')->whereIn('id', $waiver_type)->get();
            }

            $academic_student_offer_types = [];
            if ($groupSetting->academic_student_offer_type_ids) {
                $student_offer_type = explode(',', $groupSetting->academic_student_offer_type_ids) ?? null;
                $academic_student_offer_types = AcademicStudentOfferType::select('id', 'name')->whereIn('id', $student_offer_type)->get();
            }

        //   $batch_present_status=$groupSetting->batch_present_status;

            $examinations = [];
           // if ($groupSetting->examination_ids) {
                $examinations_list = explode(',', $groupSetting->examination_ids) ?? null;
                $examinations = Examination::select('id', 'examination_name')
                  //  ->whereIn('id', $examinations_list)
                    ->where('use_key','site_group')
                    ->get();
          //  }
            $academicExamTypeList = [];
            if ($groupSetting->academic_exam_type_ids) {
                $examinations_type_list = explode(',', $groupSetting->academic_exam_type_ids) ?? null;
                $academicExamTypeList = AcademicExamType::select('id', 'marks_type')->whereIn('id', $examinations_type_list)->get();
            }
            $academicResultPrimaryTypeList = [];
            if ($groupSetting->academic_result_primary_type_ids) {
                $result_primary_type_list = explode(',', $groupSetting->academic_result_primary_type_ids) ?? null;
                $academicResultPrimaryTypeList = AcademicResultPrimaryType::select('id', 'name')
                 //   ->whereIn('id', $result_primary_type_list)
                    ->where('use_key','site_group')
                    ->get();
            }

            $academicResultCombineTypeList = [];
         //   if ($groupSetting->academic_result_combine_type_ids) {
                $result_combine_type_list = explode(',', $groupSetting->academic_result_combine_type_ids) ?? null;
                $academicResultCombineTypeList = AcademicResultCombineType::select('id', 'name')
                  //  ->whereIn('id', $result_combine_type_list)
                    ->where('use_key','site_group')
                    ->get();
         //   }

            $academicSubjectClassExamConditionList = [];
            if ($groupSetting->academic_subject_class_exam_condition_ids) {
                $subject_class_exam_condition_list = explode(',', $groupSetting->academic_subject_class_exam_condition_ids) ?? null;
                $academicSubjectClassExamConditionList = AcademicSubjectClassExamCondition::select('id', 'name')
                ->whereIn('id', $subject_class_exam_condition_list)
                ->get();
            }

            $academicStudentTypeList = AcademicStudentType::select('id', 'student_type_name')->get();
            $religionList = Religion::get();
            $academicResidenceList = AcademicResidence::select('id', 'residence_name')->get();
            $academicFiscalYearList = AcademicFiscalYear::select('id', 'year_name')->get();
            $academicLeaveTypeList = AcademicLeaveType::select('id', 'name')->get();
            $academicLeaveCategoryList = AcademicLeaveCategory::select('id', 'name')->get();
            $academicCalendarHeadList = AcademicCalendarHead::select('id', 'name')->get();
            $academicSubjectClassExamConditionList = AcademicSubjectClassExamCondition::select('id', 'name')->get();
            $admission_type_list = AcademicAdmissionType::select('id', 'admission_type_name')->get();
            $academicResultSystemList = AcademicResultSystem::select('id', 'name')->get();

            $data1 = [];
            $data1['academicDepartmentList'] = $academicDepartmentList;
            $data1['academicClassList'] = $academicClassList;
            $data1['academicClassGroupList'] = $academicClassGroupList;
            $data1['academicSectionList'] = $academicSectionList;
            $data1['academicSubjectConditionList'] = $academicSubjectConditionList;
            $data1['genderList'] = $genderList;
            $data1['ShiftList'] = $shiftList;
            $data1['academicSubject'] = $academicSubject;
            $data1['academicVersionList'] = $academicVersionList;
            $data1['academicSessionList'] = $academicSessionList;
            $data1['academicStudentCategoryList'] = $academicStudentCategoryList;
            $data1['academicYearList'] = $academicYearList;
            $data1['academicStudentTypeList'] = $academicStudentTypeList;
            $data1['religionList'] = $religionList;
            $data1['academicResidenceList'] = $academicResidenceList;
            $data1['designationList'] = $designationList;
            $data1['academic_fee_head'] = $academic_fee_head;
            $data1['academic_fee_sub_head'] = $academic_fee_sub_head;
            $data1['academic_fee_group'] = $academic_fee_group;
            $data1['academic_waiver_types'] = $academic_waiver_types;
            $data1['academic_student_offer_types'] = $academic_student_offer_types;
            $data1['examinations'] = $examinations;
            $data1['academicLeaveTypeList'] = $academicLeaveTypeList;
            $data1['academicFiscalYearList'] = $academicFiscalYearList;
            $data1['academicLeaveCategoryList'] = $academicLeaveCategoryList;
            $data1['academicExamTypeList'] = $academicExamTypeList;
            $data1['academicCalendarHeadList'] = $academicCalendarHeadList;
            $data1['academicResultCombineTypeList'] = $academicResultCombineTypeList;
            $data1['academicResultPrimaryTypeList'] = $academicResultPrimaryTypeList;
            $data1['academicSubjectClassExamConditionList'] = $academicSubjectClassExamConditionList;
            $data1['admission_type_list'] = $admission_type_list;
            $data1['academicResultSystemList'] = $academicResultSystemList;
        //            $data1['batch_present_status'] = $batch_present_status;

            return response()->json($data1);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }

    }


    public function getSiteGroupSelectedAcademicSettings()
    {
        try {

           $siteGroupSettingStore = SiteGroupAcademicSettingsStore::first();

            if (!$siteGroupSettingStore) {
                return Response::json(['message' => 'No Site Group Setting Found! <a class="btn btn-xs btn-warning" target="_blank" href=" ' . route("site-group-list") . '" >Click<a/>'], 301);
            }
            $data = [];

            if ($siteGroupSettingStore) {
                foreach ($siteGroupSettingStore->ownfields as $ownField) {
                    $data[$ownField] = array_map('intval', explode(',', $siteGroupSettingStore->{$ownField}));
                }
                $data['id'] = $siteGroupSettingStore->id;

            } else {
                foreach ($siteGroupSettingStore->ownfields as $ownField) {
                    $data[$ownField] = [];
                }
            }
            $data['site_ids'] = $this->siteIds();

            return response()->json($data);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function siteGroupAcademicSettingStore(Request $request)
    {
        try {
            $site_group_id=Session::get('SITE_GROUP_ID');
            $academic_group_id=Session::get('ACADEMIC_GROUP_ID');

            $this->validate($request, [
                "academic_class_ids" => "required",
                "academic_subject_ids" => "required",
                "academic_subject_condition_ids" => "required",
            ]);

            $the_site_group_setting = SiteGroupAcademicSettingsStore::first();
            $theSiteGroupSetting = new SiteGroupAcademicSettingsStore;

            $site_group_setting = $the_site_group_setting ?? $theSiteGroupSetting;

            if (isset($site_group_setting->ownfields)) {
                foreach ($site_group_setting->ownfields as $ownField) {
                    if (is_array($request->{$ownField})) {
                        $site_group_setting->{$ownField} = implode(',', $request->{$ownField});
                    } else {
                        $site_group_setting->{$ownField} = $request->{$ownField};
                    }
                }

                $site_group_setting->present_in_sms_text = '[full_name][nl]In Time: [in_time] Attendance Date: [present_date] [nl]Regards:[site_name]';
                $site_group_setting->present_out_sms_text = '[full_name][nl]Out Time: [out_time] Attendance Date: [present_date] [nl]Regards:[site_name]';
             //   $site_group_setting->present_out_sms_text = 'trtrtrt';

                $site_group_setting->status = 1;
                $site_group_setting->site_group_id = $site_group_id;
                $site_group_setting->academic_group_id = $academic_group_id;
                $site_group_setting->save();
            }

         //   $site_group_settings= SiteGroupAcademicSettingsStore::first();
            // $site_group_settings= GroupSiteGroupSettings::first();
            // if($site_group_settings){
            //       foreach($request->site_ids as $site_id){
            //         if($site_id){
            //             $the_site_info_settings=GlobalSiteInfoSetting::where('site_id',$site_id)
            //             ->where('academic_group_id',$academic_group_id)
            //             ->first();
            //             $siteInfoSettings=new GlobalSiteInfoSetting;
            //             $site_info_settings = $the_site_info_settings ?? $siteInfoSettings;

            //             if (isset($site_info_settings->ownfields)) {
            //                 foreach ($site_info_settings->ownfields as $ownField) {

            //                     if (is_array($request->{$ownField})) {
            //                         $site_info_settings->{$ownField} = implode(',', $request->{$ownField});
            //                     } else {
            //                         $site_info_settings->{$ownField} = $request->{$ownField};
            //                     }
            //                 }
            //                 $site_info_settings->site_group_setting_id = $site_group_settings->id;
            //                 $site_info_settings->site_id = $site_id;
            //                 $site_info_settings->academic_group_id = $academic_group_id;
            //                 $site_info_settings->present_in_sms_text = '[full_name][nl]In Time: [in_time] Attendance Date: [present_date] [nl]Regards:[site_name]';
            //                 $site_info_settings->present_out_sms_text = '[full_name][nl]Out Time: [out_time] Attendance Date: [present_date] [nl]Regards:[site_name]';
            //                 $site_info_settings->status = 1;
            //                 $site_info_settings->save();
            //             }

            //         }

            //       }
            //     }
            return Response::json(['message' => 'Saved Successfully!', 'mode' => 'Saved!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }

        ///====================end==========

    }

}
