<?php

namespace App\Http\Controllers\SiteGroup\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Quiz\QuizDeclares;
use App\Models\Site\Quiz\QuizDeclareStudents;
use Illuminate\Validation\ValidationException;
use App\Models\SiteGroup\Quiz\SiteGroupQuiz;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclares;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclareSettings;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclareStudent;
use Illuminate\Http\JsonResponse;

use Auth;
use Response;
use DB;
use Exception;
use Illuminate\Validation\Rules\Unique;
use Session;

class SiteGroupQuizReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');

    }

    //
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Site Group Quiz Declare";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function quizListForReport(){
        
    try{
    
        $quiz_ids = SiteGroupQuizDeclares::pluck('quiz_id')->unique();
     //   dd($quiz_ids);
        $quiz_list=SiteGroupQuiz::whereIn('id',$quiz_ids)->get();

        return response()->json(['quiz_list'=>$quiz_list]);

    }
    catch (ValidationException $exception) {
        DB::rollBack();
        return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
    } catch (Exception $exception) {
        DB::rollBack();
        return Response::json(['message' => $exception->getMessage()], 410);
    }
    }

    public function getSiteQuizReport(Request $request)
    {
        $data= $request->all();

        $data = [];
        $data['id'] = $request->id;
        $data['student_limit'] = $request->student_limit;
        $data['form_marks'] = $request->form_marks;
        $data['to_marks'] = $request->to_marks;


        $this->validate($request, [
            'quiz_id' => 'required',
        ]);


        $SiteGroupQuizDeclares=SiteGroupQuizDeclares::
            with(['quizDeclareSettings'=>function($query1){
                    $query1->where('is_start',1);
                }, 'quiz','siteInfo'])
            ->whereHas('quizDeclareSettings',function($query2){
                    $query2->where('is_start',1);
                })
            ->where('quiz_id',$request->quiz_id)
            ->get();

          $quiz_declare_ids=$SiteGroupQuizDeclares->pluck('id');

          $quizDeclareStudents=  SiteGroupQuizDeclareStudent::with(['studentHistory'=>function($query){
                $query->with('student','site','year','shift','department','stClass','classGroup','session','section','religion');
            },'quizDeclare'])
            ->when($data['student_limit'], function ($query) use ($data) {
                return $query->take($data['student_limit']);
            })
            ->when($data['form_marks'], function ($query) use ($data) {
                return $query->where('mark','<=',$data['form_marks']);
            })
            ->when($data['to_marks'], function ($query) use ($data) {
                return $query->where('mark','>=',$data['to_marks']);
            })
            ->whereIn('quiz_declare_id',$quiz_declare_ids)
            ->orderBy('mark','DESC')
            ->orderBy('quiz_time_by_second','ASC')
            ->where('join_status',1)
            ->get();

        //    dd($SiteGroupQuizDeclares[0]);
    
        $groupQuiz=$SiteGroupQuizDeclares[0];

        $quiz_name = $groupQuiz->quiz_name;
        $start_date = $groupQuiz->quizDeclareSettings->start_date;
        $start_time = $groupQuiz->quizDeclareSettings->start_time;
        $duration = $groupQuiz->quizDeclareSettings->duration;
        $question_per_student = $groupQuiz->quizDeclareSettings->question_per_student;
        $student_list = $groupQuiz->quizDeclareStudents;
        
        $quiz_infos=[
        
            'quiz_name'=>$quiz_name,
            'start_date'=>$start_date,
            'start_time'=>$start_time,
            'duration'=>$duration,
            'question_per_student'=>$question_per_student,
        ];


       

         
            $student_info=[];
            foreach($quizDeclareStudents as $item){
                $student=$item->studentHistory;
              //  dd($item);
                $student_info[]=[
                    'student_name'=>$student?$student->student_full_name_username:null,
                  //  'site_name'=>$groupQuiz->siteInfo?$groupQuiz->siteInfo->short_name:'',
                    'join_status'=>$item->join_status,
                    'marks'=>$item->mark,
                    'total_question'=>$item->total_question,
                    'total_answer'=>$item->total_answer,
                    'total_right_answer'=>$item->total_right_answer,
                    'total_wrong_answer'=>$item->total_wrong_answer,
                    'quiz_time'=>$item->quiz_time,
                    'quiz_time_by_second'=>$item->quiz_time_by_second,
                    'quiz_percentage'=>$item->right_ans_percentage,
                    'marks'=>$item->mark,
                    'year'=>$student->year?$student->year->year_name:null,
                    'shift'=>$student->shift?$student->shift->shift_name:null,
                    'department'=>$student->department?$student->department->department_name:null,
                    'stClass'=>$student->shift?$student->stClass->class_name:null,
                    //'classGroup'=>$student?$student->classGroup->group_name:null,
                    'session'=>$student->session?$student->session->session_name:null,
                    'section'=>$student->section?$student->section->section_name:null,
                    'religion'=>$student->religion?$student->religion->religion_name:null,
                    'site_name'=>$student->site?$student->site->site_name:null,
                ];
            }
          
        
        return response()->json([
            'quiz_infos'=>$quiz_infos,
            'student_list'=>$student_info,
        ]);
    }
}
