<?php

namespace App\Http\Controllers\SiteGroup\Quiz;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclares;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclareSettings;

use App\Models\SiteGroup\Quiz\SiteGroupQuizQuestionInfo;
use App\Models\SiteGroup\Quiz\SiteGroupQuizQuestion;
use App\Models\SiteGroup\Quiz\SiteGroupQuizQuestionDetails;

use App\Models\Academic\AcademicSubjectTopic;
use App\Models\Site\Exam\SiteExamQuestionInfo;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Quiz\Question\SiteQuizQuestionForStudent;
use App\Models\SiteGroup\Quiz\SiteGroupQuizDeclareStudent;
use Response;
use DB;
use Exception;

use Session;

class SiteGroupBaseQuizQuestionDeclareController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');

    }
    public function getSubjectTopicList(Request $request)
    {
      
       $topic_list = AcademicSubjectTopic::where('site_group_id',Session::get('SITE_GROUP_ID'))
                    ->where('module_key','quiz')
                    ->get();

       return response()->json($topic_list);

    }

    // public function getActiveSubjectListByYearClassForQuizDeclare(Request $requests)
    // {
    //     $data=$requests->all();
    //     try {
  
    //     $sGroupCondSettings = SubjectGroupConditionSetting::with(['academicClass', 'academicSubject'])
    //             ->whereIn('academic_class_id', $data['academic_class_ids'])
    //             ->where('academic_year_id', $data['academic_year_id'])
    //             ->groupBy('academic_subject_id')
    //             ->get();

    //     return response()->json($sGroupCondSettings);

    //     } catch (Exception $exception) {
    //         return $exception->getMessage();

    //     }
    //  }

     
    public function getQuestionList(Request $request){
 
         $data = $request->all();
       
         $quiz_declare_list = SiteGroupQuizDeclares::with('quizDeclareSettings','quiz')
                        //->where('start_date', '>=', $current_date)
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->groupBy('site_group_id','quiz_id')
                        ->get();

            $question_info=SiteGroupQuizQuestionInfo::
                       when(!empty($data['academic_department_id']), function ($query) use ($data) {
                           return $query->where('academic_department_id', $data['academic_department_id']);
                       })
                       ->when(!empty($data['academic_class_ids']), function ($query2) use ($data) {
                           return $query2->where('academic_class_id', $data['academic_class_ids']);
                       })
                       ->when(!empty($data['academic_subject_ids']), function ($query3) use ($data) {
                        return $query3->whereIn('academic_subject_id', $data['academic_subject_ids']);
                        })
                        ->when(!empty($data['quiz_topic_ids']), function ($query3) use ($data) {
                            return $query3->whereIn('academic_subject_topic_id', $data['quiz_topic_ids']);
                        })
                       ->get();
       
                $question_ids=$question_info->pluck('id');

               $question_list=SiteGroupQuizQuestion::whereIn('site_exam_question_info_id', $question_ids)
                   ->when(!empty($data['question_level']), function ($query3) use ($data) {
                        return $query3->where('question_level', $data['question_level']);
                    })
                   ->where('module_key','quiz')
                   ->where('question_status','approved')
                   ->orderBy('id','desc')
                   ->get();


         return response()->json(
            [
                'quiz_declare_list'=>$quiz_declare_list,
                'question_list'=>$question_list,
            ]);
      
 
     }

     
     public function selectedQuizInfo(Request $requests){
        $data = $requests->all();
        
        $declared_quiz = SiteGroupQuizDeclares::with('quizDeclareSettings','quiz')
        ->where('academic_year_id', $data['academic_year_id'])
        ->groupBy('site_group_id','quiz_id')
        ->first();

        return response()->json($declared_quiz);
  
       //getPreSentStudents
      
    }

    // createQuestionDeclare
     public function createSiteGroupQuizQuestionDeclare(Request $requests){
        $this->validate($requests, [
            "question_per_student" => "required",
            "quiz_declare_id" => "required",
        ]);
        $data = $requests->all();
       
        try {
            $quiz_questions_ids = implode(',',$data['site_quiz_question_ids']);
           
            $quiz_declare = SiteGroupQuizDeclares::with('quizDeclareSettings','quiz')
                //->where('start_date', '>=', $current_date)
                ->where('academic_year_id', $data['academic_year_id'])
                ->get();


            foreach($quiz_declare as $item){
                $quiz_declare=SiteGroupQuizDeclares::findOrFail($item->id);

              


                $quiz_declare->question_ids=$quiz_questions_ids;
                $quiz_declare->save();
                
                $quiz_declare_settings=SiteGroupQuizDeclareSettings::where('quiz_declare_id', $item->id)->first();
                $quiz_declare_settings->question_per_student=$data['question_per_student'];
                $quiz_declare_settings->save();


                $quiz_questions_ids = SiteQuizQuestionForStudent::whereIn('id', $data['site_quiz_question_ids'])
                        ->where('module_key','quiz')
                        ->inRandomOrder()
                        ->limit($data['question_per_student'])
                        ->pluck('id')
                        ->unique()
                        ->filter();
                $questions_ids = implode(',',$quiz_questions_ids->toArray());
     
                SiteGroupQuizDeclareStudent::where('quiz_declare_id',$item->id)
                        ->where('join_status', 0)
                        ->update([
                            'student_question_ids'=>$questions_ids
                        ]);

            }


            return Response::json(['message' => 'Question Declare Successfully', 'mode'=>'success'], 200);

        }catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
           

    }
     
}
