<?php

namespace App\Http\Controllers\SiteGroup\Fee;

use App\Models\Academic\AcademicStudentOfferType;
use App\Models\Academic\AcademicWaiverType;
use App\Models\Site\Fee\GlobalSiteFeeWaiverOfferHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Student\GlobalStudentHistory;
use Response;
use Session;

class SiteGroupWaiverGenerateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }



    public function getSiteGroupBaseWaiverTypeList(){

        $waiverList=AcademicWaiverType::get();

        return response()->json($waiverList, 200, []);

    }


    public function getSiteBaseClassFeeListForWaiver(Request $request){



        $siteGroupFeeList=$this->returnSiteGroupFeeList($request);
        $siteStudentIDs=$this->returnSiteStudentIDs($request);

//        $siteStudentList=GlobalUser::whereIn('id',$siteStudentIDs)
//            ->select('id',)

        $siteGroupFeeListIDs=[];
        foreach ($siteGroupFeeList as $key => $value) {
            $siteGroupFeeListIDs[]=$value['id'];
        }


        if($request->student_history_id){
            $studentWaiverGeneratedList=GlobalSiteStudentFeeWaiverOfferHistory::where('site_id', $request->checked_site_id)
                ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->where('student_history_id', $request->student_history_id)
                ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
                ->get();

            if(count($studentWaiverGeneratedList)>0){
                $waiverGeneratedList=$studentWaiverGeneratedList;
            }else{
                $waiverGeneratedList=GlobalSiteFeeWaiverOfferHistory::where('site_id', $request->checked_site_id)
                    ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                    ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                    ->get();
            }



        }else{
            $waiverGeneratedList=GlobalSiteFeeWaiverOfferHistory::where('site_id', $request->checked_site_id)
                ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
                ->get();
        }




        $siteGroupFeeFinalList=[];
        $siteGroupFeeFinalArr=Array();
        foreach ($siteGroupFeeList as $key => $value) {

            $checkIfPresent=$waiverGeneratedList->where('site_student_fee_fine_allocation_id',$value['id'])->first();


            if($checkIfPresent){

                $siteGroupFeeFinalArr['select_fee_sub_head_id']=true;
                $siteGroupFeeFinalArr['waiver_amount']=$checkIfPresent->amount;
                $siteGroupFeeFinalArr['percantage_status']=$checkIfPresent->percantage_status;
            }else{
                $siteGroupFeeFinalArr['select_fee_sub_head_id']=false;
                $siteGroupFeeFinalArr['waiver_amount']=0;
                $siteGroupFeeFinalArr['percantage_status']=false;
            }
            $siteGroupFeeFinalList[$key]=array_merge($siteGroupFeeFinalArr, $value);

        }




        return response()->json([$siteGroupFeeFinalList, $siteStudentIDs], 200, []);

    }




    private function returnSiteGroupFeeList(Request $request){
        $data = $request->all();

        $FeeGroupsGlobalID=AcademicFeeGroup::whereIn('head_key', ['global'])->pluck('id');

        $FeeGroupsClassStudentID=AcademicFeeGroup::whereIn('head_key', ['classbase','studentbase'])->pluck('id');




        $siteGroupFeeList=Array();
        if($request->checked_site_id!=null && $request->checked_fee_head_id!=null && $request->academic_class_id!=null){



            $SiteFeeList=GlobalSiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                ->where('site_group_id',Session::get('SITE_GROUP_ID'))
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('site_id',$request->checked_site_id)
                ->where('academic_fee_head_id',$request->checked_fee_head_id)
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->get();


            $siteGlobalFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsGlobalID)
                ->where('academic_class_id', null)
                ->where('academic_department_id', null);





            $siteClassStudentFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsClassStudentID)
                ->where('academic_class_id',$request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                });

            if($request->academic_student_category_id!=null || $request->academic_student_type_id!=null
                || $request->academic_student_admission_type_id!=null)
            {
                $siteGroupFeeList=$siteClassStudentFeeList;

            }else{
                $siteGroupFeeList=array_merge($siteGlobalFeeList->toArray(), $siteClassStudentFeeList->toArray());
            }



        }

        return $siteGroupFeeList;
    }



    private function returnSiteStudentIDs(Request $request){

        $data = $request->all();


        if($request->academic_class_id){

            if($request->academic_class_group_present){

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);



            }else{

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);

            }

        }

        return $siteStudentIDs;

    }


    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function createUpdateSiteGroupWaiverGenerate(Request $request){


        if($request->instent_waiver_without_sub_head){

            $studentWaiverCheck=GlobalSiteStudentFeeWaiverOfferHistory::where('student_history_id', $request->student_history_id)
                ->whereNull('site_student_fee_fine_allocation_id')
                ->where('status', true)
                ->orderBy('id', 'desc')
                ->first();

            if($studentWaiverCheck){
                $studentWaiverCheck->academic_waiver_type_id= $request->academic_waiver_type_id;
                $studentWaiverCheck->amount= $request->instent_waiver_amount;
                $studentWaiverCheck->percantage_status= $request->instent_waiver_is_percentage;
                $studentWaiverCheck->save();
            }
            else{
                $WaiverHistory= new GlobalSiteStudentFeeWaiverOfferHistory();
                $WaiverHistory->student_history_id= $request->student_history_id;
                $WaiverHistory->academic_waiver_type_id= $request->academic_waiver_type_id;
                $WaiverHistory->amount= $request->instent_waiver_amount;
                $WaiverHistory->percantage_status= $request->instent_waiver_is_percentage;
                $WaiverHistory->status= true;
                $WaiverHistory->site_id= $request->checked_site_id;
                $WaiverHistory->site_group_id= Session::get('SITE_GROUP_ID');


                $WaiverHistory->save();
            }






        }
        else{
            $this->InsertDataToSiteFeeWaiverOfferHistoryTable($request);
        }



        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);



    }




    private function InsertDataToSiteFeeWaiverOfferHistoryTable(Request $request){

        $data = $request->all();

        if($request->academic_class_group_present){

            $siteStudentIDs=GlobalStudentHistory::where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('academic_class_id',$request->academic_class_id)
                ->where('status',true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->get(['id','user_id']);



        }else{

            $siteStudentIDs=GlobalStudentHistory::where('site_id',$request->checked_site_id)
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('academic_class_id',$request->academic_class_id)
                ->where('status',true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                })
                ->get(['id','user_id', 'academic_student_category_id',
                    'academic_student_type_id', 'academic_student_admission_type_id', 'academic_residence_id',
                    'academic_quata_id','academic_transport_id']);

        }



        $siteGroupFeeList=$this->returnSiteGroupFeeList($request);

        $siteGroupFeeListIDs=[];
        foreach ($siteGroupFeeList as $key => $value) {
            $siteGroupFeeListIDs[]=$value['id'];
        }








        if ($request->fee_head_name == 'monthly') {
            $checked_admission_examination_general_ids = $request->select_month_ids;
        } else {
            $checked_admission_examination_general_ids[] = $request->checked_admission_examination_general_id;
        }


        $presentSiteWaiverGenerateList = GlobalSiteFeeWaiverOfferHistory::where('site_id', $request->checked_site_id)
            ->whereIn('fee_head_type_id', $checked_admission_examination_general_ids)
            ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
            ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
            ->get();




        $presentSiteStudentWaiverGenerateList = GlobalSiteStudentFeeWaiverOfferHistory::where('site_id', $request->checked_site_id)
            ->whereIn('fee_head_type_id',$checked_admission_examination_general_ids)
            ->whereIn('site_student_fee_fine_allocation_id', $siteGroupFeeListIDs)
            ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
            ->get();







        $chargest = [];
        $charges = [];

        foreach ($checked_admission_examination_general_ids as $ket => $typeid) {


            $presentSiteWaiverGenerate = $presentSiteWaiverGenerateList->where('fee_head_type_id', $typeid);

            $presentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerateList->where('fee_head_type_id', $typeid);


            $checkAlreadyPaymentCreate=GlobalSiteFeeWaiverOfferHistory::whereIn('site_student_fee_fine_allocation_id',$siteGroupFeeListIDs)
                ->where('fee_head_type_id', $typeid)
                ->where('status',false)
                ->first();




            if (!$checkAlreadyPaymentCreate) {


                if (!($request->student_history_id)) {

                    $editedWaiverGenerateIDs=[];
                    foreach ($request->siteBaseWaiverList as $keys => $values) {
                        if ($values['select_fee_sub_head_id']) {

                            $checkPresentSiteWaiverGenerate = $presentSiteWaiverGenerate
                                ->where('site_student_fee_fine_allocation_id', $values['id'])
                                ->first();

                            if ($checkPresentSiteWaiverGenerate) {
                                $editedWaiverGenerateIDs[] = $checkPresentSiteWaiverGenerate->id;


                                $checkPresentSiteWaiverGenerate->amount = $values['amount'];
                                $checkPresentSiteWaiverGenerate->save();

                            } else {
                                $chargest[] = [
                                    'site_student_fee_fine_allocation_id' => $values['id'],
                                    'fee_head_type_id' => $typeid,
                                    'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                    'amount' => $values['waiver_amount'],
                                    'percantage_status' => $values['percantage_status'],
                                    'status' => true,
                                    'site_id' => $request->checked_site_id,
                                    'site_group_id' => Session::get('SITE_GROUP_ID'),
                                    'academic_fee_head_id' => $request->checked_fee_head_id,
                                ];
                            }

                        }
                    }



                    if (!$checkAlreadyPaymentCreate) {
                        $siteWaiverGeneratePresentIDArr=$presentSiteWaiverGenerateList->where('fee_head_type_id', $typeid)->pluck('id');
                        $siteWaiverGenerateidCheck=array_diff($siteWaiverGeneratePresentIDArr->toArray(), $editedWaiverGenerateIDs);
                        GlobalSiteFeeWaiverOfferHistory::whereIn('id', $siteWaiverGenerateidCheck)->update(['status' => false]);;
                    }

                }


            }




            if ($request->student_history_id) {

                $checkAlreadyPaymentCreate=GlobalSiteStudentFeeWaiverOfferHistory::whereIn('site_student_fee_fine_allocation_id',$siteGroupFeeListIDs)
                    ->where('fee_head_type_id', $typeid)
                    ->where('student_history_id', $request->student_history_id)
                    ->where('academic_waiver_type_id', $request->academic_waiver_type_id)
                    ->where('status',false)
                    ->first();

                if(!$checkAlreadyPaymentCreate){
                    $siteStudentIDsList = GlobalStudentHistory::where('site_id', $request->checked_site_id)
                        ->where('id', $request->student_history_id)
                        ->get();
                }else{
                    $siteStudentIDsList=Array();
                }

            }
            else{

                if (!$checkAlreadyPaymentCreate) {
                    $siteStudentIDsList=$siteStudentIDs;
                }else{
                    $siteStudentIDsList=Array();
                }

            }






            if(count($siteStudentIDsList)>0) {

                $editedStudentFeeFenerateIDs=[];
                $studentIDs=[];
                foreach ($siteStudentIDsList as $key => $value) {
                    $studentIDs[]=$value->id;



                    foreach ($request->siteBaseWaiverList as $keys => $values) {


                        if ($values['select_fee_sub_head_id']) {


                            if ($values['academic_fee_sub_head']['head_key'] == 'general') {

                                if ($values['academic_student_category_id']) {
                                    if ($values['academic_student_category_id'] == $value->academic_student_category_id) {


                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {

                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                            $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                            $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                            $checkPresentSiteStudentWaiverGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }


                                    }
                                } else if ($values['academic_student_admission_type_id']) {
                                    if ($values['academic_student_admission_type_id'] == $value->academic_student_admission_type_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                            $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                            $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                            $checkPresentSiteStudentWaiverGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                } else if ($values['academic_student_type_id']) {
                                    if ($values['academic_student_type_id'] == $value->academic_student_type_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                            $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                            $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                            $checkPresentSiteStudentWaiverGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                } else {
                                    $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                        ->where('student_history_id', $value->id)
                                        ->where('site_student_fee_fine_allocation_id', $values['id'])
                                        ->where('fee_head_type_id', $typeid)
                                        ->first();

                                    if ($checkPresentSiteStudentWaiverGenerate) {
                                        $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                        $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                        $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                        $checkPresentSiteStudentWaiverGenerate->save();
                                    } else {
                                        $charges[] = [
                                            'student_history_id' => $value->id,
                                            'site_student_fee_fine_allocation_id' => $values['id'],
                                            'fee_head_type_id' => $typeid,
                                            'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                            'amount' => $values['waiver_amount'],
                                            'percantage_status' => $values['percantage_status'],
                                            'status' => true,
                                            'site_id' => $request->checked_site_id,
                                            'site_group_id' => Session::get('SITE_GROUP_ID'),
                                            'academic_fee_head_id' => $request->checked_fee_head_id,
                                        ];
                                    }
                                }

                            } else if ($values['academic_fee_sub_head']['head_key'] == 'transport') {

                                if ($value->academic_transport_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->academic_transport_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                            $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                            $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                            $checkPresentSiteStudentWaiverGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }


                                    }
                                }


                            } else if ($values['academic_fee_sub_head']['head_key'] == 'residance') {


                                if ($value->academic_residence_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->academic_residence_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                            $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                            $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                            $checkPresentSiteStudentWaiverGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                }

                            } else if ($values['academic_fee_sub_head']['head_key'] == 'gender') {


                                if ($value->gender_id) {
                                    if ($values['academic_fee_sub_head']['head_key_base_id'] == $value->gender_id) {

                                        $checkPresentSiteStudentWaiverGenerate = $presentSiteStudentWaiverGenerate
                                            ->where('student_history_id', $value->id)
                                            ->where('site_student_fee_fine_allocation_id', $values['id'])
                                            ->where('fee_head_type_id', $typeid)
                                            ->first();

                                        if ($checkPresentSiteStudentWaiverGenerate) {
                                            $editedStudentFeeFenerateIDs[] = $checkPresentSiteStudentWaiverGenerate->id;


                                            $checkPresentSiteStudentWaiverGenerate->amount = $values['waiver_amount'];
                                            $checkPresentSiteStudentWaiverGenerate->percantage_status = $values['percantage_status'];
                                            $checkPresentSiteStudentWaiverGenerate->save();
                                        } else {
                                            $charges[] = [
                                                'student_history_id' => $value->id,
                                                'site_student_fee_fine_allocation_id' => $values['id'],
                                                'fee_head_type_id' => $typeid,
                                                'academic_waiver_type_id' => $request->academic_waiver_type_id,
                                                'amount' => $values['waiver_amount'],
                                                'percantage_status' => $values['percantage_status'],
                                                'status' => true,
                                                'site_id' => $request->checked_site_id,
                                                'site_group_id' => Session::get('SITE_GROUP_ID'),
                                                'academic_fee_head_id' => $request->checked_fee_head_id,
                                            ];
                                        }

                                    }
                                }

                            }


                        }


                    }


                }


                $siteStudentWaiverGeneratePresentIDArr=$presentSiteStudentWaiverGenerateList
                    ->where('fee_head_type_id', $typeid)
                    ->whereIn('student_history_id', $studentIDs)
                    ->pluck('id');
                $siteStudentWaiverGenerateidCheck=array_diff($siteStudentWaiverGeneratePresentIDArr->toArray(), $editedStudentFeeFenerateIDs);
                GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $siteStudentWaiverGenerateidCheck)->update(['status' => false]);;



            }




        }



        if(count($chargest)>0){
            GlobalSiteFeeWaiverOfferHistory::insert($chargest);
        }


        if(count($charges)>0){
            GlobalSiteStudentFeeWaiverOfferHistory::insert($charges);
        }
    }






    public function getInstentWaiverBaseTypeStudentList(Request $request){

        $siteStudentIDs=$this->returnSiteStudentIDs($request);

        $waiverList=AcademicWaiverType::get();

        return response()->json([$siteStudentIDs, $waiverList], 200, []);

    }





    public function getStudentWaiverTypeBaseWaiverAmount($waiverTypeID, $studentHistoryID){

        $studentWaiverList=null;
        if($waiverTypeID && $studentHistoryID){
            $studentWaiverList=GlobalSiteStudentFeeWaiverOfferHistory::where('student_history_id', $studentHistoryID)
                ->where('academic_waiver_type_id', $waiverTypeID)
                ->whereNull('site_student_fee_fine_allocation_id')
                ->where('status', true)
                ->orderBy('id', 'desc')
                ->first();
        }

        if($studentWaiverList){
            $waiverAmount=$studentWaiverList->amount;
            $IsPercentage=$studentWaiverList->percantage_status;
        }else{
            $waiverAmount=0;
            $IsPercentage=false;
        }


        return response()->json([$waiverAmount, $IsPercentage], 200, []);


    }





}
