<?php

namespace App\Http\Controllers\SiteGroup\Fee;


use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Fee\SiteGroupFeeSubHeadAllocation;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;


class SiteGroupDemandSlipGenerateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
    }



    public function getClassDeptBaseSiteFeeHeadSubHeadList(Request $request){

        $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');
        $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');

        $siteList=GlobalSiteInfo::select('id')
            ->whereIn('id',$siteIDs)
            ->get();


        if($request->checked_site_id){
            $siteStudentIDs=$this->returnSiteStudentIDs($request);

        }else{
            $siteStudentIDs=Array();
        }



        $siteGroupfeeHeadIDs=SiteGroupFeeSubHeadAllocation::where('site_group_id',Session::get('SITE_GROUP_ID'))
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
            ->distinct('academic_fee_head_id')
            ->pluck('academic_fee_head_id');

        $siteGroupFeeHeadList=AcademicFeeHead::whereIn('id', $siteGroupfeeHeadIDs)->get();

        if($request->student_history_id){

            $stdIDs=[$request->student_history_id];

        }else{
            if($request->checked_site_id){

                $forTest=$this->returnSiteStudentIDs($request);

            }else{
                $forTest=$this->returnAllSiteStudentIDs($request);
            }


            $stdIDs=$forTest->pluck('id');
        }

        $countStudent=count($stdIDs);



        $siteDemandSlipCreateList=GlobalSiteStudentFeeGenerate::whereIn('student_history_id',$stdIDs)
            ->distinct('academic_fee_head_id','fee_head_type_id')
            ->where('status',false)
            ->get(['academic_fee_head_id','fee_head_type_id']);



        $siteDemandSlipCreateCheckArray=[];
        $siteDemandSlipCreateCheckArr=Array();

        foreach ($siteDemandSlipCreateList as $key => $value) {


            $siteDemandSlipCreateList=GlobalSiteStudentFeeGenerate::whereIn('student_history_id',$stdIDs)
                ->where('academic_fee_head_id',$value->academic_fee_head_id)
                ->where('fee_head_type_id',$value->fee_head_type_id)
                ->distinct('student_history_id')
                ->where('status',false)
                ->get(['student_history_id'])
                ->count();


//            \Log::info($siteDemandSlipCreateList);

            if(($siteDemandSlipCreateList*100/count($stdIDs))>=90){

                $siteDemandSlipCreateCheckArr['academic_fee_head_id']=$value->academic_fee_head_id;
                $siteDemandSlipCreateCheckArr['fee_head_type_id']=$value->fee_head_type_id;

                $siteDemandSlipCreateCheckArray[$key]=array_merge($siteDemandSlipCreateCheckArr);
            }

        }
        $siteDemandSlipCreateCheck=collect($siteDemandSlipCreateCheckArray);





        $siteFeeGenerateListCreate=GlobalSiteStudentFeeGenerate::whereIn('student_history_id',$stdIDs)
            ->distinct('academic_fee_head_id','fee_head_type_id')
            ->get(['academic_fee_head_id','fee_head_type_id']);


        $siteFeeGenerateCheckArray=[];
        $siteFeeGenerateCheckArr=Array();

        foreach ($siteFeeGenerateListCreate as $key => $value) {


            $siteFeeGenerateCreateList=GlobalSiteStudentFeeGenerate::whereIn('student_history_id',$stdIDs)
                ->where('academic_fee_head_id',$value->academic_fee_head_id)
                ->where('fee_head_type_id',$value->fee_head_type_id)
                ->distinct('student_history_id')
                ->get(['student_history_id'])
                ->count();


//            \Log::info($siteDemandSlipCreateList);

            if(($siteFeeGenerateCreateList*100/count($stdIDs))>=90){

                $siteFeeGenerateCheckArr['academic_fee_head_id']=$value->academic_fee_head_id;
                $siteFeeGenerateCheckArr['fee_head_type_id']=$value->fee_head_type_id;

                $siteFeeGenerateCheckArray[$key]=array_merge($siteFeeGenerateCheckArr);
            }

        }
        $siteFeeGenerateCheck=collect($siteFeeGenerateCheckArray);


        $sitePaymentListCreate=GlobalSiteStudentFeeGenerate::whereIn('student_history_id',$stdIDs)
            ->with(['globalSiteStudentFeeDemandSlipDetails'=>function($query){
                $query->where('status',false);
                $query->select('id');
            }])
            ->where('status',false)
            ->distinct('academic_fee_head_id','fee_head_type_id', 'site_student_fee_demand_slip_detail_id')
            ->get(['academic_fee_head_id','fee_head_type_id','site_student_fee_demand_slip_detail_id']);


        $countPaidDemandSlip=$sitePaymentListCreate->where('globalSiteStudentFeeDemandSlipDetails', '!=', null);



        $sitePaymentCheckArray=[];
        $sitePaymentCheckArr=Array();

        foreach ($siteFeeGenerateListCreate as $key => $value) {


            $sitePaymentCreateList=$countPaidDemandSlip
                ->where('academic_fee_head_id',$value->academic_fee_head_id)
                ->where('fee_head_type_id',$value->fee_head_type_id)
                ->count();


//            \Log::info($siteDemandSlipCreateList);

            if(($sitePaymentCreateList*100/count($stdIDs))>=20){

                $sitePaymentCheckArr['academic_fee_head_id']=$value->academic_fee_head_id;
                $sitePaymentCheckArr['fee_head_type_id']=$value->fee_head_type_id;

                $sitePaymentCheckArray[$key]=array_merge($sitePaymentCheckArr);
            }

        }
        $sitePaymentCheck=collect($sitePaymentCheckArray);



        $siteDetail=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
            ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->get();
        $ExaminationIDs=[];
        foreach ($siteDetail as $key => $value) {
            $ExaminationIDs[]= $value->examination_ids;
        }
        $ExaminationIdString = implode(',', $ExaminationIDs);
        $examinationID=explode(',', $ExaminationIdString);




        $headBaseTypelistArray=[];
        $headBaseTypelistArr=Array();
        foreach ($siteGroupFeeHeadList as $key => $value) {

            if($request->checked_site_id){

                if($value->head_key=='monthly'){
                    $list=AcademicMonthName::get();
                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);
                }
                else if($value->head_key=='examination'){

                    $selectedSiteGroupList=GlobalSiteInfoSetting::where('site_id',$request->checked_site_id)
                        ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->first();
                    $list= Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

                }
                else if($value->head_key=='admission'){

                    $list=AcademicAdmissionFeeType::get();
                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

                }
                else if($value->head_key=='general'){

                    $list=AcademicGeneralFeeType::get();
                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

                }
            }
            else{

//                return $value->id;


                if($value->head_key=='monthly'){
                    $list=AcademicMonthName::get();
                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);
                }
                else if($value->head_key=='examination'){

                    $list=Examination::whereIn('id', $examinationID)->get();

                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

                }
                else if($value->head_key=='admission'){

                    $list=AcademicAdmissionFeeType::get();
                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

                }
                else if($value->head_key=='general'){

                    $list=AcademicGeneralFeeType::get();
                    $headBaseTypelistArr['head_type']=
                        $this->headTypeList($list,$value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

                }


            }

            $headBaseTypelistArr['select_fee_head_id']=false;


            $headBaseTypelistArray[$key]=array_merge($headBaseTypelistArr, $value->toArray());


        }


        return response()->json([$siteList, $headBaseTypelistArray, $siteStudentIDs], 200, []);

    }





    private function headTypeList($list, $head_id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck){
        $headBaseTypelist=[];
        $headBaseTypelistArr=Array();
        foreach ($list as $keys => $values) {

            $check=$siteDemandSlipCreateCheck->where('academic_fee_head_id', $head_id)
                ->where('fee_head_type_id', $values->id)->first();

            $checkFeeGenerate=$siteFeeGenerateCheck->where('academic_fee_head_id', $head_id)
                ->where('fee_head_type_id', $values->id)->first();

            $checkPayment=$sitePaymentCheck->where('academic_fee_head_id', $head_id)
                ->where('fee_head_type_id', $values->id)->first();



            if($checkFeeGenerate){

                if($checkPayment){
                    $headBaseTypelistArr['demand_slip_created']=2;
                }else{
                    if($check){
                        $headBaseTypelistArr['demand_slip_created']=1;
                    }
                    else{
                        $headBaseTypelistArr['demand_slip_created']=0;
                    }
                }



                $headBaseTypelistArr['id']=$values->id;
                $headBaseTypelistArr['name']=$values->examination_name?$values->examination_name:$values->name;
                $headBaseTypelistArr['select_head_type_id']=false;

                $headBaseTypelist[$keys]=array_merge($headBaseTypelistArr);
            }

        }

        return $headBaseTypelist;
    }


    /**
     * @param Request $request
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    private function returnSiteStudentIDs(Request $request){

        $data = $request->all();


        if($request->academic_class_id){

            if($request->academic_class_group_present){

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])
                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);



            }else{

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])

                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);

            }

        }

        return $siteStudentIDs;

    }



    private function returnAllSiteStudentIDs(Request $request){

        $data = $request->all();


        if($request->academic_class_id){

            if($request->academic_class_group_present){

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])
//                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);



            }else{

                $siteStudentIDs=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id');
                }])

//                    ->where('site_id',$request->checked_site_id)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id']);

            }

        }

        return $siteStudentIDs;

    }








    public function createSiteGroupBaseDemandSlip(Request $request){



        $studentFeebaseArrayCollect=$this->returnStudentFeebaseArrayForCreate($request);

      //  dd($studentFeebaseArrayCollect);

        if($request->student_history_id){
            $SiteStudentIDArray=[$request->student_history_id];
        }else{
            $SiteStudentIDs= $this->returnSelectedSiteStudentIDs($request);
            $SiteStudentIDArray=$SiteStudentIDs->pluck('id');
        }




        $StudentLastDemandSlip= GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$SiteStudentIDArray)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('status',true)
            ->get();





        $today=Carbon::today();

        $charges=[];
        $site_student_fee_generate_ids=[];
        $site_student_fee_waiver_ids=[];
        $unpaidSlipID=[];
        foreach ($studentFeebaseArrayCollect as $key => $value) {



            $site_student_fee_generate_ids[]=$value['site_student_fee_generate_ids'];
            $site_student_fee_waiver_ids[]=$value['site_student_fee_waiver_offer_history_ids'];

            $checkUnpaidDemandSlip=$StudentLastDemandSlip->where('student_history_id', $value['id'])->first();

            if($checkUnpaidDemandSlip){

                $unpaidSlipID[]=$checkUnpaidDemandSlip->id;

                $previous_due=$checkUnpaidDemandSlip->total_amount;

            }else{

                $checkUnpaidpayment=GlobalSiteStudentFeePaymentHistory::where('student_history_id', $value['id'])
                    ->where('due_amount','>',0)
                    ->orderBy('id','desc')
                    ->first();
                if($checkUnpaidpayment){
                    $previous_due=$checkUnpaidpayment->due_amount;
                }else{
                    $previous_due=0;
                }




            }

            if($value['total_amount']>0 || $previous_due>0){
                $charges[] = [
                    'student_history_id' => $value['id'],
                    'site_group_id' => Session::get('SITE_GROUP_ID'),
                    'site_student_fee_generate_ids' => $value['site_student_fee_generate_ids'],
                    'site_student_fee_waiver_offer_history_ids' => $value['site_student_fee_waiver_offer_history_ids'],
                    'fee_amount' => $value['fee_amount'],
                    'waiver_amount' => $value['waiver_amount'],
                    'total_amount' => $value['total_amount']+$previous_due,
                    'previous_due' =>$previous_due,
                    'special_waiver_amount' =>$value['special_waiver_amount'],

                    'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                    'created_by' => Auth::user()->id,
                    'status' => true,
                    'site_id' => $value['site_id'],
                    'created_at' => $today,

//                'payment_duration' => ,
//                'offer_amount' => ,
                ];




            }




        }

        $site_student_fee_generate_ids_string = implode(',', $site_student_fee_generate_ids);
        $site_student_fee_generate_id=explode(',', $site_student_fee_generate_ids_string);


        $site_student_fee_waiver_ids_string = implode(',', $site_student_fee_waiver_ids);
        $site_student_fee_waiver_id=explode(',', $site_student_fee_waiver_ids_string);

//        return $site_student_fee_generate_id;

        if(count($charges)>0){
            GlobalSiteStudentFeeDemandSlipDetails::insert($charges);
        }


        $studentHistoryIDs=$studentFeebaseArrayCollect->pluck('id');
        $RecentelyCreatedDemandSlip=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDs)
            ->where('status',true)
            ->get(['id','student_history_id', 'site_student_fee_generate_ids', 'site_student_fee_waiver_offer_history_ids']);

           

        //Input site_student_fee_demand_slip_detail_id to GlobalSiteStudentFeeGenerate
        foreach ($studentFeebaseArrayCollect as $key => $value) {

            $checkID=$RecentelyCreatedDemandSlip->where('student_history_id',$value['id'])
                ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();

             //   dd($checkID);

            GlobalSiteStudentFeeGenerate::whereIn('id', explode(',', $value['site_student_fee_generate_ids']))
                ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);

        }


        //Input site_student_fee_demand_slip_detail_id to GlobalSiteStudentFeeWaiverOfferHistory
        foreach ($studentFeebaseArrayCollect as $key => $value) {

            $checkID=$RecentelyCreatedDemandSlip->where('student_history_id',$value['id'])
                ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();



            GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', explode(',', $value['site_student_fee_waiver_offer_history_ids']))
                ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);

        }


        GlobalSiteStudentFeeGenerate::whereIn('id', $site_student_fee_generate_id)
            ->update(['status' => false]);

        GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $site_student_fee_waiver_id)
            ->update(['status' => false]);

        GlobalSiteStudentFeeDemandSlipDetails::whereIn('id', $unpaidSlipID)
            ->update(['status' => false]);


        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);




    }



    private function returnStudentFeebaseArrayForCreate(Request $request){


        $SiteStudentIDs= $this->returnSelectedSiteStudentIDs($request);


        if($request->student_history_id){
            $SiteStudentIDArray=[$request->student_history_id];
        }else{

            $SiteStudentIDArray=$SiteStudentIDs->pluck('id');
        }





        //=======================Fee Generate and Waiver Generate combination

        $studentBaseGeneratedFee=GlobalSiteStudentFeeGenerate::with(['siteStudentFeeFineAllocation'=>function($query){
            $query->select('id','academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('student_history_id',$SiteStudentIDArray)
            ->where('status',true)
            ->get();


        $studentBaseGeneratedFeeWaiver=GlobalSiteStudentFeeWaiverOfferHistory::with(['siteStudentFeeFineAllocation'=>function($query){
            $query->select('id','academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('student_history_id',$SiteStudentIDArray)
            ->where('status',true)
            ->get();




        $studentBaseGeneratedFeeWaiverArr=Array();
        $studentBaseGeneratedFeeWaiverArray=[];
        foreach ($studentBaseGeneratedFeeWaiver as $key => $value) {

            $studentBaseGeneratedFeeWaiverArr['id']=$value->id;
            $studentBaseGeneratedFeeWaiverArr['student_history_id']=$value->student_history_id;
            $studentBaseGeneratedFeeWaiverArr['amount']=$value->amount;
            $studentBaseGeneratedFeeWaiverArr['fee_head_type_id']=$value->fee_head_type_id;
            $studentBaseGeneratedFeeWaiverArr['site_student_fee_fine_allocation_id']=$value->site_student_fee_fine_allocation_id;
            $studentBaseGeneratedFeeWaiverArr['academic_fee_head_id']=$value->siteStudentFeeFineAllocation?$value->siteStudentFeeFineAllocation->academic_fee_head_id:null;
            $studentBaseGeneratedFeeWaiverArr['head_key']=$value->siteStudentFeeFineAllocation?$value->siteStudentFeeFineAllocation->academicFeeHead->head_key:null;
            $studentBaseGeneratedFeeWaiverArr['percantage_status']=$value->percantage_status;

            $studentBaseGeneratedFeeWaiverArray[$key]=array_merge($studentBaseGeneratedFeeWaiverArr);
        }

        $studentBaseGeneratedFeeWaiverFinalArray=collect($studentBaseGeneratedFeeWaiverArray);





        $studentBaseGeneratedFeeArr=Array();
        $studentBaseGeneratedFeeArray=[];
        foreach ($studentBaseGeneratedFee as $key => $value) {

            $checkWaiver=$studentBaseGeneratedFeeWaiverFinalArray->where('student_history_id', $value['student_history_id'])
                ->where('site_student_fee_fine_allocation_id', $value['site_student_fee_fine_allocation_id'])
                ->where('fee_head_type_id', $value['fee_head_type_id'])->first();



            if($checkWaiver){
                $studentBaseGeneratedFeeArr['fee_generate_id']=$value->id;
                $studentBaseGeneratedFeeArr['student_history_id']=$value->student_history_id;
                $studentBaseGeneratedFeeArr['fee_amount']=$value->amount;
                $studentBaseGeneratedFeeArr['fee_head_type_id']=$value->fee_head_type_id;
                $studentBaseGeneratedFeeArr['academic_fee_head_id']=$value->siteStudentFeeFineAllocation->academic_fee_head_id;
                $studentBaseGeneratedFeeArr['head_key']=$value->siteStudentFeeFineAllocation->academicFeeHead->head_key;


                $studentBaseGeneratedFeeArr['waiver_generate_id']=$checkWaiver['id'];
                $studentBaseGeneratedFeeArr['waiver_amount']=$checkWaiver['percantage_status']?(($checkWaiver['amount'])*$value->amount/100):$checkWaiver['amount'];
                $studentBaseGeneratedFeeArr['waiver_percantage']=$checkWaiver['percantage_status']?$checkWaiver['amount']:0;
                $studentBaseGeneratedFeeArr['percantage_status']=$checkWaiver['percantage_status'];

            }
            else{
                $studentBaseGeneratedFeeArr['fee_generate_id']=$value->id;
                $studentBaseGeneratedFeeArr['student_history_id']=$value->student_history_id;
                $studentBaseGeneratedFeeArr['fee_amount']=$value->amount;
                $studentBaseGeneratedFeeArr['fee_head_type_id']=$value->fee_head_type_id;
                $studentBaseGeneratedFeeArr['academic_fee_head_id']=$value->siteStudentFeeFineAllocation->academic_fee_head_id;
                $studentBaseGeneratedFeeArr['head_key']=$value->siteStudentFeeFineAllocation->academicFeeHead->head_key;


                $studentBaseGeneratedFeeArr['waiver_generate_id']=null;
                $studentBaseGeneratedFeeArr['waiver_amount']=0;
                $studentBaseGeneratedFeeArr['waiver_percantage']=0;
                $studentBaseGeneratedFeeArr['percantage_status']=0;

            }


            $studentBaseGeneratedFeeArray[$key]=array_merge($studentBaseGeneratedFeeArr);

        }


        $studentBaseGeneratedFeeFinalArray=collect($studentBaseGeneratedFeeArray);




        $studentFeebaseArr=Array();
        $studentFeebaseArray=[];
        foreach ($SiteStudentIDs as $key => $value) {


            $studentFeeAmount=[];
            $studentFeeGenerate=[];

            $studentWaiverAmount=[];
            $studentWaiverGenerate=[];

            foreach ($request->FeeHeadTypeList as $keys => $values) {

                if($values['select_fee_head_id']){


                    foreach ($values['head_type'] as $keyst => $valuest) {

                        if($valuest['select_head_type_id']){

                            $IndevisualStudentFeeType= $studentBaseGeneratedFeeFinalArray
                                ->where('student_history_id', $value['id'])
                                ->where('fee_head_type_id', $valuest['id'])
                                ->where('academic_fee_head_id', $values['id']);



                            $studentFeeAmount[]=$IndevisualStudentFeeType->sum('fee_amount');
                            $studentFeeGenerate[]=$IndevisualStudentFeeType->pluck('fee_generate_id');

                            $studentWaiverAmount[]=$IndevisualStudentFeeType->sum('waiver_amount');
                            $studentWaiverGenerate[]=$IndevisualStudentFeeType->pluck('waiver_generate_id');

                        }
                    }

                }

            }

            $studentFeebaseArr['fee_amount']=array_sum($studentFeeAmount);
            $FeeGeneratecollection = collect($studentFeeGenerate);
            $FeeGeneratecollapsed = $FeeGeneratecollection->collapse();
            $studentFeebaseArr['site_student_fee_generate_ids']=implode( ',', $FeeGeneratecollapsed->toArray());






            $IndevisualStudentFeeWaiverType= $studentBaseGeneratedFeeWaiverFinalArray
                ->where('student_history_id', $value['id'])
                ->where('fee_head_type_id', null)
                ->where('academic_fee_head_id', null)->first();



            if($IndevisualStudentFeeWaiverType){

                $primayAmount=array_sum($studentFeeAmount)-array_sum($studentWaiverAmount);

                $studentFeebaseArr['total_amount']=$IndevisualStudentFeeWaiverType['percantage_status']?
                    ($primayAmount-($primayAmount*$IndevisualStudentFeeWaiverType['amount']/100)):
                    ($primayAmount-$IndevisualStudentFeeWaiverType['amount']);

                $studentFeebaseArr['special_waiver_amount']=$IndevisualStudentFeeWaiverType['percantage_status']?
                    ($primayAmount*$IndevisualStudentFeeWaiverType['amount']/100):
                    $IndevisualStudentFeeWaiverType['amount'];

            }else{
                $studentFeebaseArr['total_amount']=array_sum($studentFeeAmount)-array_sum($studentWaiverAmount);
                $studentFeebaseArr['special_waiver_amount']=0;
            }


//            return $this->generateBarcodeNumber();

         //   dd($IndevisualStudentFeeWaiverType);
            $studentFeebaseArr['waiver_amount']=array_sum($studentWaiverAmount);
       //     array_push($studentWaiverGenerate,[$IndevisualStudentFeeWaiverType['id']]);
            $FeeWaiverGeneratecollection = collect($studentWaiverGenerate);
            $WaiverGeneratecollapsed = $FeeWaiverGeneratecollection->collapse();

            $studentFeebaseArr['site_student_fee_waiver_offer_history_ids']=implode( ',', $WaiverGeneratecollapsed->filter()->toArray());


            $studentFeebaseArray[$key]=array_merge($studentFeebaseArr, $value->toArray());



        }

        return collect($studentFeebaseArray);

    }





    public function updateSiteGroupBaseDemandSlip(Request $request){


        $studentFeebaseArrayCollect=$this->returnStudentFeebaseArrayForUpdate($request);



        if($request->student_history_id){
            $SiteStudentIDArray=[$request->student_history_id];
        }else{
            $SiteStudentIDs= $this->returnSelectedSiteStudentIDs($request);
            $SiteStudentIDArray=$SiteStudentIDs->pluck('id');
        }


        $StudentLastDemandSlip= GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$SiteStudentIDArray)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->where('status',true)
            ->get();





        $today=Carbon::today();

        $charges=[];
        $site_student_fee_generate_ids=[];
        $site_student_fee_waiver_ids=[];
        foreach ($studentFeebaseArrayCollect as $key => $value) {

            $site_student_fee_generate_ids[]=$value['site_student_fee_generate_ids'];
            $site_student_fee_waiver_ids[]=$value['site_student_fee_waiver_offer_history_ids'];




            $checkDemandSlip=$StudentLastDemandSlip->where('student_history_id', $value['id'])->first();

            if($checkDemandSlip){

                $checkDemandSlip->site_student_fee_generate_ids=$value['site_student_fee_generate_ids'];
                $checkDemandSlip->site_student_fee_waiver_offer_history_ids= $value['site_student_fee_waiver_offer_history_ids'];
                $checkDemandSlip->fee_amount=$value['fee_amount'];
                $checkDemandSlip->waiver_amount=$value['waiver_amount'];
                $checkDemandSlip->special_waiver_amount=$value['special_waiver_amount'];
                $checkDemandSlip->total_amount=$value['total_amount'];
                $checkDemandSlip->save();

            }
//            else{
//
//
//
//                $charges[] = [
//                    'student_history_id' => $value['id'],
//                    'site_group_id' => Session::get('SITE_GROUP_ID'),
//                    'site_student_fee_generate_ids' => $value['site_student_fee_generate_ids'],
//                    'site_student_fee_waiver_offer_history_ids' => $value['site_student_fee_waiver_offer_history_ids'],
//                    'fee_amount' => $value['fee_amount'],
//                    'waiver_amount' => $value['waiver_amount'],
//                    'total_amount' => $value['total_amount'],
//
//                    'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
//                    'created_by' => Auth::user()->id,
//                    'status' => true,
//                    'site_id' => $value['site_id'],
//                    'created_at' => $today,
//
////                'previous_due' => ,
////                'payment_duration' => ,
////                'offer_amount' => ,
//                ];
//
//
//
//            }





        }

        $site_student_fee_generate_ids_string = implode(',', $site_student_fee_generate_ids);
        $site_student_fee_generate_id=explode(',', $site_student_fee_generate_ids_string);


        $site_student_fee_waiver_ids_string = implode(',', $site_student_fee_waiver_ids);
        $site_student_fee_waiver_id=explode(',', $site_student_fee_waiver_ids_string);

//        return $site_student_fee_generate_id;

        $studentHistoryIDs=$studentFeebaseArrayCollect->pluck('id');
        $RecentelyCreatedDemandSlip=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDs)
            ->where('status',true)
            ->get(['id','student_history_id', 'site_student_fee_generate_ids', 'site_student_fee_waiver_offer_history_ids']);


        //Input site_student_fee_demand_slip_detail_id to GlobalSiteStudentFeeGenerate
        foreach ($studentFeebaseArrayCollect as $key => $value) {

            $checkID=$RecentelyCreatedDemandSlip->where('student_history_id',$value['id'])
                ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();



            GlobalSiteStudentFeeGenerate::whereIn('id', explode(',', $value['site_student_fee_generate_ids']))
                ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);

        }


        //Input site_student_fee_demand_slip_detail_id to GlobalSiteStudentFeeWaiverOfferHistory
        foreach ($studentFeebaseArrayCollect as $key => $value) {

            $checkID=$RecentelyCreatedDemandSlip->where('student_history_id',$value['id'])
                ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();



            GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', explode(',', $value['site_student_fee_waiver_offer_history_ids']))
                ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);

        }





        if(count($charges)>0){
            GlobalSiteStudentFeeDemandSlipDetails::insert($charges);
        }


        GlobalSiteStudentFeeGenerate::whereIn('id', $site_student_fee_generate_id)
            ->update(['status' => false]);

        GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id', $site_student_fee_waiver_id)
            ->update(['status' => false]);


        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);



    }



    private function returnStudentFeebaseArrayForUpdate(Request $request){


        $SiteStudentIDs= $this->returnSelectedSiteStudentIDs($request);


        if($request->student_history_id){
            $SiteStudentIDArray=[$request->student_history_id];
        }else{

            $SiteStudentIDArray=$SiteStudentIDs->pluck('id');
        }





        //=======================Fee Generate and Waiver Generate combination

        $studentBaseGeneratedFeeList=GlobalSiteStudentFeeGenerate::with(['siteStudentFeeFineAllocation'=>function($query){
            $query->select('id','academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('student_history_id',$SiteStudentIDArray)
            ->where('status',true)
            ->get();
        $studentIdForFee=$studentBaseGeneratedFeeList->pluck('student_history_id')->unique();



        $studentBaseGeneratedFeeWaiverList=GlobalSiteStudentFeeWaiverOfferHistory::with(['siteStudentFeeFineAllocation'=>function($query){
            $query->select('id','academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('student_history_id',$SiteStudentIDArray)
            ->where('status',true)
            ->get();

        $studentIdForWaiver=$studentBaseGeneratedFeeWaiverList->pluck('student_history_id')->unique();







        $demandSlipList=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$SiteStudentIDArray)
            ->where('status',true)
            ->select('site_student_fee_generate_ids','site_student_fee_waiver_offer_history_ids')
            ->get();




        $demand_slip_fee_array=[];
        $demand_slip_waiver_array=[];
        foreach ($demandSlipList as $key => $value) {

            $demand_slip_fee_array[]=$value->site_student_fee_generate_ids;
            $demand_slip_waiver_array[]=$value->site_student_fee_waiver_offer_history_ids;

        }

        $site_fee_ids_string = implode(',', $demand_slip_fee_array);
        $site_fee_ids=explode(',', $site_fee_ids_string);


        $site_waiver_ids_string = implode(',', $demand_slip_waiver_array);
        $site_waiver_ids=explode(',', $site_waiver_ids_string);






        $fee_list_of_demand_slip=GlobalSiteStudentFeeGenerate::with(['siteStudentFeeFineAllocation'=>function($query){
            $query->select('id','academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('id',$site_fee_ids)
            ->get();

        $waiver_list_of_demand_slip=GlobalSiteStudentFeeWaiverOfferHistory::with(['siteStudentFeeFineAllocation'=>function($query){
            $query->select('id','academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('id',$site_waiver_ids)
            ->get();


        $studentBaseGeneratedFee=array_merge($fee_list_of_demand_slip->toArray(), $studentBaseGeneratedFeeList->toArray());
        $studentBaseGeneratedFeeWaiver=array_merge($waiver_list_of_demand_slip->toArray(), $studentBaseGeneratedFeeWaiverList->toArray());






            $studentBaseGeneratedFeeWaiverArray=[];
        $studentBaseGeneratedFeeWaiverArr=Array();
        foreach ($studentBaseGeneratedFeeWaiver as $key => $value) {

            $studentBaseGeneratedFeeWaiverArr['id']=$value['id'];
            $studentBaseGeneratedFeeWaiverArr['student_history_id']=$value['student_history_id'];
            $studentBaseGeneratedFeeWaiverArr['amount']=$value['amount'];
            $studentBaseGeneratedFeeWaiverArr['fee_head_type_id']=$value['fee_head_type_id'];
            $studentBaseGeneratedFeeWaiverArr['site_student_fee_fine_allocation_id']=$value['site_student_fee_fine_allocation_id'];
            $studentBaseGeneratedFeeWaiverArr['academic_fee_head_id']=$value['site_student_fee_fine_allocation']?$value['site_student_fee_fine_allocation']['academic_fee_head_id']:null;
            $studentBaseGeneratedFeeWaiverArr['head_key']=$value['site_student_fee_fine_allocation']?$value['site_student_fee_fine_allocation']['academic_fee_head']['head_key']:null;
            $studentBaseGeneratedFeeWaiverArr['percantage_status']=$value['percantage_status'];

            $studentBaseGeneratedFeeWaiverArray[$key]=array_merge($studentBaseGeneratedFeeWaiverArr);
        }

        $studentBaseGeneratedFeeWaiverFinalArray=collect($studentBaseGeneratedFeeWaiverArray);











        $studentBaseGeneratedFeeArr=Array();
        $studentBaseGeneratedFeeArray=[];
        foreach ($studentBaseGeneratedFee as $key => $value) {


            $checkWaiver=$studentBaseGeneratedFeeWaiverFinalArray->where('student_history_id', $value['student_history_id'])
                ->where('site_student_fee_fine_allocation_id', $value['site_student_fee_fine_allocation_id'])
                ->where('fee_head_type_id', $value['fee_head_type_id'])->first();


            if($checkWaiver){
                $studentBaseGeneratedFeeArr['fee_generate_id']=$value['id'];
                $studentBaseGeneratedFeeArr['student_history_id']=$value['student_history_id'];
                $studentBaseGeneratedFeeArr['fee_amount']=$value['amount'];
                $studentBaseGeneratedFeeArr['fee_head_type_id']=$value['fee_head_type_id'];
                $studentBaseGeneratedFeeArr['academic_fee_head_id']=$value['site_student_fee_fine_allocation']['academic_fee_head_id'];
                $studentBaseGeneratedFeeArr['head_key']=$value['site_student_fee_fine_allocation']['academic_fee_head']['head_key'];


                $studentBaseGeneratedFeeArr['waiver_generate_id']=$checkWaiver['id'];
                $studentBaseGeneratedFeeArr['waiver_amount']=$checkWaiver['percantage_status']?(($checkWaiver['amount'])*$value['amount']/100):$checkWaiver['amount'];
                $studentBaseGeneratedFeeArr['waiver_percantage']=$checkWaiver['percantage_status']?$checkWaiver['amount']:0;
                $studentBaseGeneratedFeeArr['percantage_status']=$checkWaiver['percantage_status'];

            }
            else{
                $studentBaseGeneratedFeeArr['fee_generate_id']=$value['id'];
                $studentBaseGeneratedFeeArr['student_history_id']=$value['student_history_id'];
                $studentBaseGeneratedFeeArr['fee_amount']=$value['amount'];
                $studentBaseGeneratedFeeArr['fee_head_type_id']=$value['fee_head_type_id'];
                $studentBaseGeneratedFeeArr['academic_fee_head_id']=$value['site_student_fee_fine_allocation']['academic_fee_head_id'];
                $studentBaseGeneratedFeeArr['head_key']=$value['site_student_fee_fine_allocation']['academic_fee_head']['head_key'];


                $studentBaseGeneratedFeeArr['waiver_generate_id']=null;
                $studentBaseGeneratedFeeArr['waiver_amount']=0;
                $studentBaseGeneratedFeeArr['waiver_percantage']=0;
                $studentBaseGeneratedFeeArr['percantage_status']=0;

            }


            $studentBaseGeneratedFeeArray[$key]=array_merge($studentBaseGeneratedFeeArr);

        }


        $studentBaseGeneratedFeeFinalArray=collect($studentBaseGeneratedFeeArray);





        $studentFeebaseArr=Array();
        $studentFeebaseArray=[];
        foreach ($SiteStudentIDs as $key => $value) {


            $studentFeeAmount=[];
            $studentFeeGenerate=[];

            $studentWaiverAmount=[];
            $studentWaiverGenerate=[];

            foreach ($request->FeeHeadTypeList as $keys => $values) {

                if($values['select_fee_head_id']){


                    foreach ($values['head_type'] as $keyst => $valuest) {

                        if($valuest['select_head_type_id']){

                            $IndevisualStudentFeeType= $studentBaseGeneratedFeeFinalArray
                                ->where('student_history_id', $value['id'])
                                ->where('fee_head_type_id', $valuest['id'])
                                ->where('academic_fee_head_id', $values['id']);



                            $studentFeeAmount[]=$IndevisualStudentFeeType->sum('fee_amount');
                            $studentFeeGenerate[]=$IndevisualStudentFeeType->pluck('fee_generate_id');

                            $studentWaiverAmount[]=$IndevisualStudentFeeType->sum('waiver_amount');
                            $studentWaiverGenerate[]=$IndevisualStudentFeeType->pluck('waiver_generate_id');

                        }
                    }

                }

            }

            $studentFeebaseArr['fee_amount']=array_sum($studentFeeAmount);
            $FeeGeneratecollection = collect($studentFeeGenerate);
            $FeeGeneratecollapsed = $FeeGeneratecollection->collapse();
            $studentFeebaseArr['site_student_fee_generate_ids']=implode( ',', $FeeGeneratecollapsed->toArray());






            $IndevisualStudentFeeWaiverType= $studentBaseGeneratedFeeWaiverFinalArray
                ->where('student_history_id', $value['id'])
                ->where('fee_head_type_id', null)
                ->where('academic_fee_head_id', null)->first();



            if($IndevisualStudentFeeWaiverType){

                $primayAmount=array_sum($studentFeeAmount)-array_sum($studentWaiverAmount);

                $studentFeebaseArr['total_amount']=$IndevisualStudentFeeWaiverType['percantage_status']?
                    ($primayAmount-($primayAmount*$IndevisualStudentFeeWaiverType['amount']/100)):
                    ($primayAmount-$IndevisualStudentFeeWaiverType['amount']);

                $studentFeebaseArr['special_waiver_amount']=$IndevisualStudentFeeWaiverType['percantage_status']?
                    ($primayAmount*$IndevisualStudentFeeWaiverType['amount']/100):
                    $IndevisualStudentFeeWaiverType['amount'];

            }else{
                $studentFeebaseArr['total_amount']=array_sum($studentFeeAmount)-array_sum($studentWaiverAmount);
                $studentFeebaseArr['special_waiver_amount']=0;
            }


//            return $this->generateBarcodeNumber();


            $studentFeebaseArr['waiver_amount']=array_sum($studentWaiverAmount);
            array_push($studentWaiverGenerate,[$IndevisualStudentFeeWaiverType['id']]);
            $FeeWaiverGeneratecollection = collect($studentWaiverGenerate);
            $WaiverGeneratecollapsed = $FeeWaiverGeneratecollection->collapse();

            $studentFeebaseArr['site_student_fee_waiver_offer_history_ids']=implode( ',', $WaiverGeneratecollapsed->filter()->toArray());


            $studentFeebaseArray[$key]=array_merge($studentFeebaseArr, $value->toArray());



        }

        return collect($studentFeebaseArray);

    }



    private function returnSiteGroupFeeList(Request $request){
        $data = $request->all();

        $FeeGroupsGlobalID=AcademicFeeGroup::whereIn('head_key', ['global'])->pluck('id');

        $FeeGroupsClassStudentID=AcademicFeeGroup::whereIn('head_key', ['classbase','studentbase'])->pluck('id');



        $FeeHeadIDs=[];
        foreach ($request->FeeHeadTypeList as $keys => $values) {

            if($values['select_fee_head_id']){
                $FeeHeadIDs[]=$values['id'];
            }

        }

        $siteGroupFeeList=Array();
        if(count($request->select_site_info_ids)>0 && count($FeeHeadIDs)>0 && $request->academic_class_id!=null){






            $SiteFeeList=GlobalSiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                ->where('site_group_id',Session::get('SITE_GROUP_ID'))
                ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))
                ->whereIn('site_id',$request->select_site_info_ids)
                ->whereIn('academic_fee_head_id',$FeeHeadIDs)
                ->where('academic_version_id',$request->academic_version_id)
                ->where('academic_shift_id',$request->academic_shift_id)
                ->where('academic_year_id',$request->academic_year_id)
                ->where('status',true)
                ->get();


            $siteGlobalFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsGlobalID)
                ->where('academic_class_id', null)
                ->where('academic_department_id', null);





            $siteClassStudentFeeList=$SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsClassStudentID)
                ->where('academic_class_id',$request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                });

            if($request->academic_student_category_id!=null || $request->academic_student_type_id!=null
                || $request->academic_student_admission_type_id!=null)
            {
                $siteGroupFeeList=$siteClassStudentFeeList;

            }else{
                $siteGroupFeeList=array_merge($siteGlobalFeeList->toArray(), $siteClassStudentFeeList->toArray());
            }



        }

        return $siteGroupFeeList;
    }




    private function returnSelectedSiteStudentIDs(Request $request){

        $data = $request->all();


        if($request->academic_class_id){

            if($request->academic_class_group_present){

                $siteStudentIDs=GlobalStudentHistory::whereIn('site_id',$request->select_site_info_ids)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))

                    ->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id', 'site_id']);



            }else{

                $siteStudentIDs=GlobalStudentHistory::whereIn('site_id',$request->select_site_info_ids)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))

                    ->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                    ->where('academic_version_id',$request->academic_version_id)
                    ->where('academic_shift_id',$request->academic_shift_id)
                    ->where('academic_year_id',$request->academic_year_id)
                    ->where('academic_class_id',$request->academic_class_id)
                    ->where('status',true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id','user_id','site_id']);

            }

        }

        return $siteStudentIDs;

    }








}
