<?php

namespace App\Http\Controllers\SiteGroup\ExamResult;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicResultSystem;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Result\GlobalSiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetailForTabulation;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultSystemSettingStore;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\Settings\SiteGroupAcademicSettingsStore;
use App\Models\SiteGroup\Settings\SiteGroupSubjectGroupConditionSettingStore;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;

use Carbon\Carbon;
use Session;
use Response;
use PDF;
use Illuminate\Support\Facades\Log;


class SiteGroupExamResultReportController extends SiteGroupProjectController
{
    private $siteGroupSettings;
    private $globalSiteIndividualCombineSubjectResultStore;

    public function __construct(SiteGroupAcademicSettingsStore $siteGroupSettings, GlobalSiteIndividualCombineSubjectResultStore $globalSiteIndividualCombineSubjectResultStore)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->siteGroupSettings = $siteGroupSettings;
    }

    public function index()
    {
        //  dd('sf');
        $viewType = "Site Group Exam Result Generate";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getStieGroupBaseResultTypeList(Request $request)
    {

        $data = $request->all();

        $resultSettingList = SiteGroupResultPrimarySettingStore::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();


        $resultSettingListIds = $resultSettingList->pluck('academic_result_primary_type_id')->unique()->filter();

        $siteExamDeclares = GlobalSiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('exam_declared_by', 'site_group')
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();

        $site_ids = $siteExamDeclares->pluck('site_id');


        //  return $resultSettingListIds;

        $academic_result_primary_type_id_array = [];
        foreach ($resultSettingListIds as $key => $value) {

            $ExaminationFromSetting = $resultSettingList->where('academic_result_primary_type_id', $value);
            $ExaminationIDsFromSetting = $ExaminationFromSetting->pluck('examination_id')->unique();
            $countExaminationFromSetting = count($ExaminationIDsFromSetting);

            $ExaminationFromExamDeclare = $siteExamDeclares->whereIn('examination_id', $ExaminationIDsFromSetting);
            $ExaminationIDsFromExamDeclare = $ExaminationFromExamDeclare->pluck('examination_id')->unique();
            $countExaminationFromExamDeclare = count($ExaminationIDsFromExamDeclare);

            if ($countExaminationFromSetting == $countExaminationFromExamDeclare) {
                $academic_result_primary_type_id_array[] = $value;
            }
        }

        $resultlist_test = AcademicResultPrimaryType::whereIn('id', $academic_result_primary_type_id_array)->where('use_key', 'site_group')->get();

        return $resultlist_test;
    }

    public function getResultGeneratedSiteList(Request $request)
    {

        $data = $request->all();

        $student_histories_ids = GlobalStudentHistory::select('id', 'user_id', 'student_roll_number', 'site_batch_detail_id')
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->pluck('id')
            ->unique()
            ->values();

        $student_history_ids = SiteGroupStudentExamRoll::with('studentHistory')
            ->whereIn('student_history_id', $student_histories_ids)
            ->pluck('student_history_id');

        //   $getStudentList=$getStudentList->whereIn('id',$student_history_ids);

        $site_ids = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->pluck('site_id')
            ->unique()
            ->values();

        $site_list = GlobalSiteInfo::whereIn('id', $site_ids)->get();

        return $site_list;
    }

    private function getStudentList($request, $site_ids)
    {

        $data = $request->all();

        $data['academic_class_group_id'] = $data['academic_class_group_id'] != 'null' ? $data['academic_class_group_id'] : '';
        $data['academic_department_id'] = $data['academic_department_id'] != 'null' ? $data['academic_department_id'] : '';
        $data['academic_section_id'] = $data['academic_section_id'] != 'null' ? $data['academic_section_id'] : '';



        $studentList = GlobalStudentHistory::with(['department', 'stClass', 'classGroup', 'section'])
            ->select('id','academic_year_id','academic_version_id','academic_shift_id',
                'academic_class_id','academic_department_id','academic_section_id','academic_class_group_id','student_roll_number','site_id'
            )
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(count($site_ids)  > 0, function ($query) use ($data,  $site_ids) {
                return $query->whereIn('site_id', $site_ids);
            })

            ->where('transfer_status', 0)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
           // ->where('status', true)
            ->orderBy('student_roll_number')
            ->orderBy('academic_department_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_section_id')
            ->get();

        return $studentList;
    }


    public function getSiteGroupPrimaryResultTotalSummaryPdf(Request $request)
    {
        // return $request;
        $jsonResponse = $this->getSiteGroupPrimaryResultTotalSummary($request);

        $with_grade = filter_var($request->with_grade, FILTER_VALIDATE_BOOLEAN);;
        $SiteGroupPrimaryResultTotalSummary = json_decode($jsonResponse->getContent(), true);

        $siteGroup = GlobalSiteGroup::find(Session::get('SITE_GROUP_ID'));

        $sheet_info = [
            'site_name' => $siteGroup->name,
            'result_name' => optional(AcademicResultPrimaryType::find($request->academic_result_primary_type_id))->name,
            'class_name'  => optional(AcademicClass::find($request->academic_class_id))->class_name,
            'shift_name'  => optional(AcademicShift::find($request->academic_shift_id))->shift_name,
            'year_name'   => optional(AcademicYear::find($request->academic_year_id))->year_name,
        ];

        // dd($result_array);

        //    return $result_array;

        $report_tittle = "";

        $report_tittle .= "Summary of the " . $sheet_info['result_name'] . " " . $sheet_info['year_name'];

        $report_tittle2 = "";
        //   $report_tittle2="";
        $report_tittle2 .= "<b>Year: </b>" . $sheet_info['year_name'];
        $report_tittle2 .= ",";
        $report_tittle2 .= " <b>Shift: </b>" . $sheet_info['shift_name'];

        // $report_tittle .= "<br>";

        if ($request->academic_department_id) {
            $department = AcademicDepartment::where('id', $request->academic_department_id)->first();

            if ($department) {
                $report_tittle2 .= "<b> Dept: </b>" . ($department ? $department->name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_class_id) {
            $class = AcademicClass::where('id', $request->academic_class_id)->first();
            $report_tittle2 .= "<b> Class: </b>" . ($class ? $class->class_name : '');
            $report_tittle2 .= ",";
        }


        if ($request->academic_class_group_id) {
            $group = AcademicClassGroup::where('id', $request->academic_class_group_id)->first();
            if ($group) {
                $report_tittle2 .= "<b> Group: </b>" . ($group ? $group->group_name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_section_id) {
            $section = AcademicSection::where('id', $request->academic_section_id)->first();
            if ($section) {
                $report_tittle2 .= "<b> Section: </b>" . ($section ? $section->section_name : '');
                $report_tittle2 .= ",";
            }
        }
        if ($request->academic_session_id) {
            $session = AcademicSession::where('id', $request->academic_session_id)->first();
            if ($session) {
                $report_tittle2 .= "<b> Session: </b>" . ($session ? $session->session_name : '');
            }
        }


        ini_set('memory_limit', '2048M');
        $pdf = PDF::loadView(
            'default.admin.site_group.result.result_report.site-group-base-summry-result-report',
            [
                'site_result_list' => $SiteGroupPrimaryResultTotalSummary['site_result_list'],
                'grade_system_list' => $SiteGroupPrimaryResultTotalSummary['grade_system_list'],
                'global_grade_summary' => $SiteGroupPrimaryResultTotalSummary['global_grade_summary'],


                'total_student_count'        => $SiteGroupPrimaryResultTotalSummary['total_student_count'],
                'total_declared_count'       => $SiteGroupPrimaryResultTotalSummary['total_declared_count'],
                'total_passed_student_count' => $SiteGroupPrimaryResultTotalSummary['total_passed_student_count'],
                'total_absent_student_count' => $SiteGroupPrimaryResultTotalSummary['total_absent_student_count'],
                'total_failed_student_count' => $SiteGroupPrimaryResultTotalSummary['total_failed_student_count'],
                'total_percentice_count'     => $SiteGroupPrimaryResultTotalSummary['total_percentice_count'],
                'with_grade' =>               $with_grade,

                'sheet_info' => $sheet_info,
                'report_tittle' => $report_tittle,
                'report_tittle2' => $report_tittle2,
                'siteGroup' => $siteGroup
            ]
        )->setPaper('a4', 'portrait')->setWarnings(false);

        $random = rand(0, 100000);
        $time = $random . '-' . Carbon::now()->unix();
        $name = $time . '.pdf';

        return $pdf->stream($name);
    }
    public function getSiteGroupPrimaryResultPassFailTotalSummaryPdf(Request $request)
    {
        $ResultPassFailTotalSummary =  $this->getSiteGroupPrimaryResultPassFailTotalSummary($request);



        $siteGroup = GlobalSiteGroup::find(Session::get('SITE_GROUP_ID'));

        $sheet_info = [
            'site_name' => $siteGroup->name,
            'result_name' => optional(AcademicResultPrimaryType::find($request->academic_result_primary_type_id))->name,
            'class_name'  => optional(AcademicClass::find($request->academic_class_id))->class_name,
            'shift_name'  => optional(AcademicShift::find($request->academic_shift_id))->shift_name,
            'year_name'   => optional(AcademicYear::find($request->academic_year_id))->year_name,
        ];

        // dd($result_array);

        //    return $result_array;

        $report_tittle = "";

        $report_tittle .= "Summary of the " . $sheet_info['result_name'] . " " . $sheet_info['year_name'];

        $report_tittle2 = "";
        //   $report_tittle2="";
        $report_tittle2 .= "<b>Year: </b>" . $sheet_info['year_name'];
        $report_tittle2 .= ",";
        $report_tittle2 .= " <b>Shift: </b>" . $sheet_info['shift_name'];

        // $report_tittle .= "<br>";

        if ($request->academic_department_id) {
            $department = AcademicDepartment::where('id', $request->academic_department_id)->first();

            if ($department) {
                $report_tittle2 .= "<b> Dept: </b>" . ($department ? $department->name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_class_id) {
            $class = AcademicClass::where('id', $request->academic_class_id)->first();
            $report_tittle2 .= "<b> Class: </b>" . ($class ? $class->class_name : '');
            $report_tittle2 .= ",";
        }


        if ($request->academic_class_group_id) {
            $group = AcademicClassGroup::where('id', $request->academic_class_group_id)->first();
            if ($group) {
                $report_tittle2 .= "<b> Group: </b>" . ($group ? $group->group_name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_section_id) {
            $section = AcademicSection::where('id', $request->academic_section_id)->first();
            if ($section) {
                $report_tittle2 .= "<b> Section: </b>" . ($section ? $section->section_name : '');
                $report_tittle2 .= ",";
            }
        }
        if ($request->academic_session_id) {
            $session = AcademicSession::where('id', $request->academic_session_id)->first();
            if ($session) {
                $report_tittle2 .= "<b> Session: </b>" . ($session ? $session->session_name : '');
            }
        }


        ini_set('memory_limit', '2048M');
        $pdf = PDF::loadView(
            'default.admin.site_group.result.result_report.site-group-base-summry-result-pass-fail-report',
            [
                'global_subject_summary' => $ResultPassFailTotalSummary['global_subject_summary'],
                'global_failed_subject_list' => $ResultPassFailTotalSummary['global_failed_subject_list'],


                'sheet_info' => $sheet_info,
                'report_tittle' => $report_tittle,
                'report_tittle2' => $report_tittle2,
                'siteGroup' => $siteGroup
            ]
        )->setPaper('a4', 'portrait')->setWarnings(false);

        $random = rand(0, 100000);
        $time = $random . '-' . Carbon::now()->unix();
        $name = $time . '.pdf';

        return $pdf->stream($name);
    }
    public function getSiteGroupPrimaryResultPassFailTotalSummary(Request $request)
    {
        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }
        if (count($site_ids) == 0) {
            $site_ids = $this->siteIds();
        }
        if ($request->site_id == 'null') {
            $site_ids = $this->siteIds();
        }

        // $site_ids = [33, 171];

        $getStudentList = $this->getStudentList($request, $site_ids);
        $studentHistoryIds = $getStudentList->pluck('id');

        foreach ($getStudentList as $student) {
            $student->student_roll_number = $student->student_roll_number;
        }

        $result = [];

        //  Global summary per subject
        $globalSubjectSummary = [];
        $global_failed_subject_count = collect();

        $resultDetailsList = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $studentHistoryIds)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('site_id', $site_ids)
            ->get();

        foreach ($site_ids as $site_key => $site_id) {
            $site_info = GlobalSiteInfo::find($site_id);
            $result[$site_key] = [
                'site_id' => $site_id,
                'site_name' => $site_info->site_name ?? '',
            ];

            $resultDetails = $resultDetailsList->where('site_id', $site_id)
                ->where('exam_attendance_status', true);


            $student_history_ids = $resultDetails->pluck('student_history_id')->unique();

            $individual_result_list = GlobalSiteIndividualCombineSubjectResultStore:: //whereIn('student_history_id', $studentHistoryIds)
                where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_history_ids)
                ->where('subject_result_count_status', true)
                ->where('site_id', $site_id)
                ->get();

            $subCons = SiteGroupSubjectGroupConditionSettingStore::where('academic_class_id', $request->academic_class_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('status', true)
                ->get();

            $groupedBySubject = $individual_result_list->groupBy('exam_dependent_academic_subject_id');
            $gradeList = $individual_result_list->pluck('subject_grade')->unique()->values();

            $subjectIds = $groupedBySubject->keys();
            $subjects = AcademicSubject::whereIn('id', $subjectIds)->get()->keyBy('id');

            $subject_result_array = [];

            foreach ($groupedBySubject as $subjectId => $students) {

                // dd($subjectId);

                $subCon = $subCons->where('academic_subject_id', $subjectId)->first();

                //  dd($subCon);

                $subject = $subjects[$subjectId];
                $subjectName = $subject->subject_name;

                $total_student_count = $students->count();
                $attended = $students->where('exam_attendance_status', true);
                $absent_student_count = $students->where('exam_attendance_status', false)->count();
                $attended_student_count = $attended->count();
                $passed_student_count = $attended->where('subject_point', '>', 0)->count();
                $failed_student_count = $attended->where('subject_point', 0)->count();

                //  GLOBAL SUBJECT-WISE SUMMARY
                if (!isset($globalSubjectSummary[$subjectName])) {
                    $globalSubjectSummary[$subjectName] = [
                        'total_student_count' => 0,
                        'attended_student_count' => 0,
                        'absent_student_count' => 0,
                        'passed_student_count' => 0,
                        'failed_student_count' => 0,
                    ];
                }

                $globalSubjectSummary[$subjectName]['total_student_count'] += $total_student_count;
                $globalSubjectSummary[$subjectName]['attended_student_count'] += $attended_student_count;
                $globalSubjectSummary[$subjectName]['absent_student_count'] += $absent_student_count;
                $globalSubjectSummary[$subjectName]['passed_student_count'] += $passed_student_count;
                $globalSubjectSummary[$subjectName]['failed_student_count'] += $failed_student_count;
                $globalSubjectSummary[$subjectName]['subject_position'] = $subCon->subject_position;

            }

            //  Failed Subject Summary
            $failedDetails = $resultDetails
                ->where('fail_subject_count', '>', 0);

      
        }

        //  Add global subject-wise summary
        $result['global_subject_summary'] = collect($globalSubjectSummary)->map(function ($item, $subjectName) {
            return array_merge(['subject_name' => $subjectName], $item);
        })
            ->sortBy('subject_position')
            ->values()
            ->toArray();

        $global_failed_subject_list = $global_failed_subject_count
            ->groupBy('fail_subject_count')
            ->map(function ($group, $failCount) {
                return [
                    'failed_subject_count' => (int) $failCount,
                    'failed_subject_student' => $group->count()
                ];
            })
            ->sortBy('failed_subject_count')
            ->values()
            ->toArray();

        $result['global_failed_subject_list'] = $global_failed_subject_list;

        return $result;
    }
    public function getSiteGroupPrimaryResultGradingTotalSummaryPdf(Request $request)
    {

        $jsonResponse = $this->getSiteGroupPrimaryResultGradingTotalSummary($request);

        $SiteGroupPrimaryResultTotalSummary = json_decode($jsonResponse->getContent(), true);

        $siteGroup = GlobalSiteGroup::find(Session::get('SITE_GROUP_ID'));

        $sheet_info = [
            'site_name' => $siteGroup->name,
            'result_name' => optional(AcademicResultPrimaryType::find($request->academic_result_primary_type_id))->name,
            'class_name'  => optional(AcademicClass::find($request->academic_class_id))->class_name,
            'shift_name'  => optional(AcademicShift::find($request->academic_shift_id))->shift_name,
            'year_name'   => optional(AcademicYear::find($request->academic_year_id))->year_name,
        ];

        // dd($result_array);

        //    return $result_array;

        $report_tittle = "";

        $report_tittle .= "Summary of the " . $sheet_info['result_name'] . " " . $sheet_info['year_name'];

        $report_tittle2 = "";
        //   $report_tittle2="";
        $report_tittle2 .= "<b>Year: </b>" . $sheet_info['year_name'];
        $report_tittle2 .= ",";
        $report_tittle2 .= " <b>Shift: </b>" . $sheet_info['shift_name'];

        // $report_tittle .= "<br>";

        if ($request->academic_department_id) {
            $department = AcademicDepartment::where('id', $request->academic_department_id)->first();

            if ($department) {
                $report_tittle2 .= "<b> Dept: </b>" . ($department ? $department->name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_class_id) {
            $class = AcademicClass::where('id', $request->academic_class_id)->first();
            $report_tittle2 .= "<b> Class: </b>" . ($class ? $class->class_name : '');
            $report_tittle2 .= ",";
        }


        if ($request->academic_class_group_id) {
            $group = AcademicClassGroup::where('id', $request->academic_class_group_id)->first();
            if ($group) {
                $report_tittle2 .= "<b> Group: </b>" . ($group ? $group->group_name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_section_id) {
            $section = AcademicSection::where('id', $request->academic_section_id)->first();
            if ($section) {
                $report_tittle2 .= "<b> Section: </b>" . ($section ? $section->section_name : '');
                $report_tittle2 .= ",";
            }
        }
        if ($request->academic_session_id) {
            $session = AcademicSession::where('id', $request->academic_session_id)->first();
            if ($session) {
                $report_tittle2 .= "<b> Session: </b>" . ($session ? $session->session_name : '');
            }
        }

        //  dd($SiteGroupPrimaryResultTotalSummary['total_declared_count']);



        ini_set('memory_limit', '2048M');
        $pdf = PDF::loadView(
            'default.admin.site_group.result.result_report.site-group-base-summry-result-grading-report',
            [
                'site_result_list' => $SiteGroupPrimaryResultTotalSummary['site_result_list'],
                'grade_system_list' => $SiteGroupPrimaryResultTotalSummary['grade_system_list'],
                'global_grade_summary' => $SiteGroupPrimaryResultTotalSummary['global_grade_summary'],
                'total_student_count' => $SiteGroupPrimaryResultTotalSummary['total_student_count'],
                'total_declared_count' => $SiteGroupPrimaryResultTotalSummary['total_declared_count'],

                'sheet_info' => $sheet_info,
                'report_tittle' => $report_tittle,
                'report_tittle2' => $report_tittle2,
                'siteGroup' => $siteGroup
            ]
        )->setPaper('a4', 'portrait')->setWarnings(false);

        $random = rand(0, 100000);
        $time = $random . '-' . Carbon::now()->unix();
        $name = $time . '.pdf';

        return $pdf->stream($name);
    }
    public function getSiteGroupPrimaryResultGradingTotalSummary(Request $request)
    {
        $grade_system_list = SiteGroupResultSystemSettingStore::with('academicResultSystem')->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_version_id)
            ->orderBy('point', 'desc')
            ->get();
        $data = $request->all();

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }
        if (count($site_ids) == 0) {
            $site_ids = $this->siteIds();
        }
        if ($request->site_id == 'null') {
            $site_ids = $this->siteIds();
        }


        $getStudentList = $this->getStudentList($request, $site_ids);

        foreach ($getStudentList as $key => $value) {
            $getStudentList[$key]->student_roll_number = $value->student_roll_number;
        }

        $site_result_array = [];
        $global_grade_totals = [];

        foreach ($site_ids as $key => $site_id) {

            $site_info = GlobalSiteInfo::find($site_id);
            $filtered_student_list = $getStudentList->where('site_id', $site_id);

            $student_history_ids = $filtered_student_list->pluck('id');

            $result_list = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('status', true)
                ->where('site_id', $site_id)
                ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade')
                ->get();

            // $declared_count = count($result_list);
            // $passed_count = $result_list->where('fail_subject_count', 0)->where('exam_attendance_status', true)->count();

            // $site_result_array[$key]['site_id'] = $site_info->id;
            // $site_result_array[$key]['site_name'] = $site_info->site_name;
            // $site_result_array[$key]['site_student_count'] = count($filtered_student_list);
            // $site_result_array[$key]['site_declared_student_count'] = $declared_count;
            // $site_result_array[$key]['site_passed_student_count'] = $passed_count;
            // $site_result_array[$key]['site_absent_student_count'] = $result_list->where('exam_attendance_status', false)->count();
            // $site_result_array[$key]['site_failed_student_count'] = $result_list->where('fail_subject_count', '>', 0)->where('exam_attendance_status', true)->count();
            // $site_result_array[$key]['percentice'] = $declared_count > 0 ? round(($passed_count / $declared_count) * 100, 2) : 0;


            $total_student_count = count($result_list);
            $total_student_without_absent_count = $result_list->where('exam_attendance_status', true)->count();
            $passed_count = $result_list->where('fail_subject_count', 0)->where('exam_attendance_status', true)->count();
            $failed_count = $result_list->where('fail_subject_count', '>', 0)->where('exam_attendance_status', true)->count();
            $absent_count = $result_list->where('exam_attendance_status', false)->count();


            $site_result_array[$key]['site_id'] = $site_info->id;
            $site_result_array[$key]['site_name'] = $site_info->site_name;
            $site_result_array[$key]['site_student_count'] = $total_student_count;
            $site_result_array[$key]['site_declared_student_count'] = $total_student_without_absent_count;
            $site_result_array[$key]['site_passed_student_count'] = $passed_count;
            $site_result_array[$key]['site_absent_student_count'] = $absent_count;
            $site_result_array[$key]['site_failed_student_count'] = $failed_count;
            $site_result_array[$key]['percentice'] = $total_student_without_absent_count > 0 ? round(($passed_count / $total_student_without_absent_count) * 100, 2) : 0;



            $grade_array = [];

            foreach ($grade_system_list as $keyss => $grade_system) {
                $grade_name = $grade_system->academicResultSystem->name;
                $count = $result_list->where('grade', $grade_name)->where('exam_attendance_status', true)->count();

                // Per-site grade data
                $grade_array[$keyss]['count'] = $count;
                $grade_array[$keyss]['grade'] = $grade_name;

                // Global grade count update
                if (!isset($global_grade_totals[$grade_name])) {
                    $global_grade_totals[$grade_name] = 0;
                }
                $global_grade_totals[$grade_name] += $count;
            }

            $site_result_array[$key]['grade_array'] = $grade_array;
        }

        $total_passed_student_count = collect($site_result_array)->sum('site_passed_student_count');
        $total_failed_student_count = collect($site_result_array)->sum('site_failed_student_count');
        $total_student_count = collect($site_result_array)->sum('site_student_count');
        $total_declared_student_count = collect($site_result_array)->sum('site_declared_student_count');
        $total_absent_student_count = collect($site_result_array)->sum('site_absent_student_count');

        $global_grade_summary = [];
        foreach ($global_grade_totals as $grade => $count) {
            $global_grade_summary[] = [
                'grade' => $grade,
                'count' => $count
            ];
        }





        return response()->json([
            'status' => 200,
            'message' => 'Site Group Primary Result Total Summary',
            'site_result_list' => $site_result_array,
            'grade_system_list' => $grade_system_list,
            'global_grade_summary' => $global_grade_summary,
            'total_student_count' => $total_student_count,
            'total_declared_count' => $total_declared_student_count,
            'total_passed_student_count' => $total_passed_student_count,
            'total_absent_student_count' => $total_absent_student_count,
            'total_failed_student_count' => $total_failed_student_count,
        ]);
    }
    public function getSiteGroupPrimaryResultTotalSummary(Request $request)
    {
        // return 'jahin';

        $data = $request->all();
        $with_grade = $request->with_grade;

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }
        if (count($site_ids) == 0) {
            $site_ids = $this->siteIds();
        }

        if ($request->site_id == 'null') {
            $site_ids = $this->siteIds();
        }


        $getStudentList = $this->getStudentList($request, $site_ids);

        foreach ($getStudentList as $key => $value) {
            $getStudentList[$key]->student_roll_number = $value->student_roll_number;
        }

        $grade_system_list = SiteGroupResultSystemSettingStore::with('academicResultSystem')->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_version_id)
            ->orderBy('point', 'desc')
            ->get();

        $global_grade_totals = [];
        $site_result_array = [];

        foreach ($site_ids as $key => $site_id) {
            //  if($site_id==33){


            $site_info = GlobalSiteInfo::find($site_id);
            $filtered_student_list = $getStudentList->where('site_id', $site_id);

            // dd($site_id);

            $student_history_ids = $filtered_student_list->pluck('id');

            $result_list = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('status', true)
                ->where('site_id', $site_id)
                ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade')
                ->get();

            // $declared_count = count($result_list);
            // $passed_count = $result_list->where('fail_subject_count', 0)->where('exam_attendance_status', true)->count();


            // $site_result_array[$key]['site_id'] = $site_info->id;
            // $site_result_array[$key]['site_name'] = $site_info->site_name;
            // $site_result_array[$key]['site_student_count'] = count($result_list);
            // $site_result_array[$key]['site_declared_student_count'] = count($result_list);
            // $site_result_array[$key]['site_passed_student_count'] = $result_list->where('fail_subject_count', 0)->where('exam_attendance_status', true)->count();
            // $site_result_array[$key]['site_absent_student_count'] = $result_list->where('exam_attendance_status', false)->count();
            // $site_result_array[$key]['site_failed_student_count'] = $result_list->where('fail_subject_count', '>', 0)->where('exam_attendance_status', true)->count();
            // $site_result_array[$key]['percentice'] = $declared_count > 0 ? round(($passed_count / $declared_count) * 100, 2) : 0;

            $total_student_count = count($result_list);
            $total_declared_student_without_absent_count = $result_list->where('exam_attendance_status', true)->count();
            $passed_count = $result_list->where('fail_subject_count', 0)->where('exam_attendance_status', true)->count();
            $failed_count = $result_list->where('fail_subject_count', '>', 0)->where('exam_attendance_status', true)->count();
            $absent_count = $result_list->where('exam_attendance_status', false)->count();


            $site_result_array[$key]['site_id'] = $site_info->id;
            $site_result_array[$key]['site_name'] = $site_info->site_name;
            $site_result_array[$key]['site_student_count'] = $total_student_count;
            $site_result_array[$key]['site_declared_student_count'] = $total_declared_student_without_absent_count;
            $site_result_array[$key]['site_passed_student_count'] = $passed_count;
            $site_result_array[$key]['site_absent_student_count'] = $absent_count;
            $site_result_array[$key]['site_failed_student_count'] = $failed_count;
            $site_result_array[$key]['percentice'] = $total_declared_student_without_absent_count > 0 ? round(($passed_count / $total_declared_student_without_absent_count) * 100, 2) : 0;

            $grade_array = [];

            foreach ($grade_system_list as $keyss => $grade_system) {
                $grade_name = $grade_system->academicResultSystem->name;
                $count = $result_list->where('exam_attendance_status', true)->where('grade', $grade_name)->count();

                // Per-site grade data
                $grade_array[$keyss]['count'] = $count;
                $grade_array[$keyss]['grade'] = $grade_name;

                // Global grade count update
                if (!isset($global_grade_totals[$grade_name])) {
                    $global_grade_totals[$grade_name] = 0;
                }
                $global_grade_totals[$grade_name] += $count;
            }

            $site_result_array[$key]['grade_array'] = $grade_array;
        }

        $total_passed_student_count = collect($site_result_array)->sum('site_passed_student_count');
        $total_declared_student_count = collect($site_result_array)->sum('site_declared_student_count');
        $total_percentice_count = $total_declared_student_count > 0 ? round(($total_passed_student_count / $total_declared_student_count) * 100, 2) : 0;;

        $total_failed_student_count = collect($site_result_array)->sum('site_failed_student_count');
        $total_student_count = collect($site_result_array)->sum('site_student_count');
        $total_absent_student_count = collect($site_result_array)->sum('site_absent_student_count');

        $global_grade_summary = [];
        foreach ($global_grade_totals as $grade => $count) {
            $global_grade_summary[] = [
                'grade' => $grade,
                'count' => $count
            ];
        }


        usort($site_result_array, function ($a, $b) {
            return $b['percentice'] <=> $a['percentice'];
        });


        return response()->json([
            'status' => 200,
            'message' => 'Site Group Primary Result Total Summary',
            'site_result_list' => $site_result_array,
            'total_student_count' => $total_student_count,
            'grade_system_list' => $grade_system_list,
            'global_grade_summary' => $global_grade_summary,
            'total_declared_count' => $total_declared_student_count,
            'total_passed_student_count' => $total_passed_student_count,
            'total_percentice_count' => $total_percentice_count,
            'total_absent_student_count' => $total_absent_student_count,
            'total_failed_student_count' => $total_failed_student_count,
            'with_grade' =>               $with_grade,
        ]);
    }


    public function getSiteGroupBaseStudentSimpleTabulationSheet(Request $request)
    {

        $data = $request->all();

        // Handle possible 'null' string values
        $data['academic_class_group_id'] = $data['academic_class_group_id'] !== 'null' ? $data['academic_class_group_id'] : '';
        $data['academic_department_id'] = $data['academic_department_id'] !== 'null' ? $data['academic_department_id'] : '';
        $data['academic_section_id'] = $data['academic_section_id'] !== 'null' ? $data['academic_section_id'] : '';

        $site_ids = [$data['site_id']];

        // Get student list
        $studentList = $this->getStudentList($request, $site_ids);
        $student_ids = $studentList->pluck('id');

        // Get dynamic table columns (not really used here effectively)
        $columns = Schema::getColumnListing('site_student_primary_result_details');
        $columns = array_diff($columns, []); // optionally remove unnecessary columns

        // Get Result Settings
        // $resultSett = SiteGroupResultPrimarySettingStore::with(['academicResultPrimaryType', 'examination'])
        //     ->where([
        //         'academic_version_id' => $request->academic_version_id,
        //         'academic_year_id' => $request->academic_year_id,
        //         'academic_shift_id' => $request->academic_shift_id,
        //         'academic_class_id' => $request->academic_class_id,
        //         'academic_result_primary_type_id' => $request->academic_result_primary_type_id
        //     ])
        //     ->when($data['academic_department_id'], fn($q) => $q->where('academic_department_id', $data['academic_department_id']))
        //     ->first();

        // $examRolls = SiteGroupStudentExamRoll::whereIn('student_history_id', $student_ids)
        //     ->where('examination_id', $resultSett->examination_id)
        //     ->pluck('roll', 'student_history_id');

        // // Load Primary Result Tabulations
        $primaryResults = SiteStudentPrimaryResultDetailForTabulation::with('academicResultPrimaryType')
            ->whereIn('student_history_id', $student_ids)
            ->where([
                'academic_result_primary_type_id' => $request->academic_result_primary_type_id,
                'status' => true
            ])
            ->orderBy('central_rank', 'ASC')
            ->select($columns)
            ->get();

        // Prepare Results
        $dependent_subject_ids = [];
        $result_array = [];

        // Preload Student Histories (avoid N+1)
        $studentHistories = GlobalStudentHistory::whereIn('id', $student_ids)
            ->get()
            ->keyBy('id');

        foreach ($primaryResults as $key => $primaryResult) {
            $studentHistory = $studentHistories[$primaryResult->student_history_id] ?? null;
            if (!$studentHistory) continue;

            //    $examRoll = $examRolls[$primaryResult->student_history_id] ?? null;

            $result_array[$key] = [
                'student_name'   => $studentHistory->full_name,
                'username'       => $studentHistory->username,
                'class_roll'     => $studentHistory->student_full_roll_number,
                'exam_roll'      => $primaryResult->examination_roll,
                'total_mark'     => $primaryResult->sum_of_obtain_raw_total_marks,
                'mark_percentage' => $primaryResult->raw_obtain_marks_percentage,
                'gpa'            => $primaryResult->gpa,
                'grade'          => $primaryResult->grade,
                'central_rank'   => $primaryResult->central_rank,
                'exam_attendance_status'   => $primaryResult->exam_attendance_status,
            ];

            $subject_array = [];
            foreach ($primaryResult->site_individual_combine_subject_result_store_ids ?? [] as $sKey => $subject) {
                $subject_array[$sKey] = [
                    'exam_dependent_academic_subject_id' => $subject->exam_dependent_academic_subject_id,
                    'subject_count'                     => $subject->exam_dependent_academic_subject_count,
                    'subject_base_pass_fail_status'     => $subject->subject_base_pass_fail_status,
                    'subject_result_count_status'       => $subject->subject_result_count_status,
                    'raw_total_marks'                   => $subject->raw_total_marks,
                    'obtain_subject_total_marks'        => $subject->obtain_subject_total_marks,
                    'subject_marks_percentage'          => $subject->subject_marks_percentage,
                    'subject_grade'                     => $subject->subject_grade,
                    'subject_point'                     => $subject->subject_point,
                    'exam_attendance_status'            => $subject->exam_attendance_status,
                    'result_generated_by'               => $subject->result_generated_by,
                ];

                $dependent_subject_ids[] = $subject->exam_dependent_academic_subject_id;
            }

            $result_array[$key]['subject_list'] = $subject_array;
        }

        // Get Unique Academic Subjects
        $academic_subject_list = AcademicSubject::whereIn(
            'id',
            collect($dependent_subject_ids)->unique()
        )->get();

        // Sheet Info Preparation
        $siteInfo  = GlobalSiteInfo::find($data['site_id']);

        $sheet_info = [
            'site_name'   => $siteInfo->site_name ?? '',
            'result_name' => optional(AcademicResultPrimaryType::find($request->academic_result_primary_type_id))->name,
            'class_name'  => optional(AcademicClass::find($request->academic_class_id))->class_name,
            'shift_name'  => optional(AcademicShift::find($request->academic_shift_id))->shift_name,
            'year_name'   => optional(AcademicYear::find($request->academic_year_id))->year_name,


        ];

        return [$academic_subject_list, $sheet_info, $result_array];
    }


    public function getSiteGroupPrimaryResultSimpleTabulation(Request $request)
    {

        $data = $request->all();

        $data['academic_class_group_id'] = $data['academic_class_group_id'] !== 'null' ? $data['academic_class_group_id'] : '';
        $data['academic_department_id'] = $data['academic_department_id'] !== 'null' ? $data['academic_department_id'] : '';
        $data['academic_section_id'] = $data['academic_section_id'] !== 'null' ? $data['academic_section_id'] : '';

        $tabulation_array = $this->getSiteGroupBaseStudentSimpleTabulationSheet($request);

        $academic_subject_list = $tabulation_array[0];
        $sheet_info = $tabulation_array[1];
        $result_array = $tabulation_array[2];

        // dd($result_array);

        //    return $result_array;

        $report_tittle = "";
        $report_tittle .= $sheet_info['result_name'];
        $report_tittle .= " ";
        $report_tittle .= "Tabulation Sheet";

        $report_tittle2 = "";
        //   $report_tittle2="";
        $report_tittle2 .= "<b>Year: </b>" . $sheet_info['year_name'];
        $report_tittle2 .= ",";
        $report_tittle2 .= " <b>Shift: </b>" . $sheet_info['shift_name'];

        // $report_tittle .= "<br>";

        if ($request->academic_department_id) {
            $department = AcademicDepartment::where('id', $request->academic_department_id)->first();

            if ($department) {
                $report_tittle2 .= "<b> Dept: </b>" . ($department ? $department->name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_class_id) {
            $class = AcademicClass::where('id', $request->academic_class_id)->first();
            $report_tittle2 .= "<b> Class: </b>" . ($class ? $class->class_name : '');
            $report_tittle2 .= ",";
        }


        if ($request->academic_class_group_id) {
            $group = AcademicClassGroup::where('id', $request->academic_class_group_id)->first();
            if ($group) {
                $report_tittle2 .= "<b> Group: </b>" . ($group ? $group->group_name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_section_id) {
            $section = AcademicSection::where('id', $request->academic_section_id)->first();
            if ($section) {
                $report_tittle2 .= "<b> Section: </b>" . ($section ? $section->section_name : '');
                $report_tittle2 .= ",";
            }
        }
        if ($request->academic_session_id) {
            $session = AcademicSession::where('id', $request->academic_session_id)->first();
            if ($session) {
                $report_tittle2 .= "<b> Session: </b>" . ($session ? $session->session_name : '');
            }
        }

        $siteGroup = GlobalSiteGroup::find(Session::get('SITE_GROUP_ID'));
        ini_set('memory_limit', '2048M');
        $pdf = PDF::loadView(
            'default.admin.site_group.result.result_report.site-group-base-multiple-student-simple-tabulation-report',
            compact('academic_subject_list', 'sheet_info', 'result_array', 'report_tittle', 'report_tittle2', 'siteGroup')
        )
            ->setPaper('a4', 'landscape')->setWarnings(false);

        $random = rand(0, 100000);
        $time = $random . '-' . Carbon::now()->unix();
        $name = $time . '.pdf';

        return $pdf->stream($name);
    }

    private function getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present, $result_list)
    {
        $class_arr = array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_base_student_result = $result_list
                ->whereIn('student_history_id', $filtered_class_list->pluck('id'));

            $class_base_pass_student_count = $class_base_student_result
                ->where('fail_subject_count', 0)
                ->where('exam_attendance_status', true)
                ->count();
            $class_base_fail_student_count = $class_base_student_result
                ->where('fail_subject_count', '>', 0)
                ->where('exam_attendance_status', true)
                ->count();

            $class_base_attend_student_count = $class_base_student_result
                ->where('exam_attendance_status', true)
                ->count();
            $class_base_absent_student_count = $class_base_student_result
                ->where('exam_attendance_status', false)
                ->count();




            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);
            $class_arr['class_passed_student_count'] = $class_base_pass_student_count;
            $class_arr['class_failed_student_count'] = $class_base_fail_student_count;

            $class_arr['class_present_student_count'] = $class_base_attend_student_count;
            $class_arr['class_absent_student_count'] = $class_base_absent_student_count;

            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $group_base_student_result = $class_base_student_result
                        ->whereIn('student_history_id', $filtered_class_group_list->pluck('id'));

                    $group_base_pass_student_count = $group_base_student_result
                        ->where('fail_subject_count', 0)
                        ->where('exam_attendance_status', true)
                        ->count();
                    $group_base_fail_student_count = $group_base_student_result
                        ->where('fail_subject_count', '>', 0)
                        ->where('exam_attendance_status', true)
                        ->count();


                    $group_base_attend_student_count = $group_base_student_result
                        ->where('exam_attendance_status', true)
                        ->count();
                    $group_base_absent_student_count = $group_base_student_result
                        ->where('exam_attendance_status', false)
                        ->count();



                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);
                    $class_group_arr['class_group_passed_student_count'] = $group_base_pass_student_count;
                    $class_group_arr['class_group_failed_student_count'] = $group_base_fail_student_count;

                    $class_group_arr['class_group_present_student_count'] = $group_base_attend_student_count;
                    $class_group_arr['class_group_absent_student_count'] = $group_base_absent_student_count;


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_base_student_result = $group_base_student_result
                            ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                        $section_base_pass_student_count = $section_base_student_result
                            ->where('fail_subject_count', 0)
                            ->where('exam_attendance_status', true)
                            ->count();
                        $section_base_fail_student_count = $section_base_student_result
                            ->where('fail_subject_count', '>', 0)
                            ->where('exam_attendance_status', true)
                            ->count();

                        $section_base_attend_student_count = $section_base_student_result
                            ->where('exam_attendance_status', true)
                            ->count();
                        $section_base_absent_student_count = $section_base_student_result
                            ->where('exam_attendance_status', false)
                            ->count();



                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);
                        $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
                        $section_arr['class_section_failed_count'] = $section_base_fail_student_count;


                        $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                        $section_arr['class_section_absent_count'] = $section_base_absent_student_count;


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;
                }
            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);



                    $section_base_student_result = $class_base_student_result
                        ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                    $section_base_pass_student_count = $section_base_student_result
                        ->where('fail_subject_count', 0)
                        ->where('exam_attendance_status', true)
                        ->count();
                    $section_base_fail_student_count = $section_base_student_result
                        ->where('fail_subject_count', '>', 0)
                        ->where('exam_attendance_status', true)
                        ->count();


                    $section_base_attend_student_count = $section_base_student_result
                        ->where('exam_attendance_status', true)
                        ->count();
                    $section_base_absent_student_count = $section_base_student_result
                        ->where('exam_attendance_status', false)
                        ->count();




                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);
                    $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
                    $section_arr['class_section_failed_count'] = $section_base_fail_student_count;

                    $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                    $section_arr['class_section_absent_count'] = $section_base_absent_student_count;

                    $section_array[$keySection] = $section_arr;
                }

                //                            $class_group_arr['section_array']=$section_array;
                //                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

                //                if($class_group_present){
                //                    $class_arr['count_class_row']=count($section_array)*2;
                //                }else{
                $class_arr['count_class_row'] = count($section_array);
                //                }


            }


            $class_array[$keyClass] = $class_arr;
        }

        return $class_array;
    }


    public function getSiteGroupPrimaryResultTotalStatistics(Request $request)
    {

        $data = $request->all();

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }


        $getStudentList = $this->getStudentList($request, $site_ids);

         $resultSettingList = SiteGroupResultPrimarySettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->first();


        $student_history_ids = SiteGroupStudentExamRoll::with('studentHistory')
            ->whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('examination_id', $resultSettingList->examination_id)
            ->pluck('student_history_id');

        $getStudentList = $getStudentList->whereIn('id', $student_history_ids);


        $primary_result_all_student_list = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade')
            ->whereIn('site_id', $site_ids)
            ->get();

        $totalStudent = count($getStudentList);

        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();

        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();

        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }


        $version_arr = array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $verstion_base_student_result = $primary_result_all_student_list
                ->whereIn('student_history_id', $filtered_version_list->pluck('id'));

            $version_base_attend_student_count = $verstion_base_student_result
                ->where('exam_attendance_status', true)
                ->count();
            $version_base_absent_student_count = $verstion_base_student_result
                ->where('exam_attendance_status', false)
                ->count();

            $version_base_pass_student_count = $verstion_base_student_result
                ->where('fail_subject_count', 0)
                ->where('exam_attendance_status', true)
                ->count();
            $version_base_fail_student_count = $verstion_base_student_result
                ->where('fail_subject_count', '>', 0)
                ->where('exam_attendance_status', true)
                ->count();

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);
            $version_arr['version_passed_student_count'] = $version_base_pass_student_count;
            $version_arr['version_failed_student_count'] = $version_base_fail_student_count;
            $version_arr['version_present_student_count'] = $version_base_attend_student_count;
            $version_arr['version_absent_student_count'] = $version_base_absent_student_count;


            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();


            $shift_arr = array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {


                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);


                $shift_base_student_result = $verstion_base_student_result
                    ->whereIn('student_history_id', $filtered_shift_list->pluck('id'));


                $shift_base_attend_student_count = $shift_base_student_result
                    ->where('exam_attendance_status', true)
                    ->count();
                $shift_base_absent_student_count = $shift_base_student_result
                    ->where('exam_attendance_status', false)
                    ->count();

                $shift_base_pass_student_count = $shift_base_student_result
                    ->where('fail_subject_count', 0)
                    ->where('exam_attendance_status', true)
                    ->count();
                $shift_base_fail_student_count = $shift_base_student_result
                    ->where('fail_subject_count', '>', 0)
                    ->where('exam_attendance_status', true)
                    ->count();

                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);
                $shift_arr['shift_passed_student_count'] = $shift_base_pass_student_count;
                $shift_arr['shift_failed_student_count'] = $shift_base_fail_student_count;

                $shift_arr['shift_present_student_count'] = $shift_base_attend_student_count;
                $shift_arr['shift_absent_student_count'] = $shift_base_absent_student_count;


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();


                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);


                        $department_base_student_result = $shift_base_student_result
                            ->whereIn('student_history_id', $filtered_department_list->pluck('id'));

                        $department_base_pass_student_count = $department_base_student_result
                            ->where('fail_subject_count', 0)
                            ->where('exam_attendance_status', true)
                            ->count();
                        $department_base_fail_student_count = $department_base_student_result
                            ->where('fail_subject_count', '>', 0)
                            ->where('exam_attendance_status', true)
                            ->count();


                        $department_base_attend_student_count = $department_base_student_result
                            ->where('exam_attendance_status', true)
                            ->count();
                        $department_base_absent_student_count = $department_base_student_result
                            ->where('exam_attendance_status', false)
                            ->count();

                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);
                        $department_arr['department_passed_student_count'] = $department_base_pass_student_count;
                        $department_arr['department_failed_student_count'] = $department_base_fail_student_count;

                        $department_arr['department_attend_student_count'] = $department_base_attend_student_count;
                        $department_arr['department_absent_student_count'] = $department_base_absent_student_count;


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCount(
                            $classList,
                            $filtered_department_list,
                            $class_group_present,
                            $department_base_student_result
                        );

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;
                    }
                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();

                    $class_array = $this->getClassGroupSectionCount(
                        $classList,
                        $filtered_shift_list,
                        $class_group_present,
                        $shift_base_student_result
                    );
                }


                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);
                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }

                $shift_array[$keyShift] = $shift_arr;
            }

            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;
        }

        $student_grade_list = $primary_result_all_student_list->where('exam_attendance_status', true);

        $site_result_system_setting = SiteGroupResultSystemSettingStore::where('academic_year_id', $data['academic_year_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();

        $academic_result_system_list = AcademicResultSystem::whereIn('id', $site_result_system_setting->pluck('academic_result_system_id')->unique())
            ->get();


        $result_arr = array();
        $result_array = [];
        foreach ($academic_result_system_list as $key => $value) {

            $student_history_number_list = $student_grade_list
                ->where('grade', $value->name)
                ->pluck('student_history_id')
                ->unique();

            $student_list_grade = $getStudentList->whereIn('id', $student_history_number_list)->pluck('id');

            $check_grade_list = $student_grade_list->where('grade', $value->name)->count();

            $check_grade_setting = $site_result_system_setting->where('academic_result_system_id', $value->id)->first();

            $result_arr['id'] = $value->id;
            $result_arr['grade'] = $value->name;
            $result_arr['student_count'] = $check_grade_list;
            $result_arr['point'] = $check_grade_setting->point;
            $result_arr['number_from'] = $check_grade_setting->number_from;
            $result_arr['number_to'] = $check_grade_setting->number_to;
            $result_arr['grade_student_ids'] = $student_list_grade->values();

            $result_array[$key] = $result_arr;
        }


        $student_grade_count = collect($result_array)->values();



        //===============All Passed Student

        $passed_student_roll_list = $student_grade_list->where('fail_subject_count', '=', 0)
            ->pluck('student_history_id')
            ->unique();

        $passed_student_count = count($passed_student_roll_list);

        // $assending_passed_roll_number= $getStudentList->whereIn('id', $passed_student_roll_list);
        $assending_passed_roll_number = SiteGroupStudentExamRoll::whereIn('student_history_id', $passed_student_roll_list)
            ->where('examination_id', $resultSettingList->examination_id)
            ->orderBy('roll')
            ->get();
        //  dd($assending_passed_roll_number);

        $passed_student_rolls = $assending_passed_roll_number->values();

        //==============All Failed Student
        $failed_student_roll_list = $student_grade_list->where('fail_subject_count', '>', 0)
            ->pluck('student_history_id')
            ->unique();

        //   dd($failed_student_roll_list);

        $failed_student_count = count($failed_student_roll_list);
        //   $assending_failed_roll_number=$getStudentList->whereIn('id', $failed_student_roll_list);
        $assending_failed_roll_number = SiteGroupStudentExamRoll::whereIn('student_history_id', $failed_student_roll_list)
            ->where('examination_id', $resultSettingList->examination_id)
            ->orderBy('roll')
            ->get();
        //    dd($assending_failed_roll_number);
        $failed_student_rolls = $assending_failed_roll_number->values();




        //===========All Absent Student
        $absent_student_list = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('exam_attendance_status', false)
            ->select('id', 'student_history_id')
            ->get();


        $absent_student_roll_list = $absent_student_list
            ->pluck('student_history_id')
            ->unique();

        $absent_student_count = count($absent_student_roll_list);

        // $assending_absent_roll_number=$getStudentList->whereIn('id', $absent_student_roll_list);
        $assending_absent_roll_number = SiteGroupStudentExamRoll::whereIn('student_history_id', $absent_student_roll_list)
            ->where('examination_id', $resultSettingList->examination_id)
            ->orderBy('roll')
            ->get();
        //   dd(Session::get('ACADEMIC_GROUP_ID'), Session::get('SITE_GROUP_ID'));

        $absent_student_rolls = $assending_absent_roll_number->values();

        return response()->json(
            [
                'student_count_array' => $student_count_array,
                'department_present'  => $department_present,
                'class_group_present' => $class_group_present,
                'section_present'     => $section_present,
                'totalStudent'        => $totalStudent,
                'student_grade_count' => $student_grade_count,
                'passed_student_rolls' => $passed_student_rolls,
                'failed_student_rolls' => $failed_student_rolls,
                'absent_student_rolls' => $absent_student_rolls,
                'passed_student_count' => $passed_student_count,
                'failed_student_count' => $failed_student_count,
                'absent_student_count' => $absent_student_count,
            ]
        );
    }
    private function studentMeritList($request, $student_history_ids)
    {
        $marit_list_count = $request->merit_list_count ? $request->merit_list_count : 10;
        $student_merit_list = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
            ->with(['studentHistory' => function ($query) {
                $query->with('classGroup')
                    ->select('id', 'user_id', 'academic_student_category_id', 'student_roll_number', 'academic_class_group_id');
            }], 'siteInfo')
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('exam_attendance_status', 1)
            ->where('gpa', '>', '0')
            ->select(
                'id',
                'student_history_id',
                'fail_subject_count',
                'exam_attendance_status',
                'grade',
                'gpa',
                'sum_of_obtain_total_marks_for_show',
                'sum_of_obtain_total_percent_for_show',
                'student_rank',
                'central_rank',
                'gpa',
                'site_id',
                'examination_roll'
            )
            ->orderBy('central_rank', 'ASC')
            ->orderBy('gpa', 'ASC')
            ->limit($marit_list_count)
            ->get();

        $merit_list_array = [];
        $key = 0;
        foreach ($student_merit_list as $item) {

            $merit_list_array[$key]['student_name'] = $item->studentHistory->full_name;
            $merit_list_array[$key]['username'] = $item->studentHistory->username;
            $merit_list_array[$key]['class_group'] = $item->studentHistory->classGroup ? $item->studentHistory->classGroup->group_name : '';
            $merit_list_array[$key]['class_roll'] = $item->studentHistory ? $item->studentHistory->student_roll_number : '';
            $merit_list_array[$key]['central_roll'] = $item->examination_roll ?? '';
            $merit_list_array[$key]['site_name'] = $item->siteInfo ? $item->siteInfo->site_name : '';
            $merit_list_array[$key]['central_rank'] = $item->central_rank;
            $merit_list_array[$key]['site_rank'] = $item->student_rank;
            $merit_list_array[$key]['total_mark'] = $item->sum_of_obtain_total_marks_for_show;
            $merit_list_array[$key]['mark_percentage'] = $item->sum_of_obtain_total_percent_for_show;
            $merit_list_array[$key]['grade'] = $item->grade;
            $merit_list_array[$key]['gpa'] = $item->gpa;
            $merit_list_array[$key]['academic_student_category_id'] = $item->studentHistory->academic_student_category_id;

            $key++;
        }

        return $merit_list_array;
    }


    public function getSiteGroupPrimaryResultMeritList(Request $request)
    {

        $data = $request->all();

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }

        $getStudentList = $this->getStudentList($request, $site_ids);

        $student_history_ids = $getStudentList->pluck('id');
        $merit_list = $this->studentMeritList($request, $student_history_ids);

        return response()->json(
            [
                'merit_list' => $merit_list,
                'total_student' => count($getStudentList),
            ]
        );
    }


    public function getSiteGroupPrimaryResultMeritListStatisticsPdfDownload(Request $request)
    {

        $getSiteGroupPrimaryResultMeritListStatistics = $this->getSiteGroupPrimaryResultMeritListStatistics($request);

        // dd($getSiteGroupPrimaryResultMeritListStatistics);

        $SiteGroupInfo =   GlobalSiteGroup::where('id', session()->get('SITE_GROUP_ID'))->first();
        $resultType =   AcademicResultPrimaryType::where('id', $request->academic_result_primary_type_id)->first();
        $pdf = PDF::loadView(
            'default.admin.site_group.result.result_report.site-group-base-merit-list-report',
            compact('getSiteGroupPrimaryResultMeritListStatistics', 'SiteGroupInfo', 'resultType')
        )
            ->setPaper('a4', 'protrait')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
        $route_name = route('open-pdf-file-storage-for-group', [$name]);

        return response()->json([
            'link' => $route_name,
        ], 200);
    }
    public function getSiteGroupPrimaryResultReviewSummaryPdf(Request $request)
    {
        // return $request ;


        $jsonResponse = $this->getSiteGroupPrimaryResultReviewListStatistics($request);

        $SiteGroupPrimaryResultTotalSummary = json_decode($jsonResponse->getContent(), true);


        $siteGroup = GlobalSiteGroup::find(Session::get('SITE_GROUP_ID'));

        $sheet_info = [
            'site_name' => $siteGroup->name,
            'result_name' => optional(AcademicResultPrimaryType::find($request->academic_result_primary_type_id))->name,
            'class_name'  => optional(AcademicClass::find($request->academic_class_id))->class_name,
            'shift_name'  => optional(AcademicShift::find($request->academic_shift_id))->shift_name,
            'year_name'   => optional(AcademicYear::find($request->academic_year_id))->year_name,
        ];

        // dd($result_array);

        //    return $result_array;

        $report_tittle = "";

        $report_tittle .= "Summary of the " . $sheet_info['result_name'] . " " . $sheet_info['year_name'];

        $report_tittle2 = "";
        //   $report_tittle2="";
        $report_tittle2 .= "<b>Year: </b>" . $sheet_info['year_name'];
        $report_tittle2 .= ",";
        $report_tittle2 .= " <b>Shift: </b>" . $sheet_info['shift_name'];

        // $report_tittle .= "<br>";

        if ($request->academic_department_id) {
            $department = AcademicDepartment::where('id', $request->academic_department_id)->first();

            if ($department) {
                $report_tittle2 .= "<b> Dept: </b>" . ($department ? $department->name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_class_id) {
            $class = AcademicClass::where('id', $request->academic_class_id)->first();
            $report_tittle2 .= "<b> Class: </b>" . ($class ? $class->class_name : '');
            $report_tittle2 .= ",";
        }


        if ($request->academic_class_group_id) {
            $group = AcademicClassGroup::where('id', $request->academic_class_group_id)->first();
            if ($group) {
                $report_tittle2 .= "<b> Group: </b>" . ($group ? $group->group_name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_section_id) {
            $section = AcademicSection::where('id', $request->academic_section_id)->first();
            if ($section) {
                $report_tittle2 .= "<b> Section: </b>" . ($section ? $section->section_name : '');
                $report_tittle2 .= ",";
            }
        }
        if ($request->academic_session_id) {
            $session = AcademicSession::where('id', $request->academic_session_id)->first();
            if ($session) {
                $report_tittle2 .= "<b> Session: </b>" . ($session ? $session->session_name : '');
            }
        }

        //  dd($SiteGroupPrimaryResultTotalSummary['total_declared_count']);



        ini_set('memory_limit', '2048M');

        // PDF::setOptions([
        //     'defaultFont' => 'SolaimanLipi'
        // ]);

        // $pdf = PDF::loadView(
        //     'default.admin.site_group.result.result_report.site-group-base-summry-result-review-report',
        //     [
        //         'site_result_list' => $SiteGroupPrimaryResultTotalSummary['result'],


        //         'sheet_info' => $sheet_info,
        //         'report_tittle' => $report_tittle,
        //         'report_tittle2' => $report_tittle2,
        //         'siteGroup' => $siteGroup
        //     ]
        // )->setPaper('a4', 'portrait')->setWarnings(false);

        // $random = rand(0, 100000);
        // $time = $random . '-' . Carbon::now()->unix();
        // $name = $time . '.pdf';

        // return $pdf->stream($name);



        $view = View::make('default.admin.site_group.result.result_report.site-group-base-summry-result-review-report')
            ->with('site_result_list', $SiteGroupPrimaryResultTotalSummary['result'])
            ->with('sheet_info', $sheet_info)
            ->with('report_tittle', $report_tittle)
            ->with('report_tittle2', $report_tittle2)
            ->with('siteGroup', $siteGroup);

        $html = $view->render();

        $mpdf = new \Mpdf\Mpdf([
            'margin_top' => 20,
            'margin_right' => 15,
            'margin_bottom' => 20,
            'margin_left' => 15,
        ]);

        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;

        $mpdf->WriteHTML($html);

        $mpdf->Output('summary-result-report.pdf', 'I');
    }
    public function getSiteGroupPrimaryResultReviewListStatistics(Request $request)
    {
        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }
        if (count($site_ids) == 0) {
            $site_ids = $this->siteIds();
        }
        if ($request->site_id == 'null') {
            $site_ids = $this->siteIds();
        }

        // dd($request->grade);
        if ($request->grade == 'null') {
            $request->grade = null;
        }

        $getStudentList = $this->getStudentList($request, $site_ids);
        $studentHistoryIds = $getStudentList->pluck('id');

        $resultDetailsList = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $studentHistoryIds)
            ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade', 'gpa', 'sum_of_obtain_total_marks_for_show', 'comment', 'central_rank', 'student_rank', 'site_id', 'examination_roll')
            ->with(['studentHistory' => function ($query) {
                $query->select('id', 'user_id', 'academic_student_category_id', 'student_roll_number', 'academic_class_group_id');
            }])
            ->when(!empty($request->grade), function ($query) use ($request) {
                return $query->where('grade', $request->grade);
            })
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('exam_attendance_status', 1)
            ->orderBy('examination_roll')
            ->get();



        $result = [];

        foreach ($site_ids as $site_key => $site_id) {

            $SiteResultDetailsList = $resultDetailsList->where('site_id', $site_id);
            $site_info = GlobalSiteInfo::find($site_id);
            $result[$site_key] = [
                'site_id'        => $site_id,
                'site_name'      => $site_info->site_name ?? '',
                'total_student'  => $SiteResultDetailsList->count(),
                'result_details' => $SiteResultDetailsList->map(function ($item) {
                    return [
                        'id' => $item->id,
                        'student_history_id' => $item->student_history_id,
                        'student_name'       => $item->studentHistory ? $item->studentHistory->full_name : '',
                        'username'           => $item->studentHistory ? $item->studentHistory->username : '',
                        'roll_number'        => $item->studentHistory ? $item->studentHistory->student_roll_number : '',
                        'central_roll' => $item->examination_roll,
                        'grade'        => $item->grade,
                        'gpa'          => $item->gpa,
                        'comment'      => $item->comment,
                        'central_rank' => $item->central_rank,
                        'site_rank'    => $item->student_rank,
                    ];
                })->values()->all(),

                'total_comment' => $SiteResultDetailsList
                    ->filter(fn($item) => !empty($item->comment))
                    ->count(),
            ];
        }

        return response()->json([
            'result' => $result,

        ]);
    }
    public function getGradeSetting(Request $request)
    {
        $grade_system_list  = SiteGroupResultSystemSettingStore::with('academicResultSystem')
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_version_id)
            ->orderBy('point', 'desc')
            ->get()
            ->map(function ($item) {
                return [
                    'id' => $item->academicResultSystem->id,
                    'name' => $item->academicResultSystem->name,

                ];
            });

        return response()->json($grade_system_list, 200);
    }
    public function getSiteGroupPrimaryResultMeritListStatistics(Request $request)
    {
        // if (!$this->checkSiteGroupResultPermission($request)) {
        //     return Response::json(['message' => 'You have no permission!'], 401);
        // }
        $data = $request->all();

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }

        $getStudentList = $this->getStudentList($request, $site_ids);

        $primary_result_all_student_list = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade')
            ->get();

        // dd(count($primary_result_all_student_list));

        $totalPerticepentStudent = count($primary_result_all_student_list);
        $totalStudent = count($getStudentList);

        /////////////////////

        /// passed student
        $student_grade_list = $primary_result_all_student_list->where('exam_attendance_status', true);

        $passed_student_roll_list = $student_grade_list->where('fail_subject_count', '=', 0)
            ->pluck('student_history_id')
            ->unique();
        $passed_student_count = count($passed_student_roll_list);

        /// fail student

        $failed_student_roll_list = $student_grade_list->where('fail_subject_count', '>', 0)
            ->pluck('student_history_id')
            ->unique();

        // absent student

        //===========All Absent Student
        $absent_student_list = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('exam_attendance_status', false)
            ->select('id', 'student_history_id')
            ->get();


        $absent_student_roll_list = $absent_student_list
            ->pluck('student_history_id')
            ->unique();

        $absent_student_count = count($absent_student_roll_list);

        // check section
        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();

        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }

        $failed_student_count = count($failed_student_roll_list);

        $classList = AcademicClass::where('id', $request->academic_class_id)->get();

        $class_group_ids = $getStudentList->pluck('academic_class_group_id')
            ->unique()
            ->filter();

        //  dd($class_group_ids);


        if (count($class_group_ids) > 0) {

            $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


            $class_group_arr = array();
            $class_group_array = [];
            foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                $filtered_class_group_list = $getStudentList
                    ->where('academic_class_group_id', $valueClassGroup->id);


                $group_base_student_result = $primary_result_all_student_list
                    ->whereIn('student_history_id', $filtered_class_group_list->pluck('id'));

                $group_base_pass_student_count = $group_base_student_result
                    ->where('fail_subject_count', 0)
                    ->where('exam_attendance_status', true)
                    ->count();
                $group_base_fail_student_count = $group_base_student_result
                    ->where('fail_subject_count', '>', 0)
                    ->where('exam_attendance_status', true)
                    ->count();


                $group_base_attend_student_count = $group_base_student_result
                    ->where('exam_attendance_status', true)
                    ->count();
                $group_base_absent_student_count = $group_base_student_result
                    ->where('exam_attendance_status', false)
                    ->count();

                $group_passed_percentage = ($group_base_pass_student_count * 100) / count($filtered_class_group_list);

                $class_group_arr['group_name'] = $valueClassGroup->group_name;
                $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);
                $class_group_arr['class_group_perticepent_student_count'] = count($group_base_student_result);
                $class_group_arr['class_group_passed_student_count'] = $group_base_pass_student_count;
                $class_group_arr['class_group_failed_student_count'] = $group_base_fail_student_count;

                $class_group_arr['class_group_present_student_count'] = $group_base_attend_student_count;
                $class_group_arr['class_group_absent_student_count'] = $group_base_absent_student_count;
                $class_group_arr['group_passed_percentage'] = number_format((float)$group_passed_percentage, 2, '.', '');


                $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $class_group_arr['count_class_group_row'] = count($sectionList);


                $section_arr = array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_group_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_base_student_result = $group_base_student_result
                        ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                    $section_base_pass_student_count = $section_base_student_result
                        ->where('fail_subject_count', 0)
                        ->where('exam_attendance_status', true)
                        ->count();
                    $section_base_fail_student_count = $section_base_student_result
                        ->where('fail_subject_count', '>', 0)
                        ->where('exam_attendance_status', true)
                        ->count();

                    $section_base_attend_student_count = $section_base_student_result
                        ->where('exam_attendance_status', true)
                        ->count();
                    $section_base_absent_student_count = $section_base_student_result
                        ->where('exam_attendance_status', false)
                        ->count();

                    $section_passed_percentage = ($section_base_pass_student_count * 100) / count($filtered_section_list);

                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);
                    $section_arr['class_section_perticepent_student_count'] = count($section_base_student_result);
                    $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
                    $section_arr['class_section_failed_count'] = $section_base_fail_student_count;


                    $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                    $section_arr['class_section_absent_count'] = $section_base_absent_student_count;
                    $section_arr['section_passed_percentage'] = $section_passed_percentage;


                    $section_array[$keySection] = $section_arr;
                }

                $class_group_arr['section_array'] = $section_array;

                $class_group_array[$keyClassGroup] = $class_group_arr;
            }
        } else {

            $section_ids = $getStudentList->pluck('academic_section_id')
                ->unique()
                ->filter();

            $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

            $section_arr = array();
            $section_array = [];
            foreach ($sectionList as $keySection => $valueSection) {

                $filtered_section_list = $getStudentList
                    ->where('academic_section_id', $valueSection->id);

                $section_base_student_result = $primary_result_all_student_list
                    ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                $section_base_pass_student_count = $section_base_student_result
                    ->where('fail_subject_count', 0)
                    ->where('exam_attendance_status', true)
                    ->count();
                $section_base_fail_student_count = $section_base_student_result
                    ->where('fail_subject_count', '>', 0)
                    ->where('exam_attendance_status', true)
                    ->count();


                $section_base_attend_student_count = $section_base_student_result
                    ->where('exam_attendance_status', true)
                    ->count();
                $section_base_absent_student_count = $section_base_student_result
                    ->where('exam_attendance_status', false)
                    ->count();




                $section_arr['section_name'] = $valueSection->section_name;
                $section_arr['class_section_count'] = count($filtered_section_list);
                $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
                $section_arr['class_section_failed_count'] = $section_base_fail_student_count;

                $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                $section_arr['class_section_absent_count'] = $section_base_absent_student_count;

                $section_array[$keySection] = $section_arr;
            }
        }
        // student merit list
        $student_history_ids = $getStudentList->pluck('id');
        $merit_list = $this->studentMeritList($request, $student_history_ids);

        if ($totalStudent) {
            $class_passed_percentage = ($passed_student_count * 100) / $totalStudent;
        } else {
            $class_passed_percentage = 0;
        }



        $student_array = [];

        $student_array['total_student'] = $totalStudent;
        $student_array['total_perticepent_student'] = $totalPerticepentStudent;
        $student_array['passed_student_count'] = $passed_student_count;
        $student_array['failed_student_count'] = $failed_student_count;
        $student_array['absent_student_count'] = $absent_student_count;
        $student_array['department_present'] = $department_present;
        $student_array['class_group_present'] = $class_group_present;
        $student_array['section_present'] = $section_present;

        $student_array['class_passed_percentage'] = number_format((float)$class_passed_percentage, 2, '.', '');
        $student_array['group_section_array'] = [];
        $student_array['merit_list'] = $merit_list;

        // dd($class_group_array);

        return $student_array;  // this function use in another function
    }
    public function getSiteGroupPrimaryResultPassFailStudentSummaryPdf(Request $request)
    {

        $jsonResponse = $this->getSiteGroupPrimaryResultSubjectPassFailStatistics($request);

        if ($request->site_id != 'null') {
            $site_name =  GlobalSiteInfo::find($request->site_id)->site_name;
        } else {
            $site_name = null;
        }

        $ResultSubjectPassFailStatistics = json_decode($jsonResponse->getContent(), true);

        $siteGroup = GlobalSiteGroup::find(Session::get('SITE_GROUP_ID'));

        $sheet_info = [
            'site_name' => $siteGroup->name,
            'result_name' => optional(AcademicResultPrimaryType::find($request->academic_result_primary_type_id))->name,
            'class_name'  => optional(AcademicClass::find($request->academic_class_id))->class_name,
            'shift_name'  => optional(AcademicShift::find($request->academic_shift_id))->shift_name,
            'year_name'   => optional(AcademicYear::find($request->academic_year_id))->year_name,
        ];

        // dd($result_array);

        //    return $result_array;

        $report_tittle = "";

        $report_tittle .= "Summary of the " . $sheet_info['result_name'] . " " . $sheet_info['year_name'];

        $report_tittle2 = "";
        //   $report_tittle2="";
        $report_tittle2 .= "<b>Year: </b>" . $sheet_info['year_name'];
        $report_tittle2 .= ",";
        $report_tittle2 .= " <b>Shift: </b>" . $sheet_info['shift_name'];

        // $report_tittle .= "<br>";

        if ($request->academic_department_id) {
            $department = AcademicDepartment::where('id', $request->academic_department_id)->first();

            if ($department) {
                $report_tittle2 .= "<b> Dept: </b>" . ($department ? $department->name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_class_id) {
            $class = AcademicClass::where('id', $request->academic_class_id)->first();
            $report_tittle2 .= "<b> Class: </b>" . ($class ? $class->class_name : '');
            $report_tittle2 .= ",";
        }


        if ($request->academic_class_group_id) {
            $group = AcademicClassGroup::where('id', $request->academic_class_group_id)->first();
            if ($group) {
                $report_tittle2 .= "<b> Group: </b>" . ($group ? $group->group_name : '');
                $report_tittle2 .= ",";
            }
        }

        if ($request->academic_section_id) {
            $section = AcademicSection::where('id', $request->academic_section_id)->first();
            if ($section) {
                $report_tittle2 .= "<b> Section: </b>" . ($section ? $section->section_name : '');
                $report_tittle2 .= ",";
            }
        }
        if ($request->academic_session_id) {
            $session = AcademicSession::where('id', $request->academic_session_id)->first();
            if ($session) {
                $report_tittle2 .= "<b> Session: </b>" . ($session ? $session->session_name : '');
            }
        }

        //  dd($SiteGroupPrimaryResultTotalSummary['total_declared_count']);



        ini_set('memory_limit', '2048M');
        $pdf = PDF::loadView(
            'default.admin.site_group.result.result_report.site-group-base-summry-result-pass-fail-student-summery-report',
            [
                'global_result_statistics' => $ResultSubjectPassFailStatistics['global_result_statistics'],
                'group_base_result_array' => $ResultSubjectPassFailStatistics['group_base_result_array'],

                'sheet_info' => $sheet_info,
                'report_tittle' => $report_tittle,
                'report_tittle2' => $report_tittle2,
                'site_name' => $site_name,
                'siteGroup' => $siteGroup
            ]
        )->setPaper('a4', 'portrait')->setWarnings(false);

        $random = rand(0, 100000);
        $time = $random . '-' . Carbon::now()->unix();
        $name = $time . '.pdf';

        return $pdf->stream($name);
    }
    public function getSiteGroupPrimaryResultSubjectPassFailStatistics(Request $request)
    {

        $data = $request->all();

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }
        if (count($site_ids) == 0) {
            $site_ids = $this->siteIds();
        }
        if ($request->site_id == 'null') {
            $site_ids = $this->siteIds();
        }



        $getStudentList = $this->getStudentList($request, $site_ids);

        $resultSettingList = SiteGroupResultPrimarySettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->first();


        $student_history_ids = SiteGroupStudentExamRoll::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('examination_id', $resultSettingList->examination_id)
            ->pluck('student_history_id');

        $getStudentList = $getStudentList->whereIn('id', $student_history_ids);

        $academic_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();

        $individual_result_list = GlobalSiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $student_history_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            //    ->where('optional_academic_subject_status', false)
            ->select(
                'id',
                'student_history_id',
                'academic_result_primary_type_id',
                'exam_dependent_academic_subject_id',
                'subject_base_pass_fail_status',
                'exam_attendance_status'
            )
            ->get();

        $all_subject_list_count = GlobalSiteStudentPrimaryResultDetail::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'fail_subject_count', 'exam_attendance_status', 'examination_roll', 'grade', 'gpa')
            ->whereIn('site_id', $site_ids)
            ->whereIn('student_history_id', $student_history_ids)
            ->get();


        $global_result_statistics = [];

        $global_result_statistics['total_passed'] = 0;
        $global_result_statistics['total_failed'] = 0;
        $global_result_statistics['total_present'] = 0;
        $global_result_statistics['total_absent'] = 0;
        $global_result_statistics['total_student'] = 0;

        $group_base_result_array = [];
        $g_key = 0;

        $class_groups = AcademicClassGroup::whereIn('id', $academic_class_group_ids)->get();

        foreach ($class_groups as $class_group) {


            //  $class_group = AcademicClassGroup::find($class_group_id);

            $class_group_id = $class_group->id;

            $group_base_student_history_ids = $getStudentList
                ->where('academic_class_group_id', $class_group_id)
                ->pluck('id');

            $group_base_all_student_result = $all_subject_list_count
                ->whereIn('student_history_id', $group_base_student_history_ids);

            $individual_result_list = $individual_result_list
                ->whereIn('student_history_id', $group_base_student_history_ids);


            // $totalStudent = count($individual_result_list->pluck('student_history_id')->unique()->values());

            // $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
            // $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();

            //==========will chnage


            $class_group_base_subject_list = $individual_result_list
                ->pluck('exam_dependent_academic_subject_id')
                ->unique()
                ->values();


            $academic_subject_list = AcademicSubject::whereIn('id', $class_group_base_subject_list)->get();



            $subject_result_array = [];
            $subject_arr = array();
            foreach ($academic_subject_list as $keyGroupSub => $valueGroupSub) {


                $student_list = $individual_result_list->where('exam_dependent_academic_subject_id', $valueGroupSub->id);

                $total_student_count = count($student_list);

                $attended_student_count = $student_list->where('exam_attendance_status', true)
                    ->count();

                $absent_student_count = $student_list->where('exam_attendance_status', false)
                    ->count();

                $passed_student_count = $student_list->where('exam_attendance_status', true)
                    ->where('subject_base_pass_fail_status', true)
                    ->count();

                $failed_student_count = $student_list->where('exam_attendance_status', true)
                    ->where('subject_base_pass_fail_status', false)
                    ->count();

                $subject_arr['id'] = $valueGroupSub->id;
                $subject_arr['subject_name'] = $valueGroupSub->subject_name;
                $subject_arr['total_student_count'] = $total_student_count;
                $subject_arr['attended_student_count'] = $attended_student_count;
                $subject_arr['absent_student_count'] = $absent_student_count;
                $subject_arr['passed_student_count'] = $passed_student_count;
                $subject_arr['failed_student_count'] = $failed_student_count;


                $subject_result_array[$keyGroupSub] = $subject_arr;
            }


            // passed subject count

            $group_base_present_student_result = $group_base_all_student_result
                ->where('exam_attendance_status', true);


            $passed_student_ids = $group_base_present_student_result
                ->where('fail_subject_count', 0)
                ->pluck('student_history_id')
                ->unique()
                ->values();

            $passed_student_rolls = $group_base_all_student_result
                ->whereIn('student_history_id', $passed_student_ids)
                ->map(function ($item) {
                    return [
                        'student_history_id' => $item['student_history_id'],
                        'roll'              => $item['examination_roll'],
                        'grade'              => $item['grade'],
                        'gpa'               => $item['gpa'],
                    ];
                })
                ->unique()
                ->values();


            $subject_list_count = $group_base_present_student_result
                ->where('fail_subject_count', '>', 0)
                ->values();


            // failed subject count


            $faill_subject_count = $subject_list_count
                ->where('fail_subject_count', '>', 0);


            $failed_count = $faill_subject_count
                ->pluck('fail_subject_count')
                ->unique()
                ->filter();



            $failed_subject_arr = array();
            $failed_subject_list_array = [];
            foreach ($failed_count as $key => $value) {

                $history_id_list = $faill_subject_count
                    ->where('fail_subject_count', $value)
                    ->pluck('student_history_id')
                    ->unique();

                //// $failed_student_ids=$getStudentList->whereIn('id', $roll_number_list)->pluck('id');

                // $failed_student_ids = SiteGroupStudentExamRoll::with('studentHistory')
                //     ->whereIn('student_history_id', $history_id_list)
                //     ->get();

                $failed_student_ids = $all_subject_list_count
                    ->whereIn('student_history_id', $history_id_list)
                    ->map(function ($item) {
                        return [
                            'roll'   => $item['examination_roll'],
                        ];
                    })
                    ->unique()
                    ->values();

                $failed_subject_arr['failed_subject_count'] = $value;

                $failed_subject_arr['failed_student_ids'] = $failed_student_ids->values();


                $failed_subject_arr['failed_subject_student'] = $faill_subject_count
                    ->where('fail_subject_count', $value)
                    ->count();

                $failed_subject_list_array[$key] = $failed_subject_arr;
            }

            // $failed_subject_list=array_values(array_sort(collect($failed_subject_list_array), function ($value) {
            //     return $value['failed_subject_count'];
            // }));


            $failed_subject_list = array_values(array_sort(collect($failed_subject_list_array), function ($value) {
                return $value['failed_subject_count'];
            }));
            $absent_list =  $group_base_all_student_result->where('exam_attendance_status', false);

            $passed_count = count($passed_student_rolls);
            $present_count = count($group_base_present_student_result);
            $group_base_all_count = count($group_base_all_student_result);

            $group_base_result_array[$g_key]['class_group_id'] = $class_group_id;
            $group_base_result_array[$g_key]['class_group_name'] = $class_group->group_name;
            $group_base_result_array[$g_key]['subject_result_array'] = $subject_result_array;
            $group_base_result_array[$g_key]['failed_subject_list'] = collect($failed_subject_list)->values();
            $group_base_result_array[$g_key]['passed_student_rolls'] = $passed_student_rolls;


            $group_base_result_array[$g_key]['total_student'] = $group_base_all_count;
            $group_base_result_array[$g_key]['total_present'] = $present_count;
            $group_base_result_array[$g_key]['total_absent'] = count($absent_list);
            $group_base_result_array[$g_key]['total_passed'] = $passed_count;
            $group_base_result_array[$g_key]['total_failed'] = count($faill_subject_count);
            $group_base_result_array[$g_key]['pass_percentage'] = $present_count > 0 ? round(($passed_count / $present_count) * 100, 2) : 0;

            $g_key++;

            $global_result_statistics['total_student'] += $group_base_all_count;
            $global_result_statistics['total_present'] += $present_count;
            $global_result_statistics['total_absent'] += $absent_list->count();
            $global_result_statistics['total_passed'] += $passed_count;
            $global_result_statistics['total_failed'] += count($faill_subject_count);
            $global_result_statistics['pass_percentage'] = $global_result_statistics['total_passed'] > 0 ? round(($global_result_statistics['total_passed'] / $global_result_statistics['total_present']) * 100, 2) : 0;
        }



        // return  collect($failed_subject_list)->values();

        return response()->json(
            [
                'group_base_result_array' => $group_base_result_array,
                'global_result_statistics' => $global_result_statistics,
            ]
        );
    }

    public function getSiteGroupExamSubjectAbsentPassFailStudentList(Request $request)
    {

        $data = $request->all();

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }

        $getStudentList = $this->getStudentList($request, $site_ids);

        $resultSettingList = SiteGroupResultPrimarySettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->first();

        if ($request->list_type == 'absent') {
            $individual_result_list = GlobalSiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_dependent_academic_subject_id', $request->academic_subject_id)
                ->where('exam_attendance_status', false)
                //                ->where('subject_base_pass_fail_status', false)
                ->pluck('student_history_id')
                ->unique();

            //   $student_final_list=$getStudentList->whereIn('id', $individual_result_list);
            // $student_final_list = SiteGroupStudentExamRoll::whereIn('student_history_id', $individual_result_list)
            //     ->where('examination_id', $resultSettingList->examination_id)
            //     ->get();

        } else if ($request->list_type == 'pass') {

            $individual_result_list = GlobalSiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_dependent_academic_subject_id', $request->academic_subject_id)
                ->where('exam_attendance_status', true)
                ->where('subject_base_pass_fail_status', true)
                //    ->where('optional_academic_subject_status', false)
                ->pluck('student_history_id')
                ->unique();

            // $student_final_list=$getStudentList->whereIn('id', $individual_result_list);
            // $student_final_list = SiteGroupStudentExamRoll::whereIn('student_history_id', $individual_result_list)
            // ->where('examination_id', $resultSettingList->examination_id)
            // ->get();
        } else if ($request->list_type == 'fail') {

            $individual_result_list = GlobalSiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_dependent_academic_subject_id', $request->academic_subject_id)
                ->where('exam_attendance_status', true)
                ->where('subject_base_pass_fail_status', false)
                //  ->where('optional_academic_subject_status', false)
                ->pluck('student_history_id')
                ->unique();

            //   $student_final_list=$getStudentList->whereIn('id', $individual_result_list);
            // $student_final_list = SiteGroupStudentExamRoll::whereIn('student_history_id', $individual_result_list)
            //     ->where('examination_id', $resultSettingList->examination_id)
            //     ->get();
        }

         $student_final_list = SiteGroupStudentExamRoll::whereIn('student_history_id', $individual_result_list)
                ->where('examination_id', $resultSettingList->examination_id)
                ->get();

        return response()->json(
            [
                'student_list' => $student_final_list->values(),
            ]
        );
    }

    public function getSiteGroupFixedCountFailedStudentList(Request $request)
    {

        $data = $request->all();

        if ($request->site_id) {
            $site_ids[] = $request->site_id;
        } else {
            $site_ids = collect($request->siteList)->pluck('id');
        }

        $getStudentList = $this->getStudentList($request, $site_ids);


        $faill_subject_student_ids = GlobalSiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('fail_subject_count', $request->failed_subject_count)
            ->where('exam_attendance_status', true)
            //            ->select('fail_subject_count')->get();
            ->pluck('student_history_id')
            ->unique()
            ->filter();

        $individual_result_list = GlobalSiteIndividualCombineSubjectResultStore::with(['academicSubject'])
            ->whereIn('student_history_id', $faill_subject_student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            //    ->where('optional_academic_subject_status', false)
            ->select(
                'id',
                'student_history_id',
                'academic_result_primary_type_id',
                'exam_dependent_academic_subject_id',
                'subject_base_pass_fail_status',
                'exam_attendance_status'
            )
            ->where('subject_base_pass_fail_status', false)
            //            ->where('exam_attendance_status', true)
            ->get();

        $resultSettingList = SiteGroupResultPrimarySettingStore::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->first();

        //   $failed_student_list=$getStudentList->whereIn('id', $faill_subject_student_ids);
        $failed_student_list = SiteGroupStudentExamRoll::whereIn('student_history_id', $faill_subject_student_ids)
            ->where('examination_id', $resultSettingList->examination_id)
            ->get();


        $failed_student_subject_arr = array();
        $failed_student_subject_array = [];
        foreach ($failed_student_list as $key => $value) {

            $check_student_subject = $individual_result_list->where('student_history_id', $value->id);

            if (count($check_student_subject) > 0) {
                $failed_student_subject_arr['id'] = $value->id;
                $failed_student_subject_arr['full_name'] = $value->full_name;
                $failed_student_subject_arr['student_roll_number'] = $value->student_roll_number;


                $subject_arr = array();
                $subject_array = [];
                foreach ($check_student_subject as $keys => $values) {
                    $subject_arr['id'] = $values->academicSubject->id;
                    $subject_arr['subject_name'] = $values->academicSubject->subject_name;
                    $subject_arr['exam_attendance'] = $values->exam_attendance_status;

                    $subject_array[$keys] = $subject_arr;
                }

                $failed_student_subject_arr['subject_list'] = collect($subject_array)->values();

                $failed_student_subject_array[$key] = $failed_student_subject_arr;
            }
        }


        $failed_student_subject_list = array_values(array_sort(collect($failed_student_subject_array), function ($value) {
            return $value['student_roll_number'];
        }));

        return response()->json(
            [
                'failedStudentList' => collect($failed_student_subject_list)->values()
            ]
        );
    }
}
