<?php

namespace App\Http\Controllers\SiteGroup\Employee;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Http\Controllers\SiteGroup\SiteGroupProjectController;
use App\Models\Employee\GlobalSiteEmployeeDepartmentClassSubject;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Error;
use Exception;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class SiteGroupEmployeeSubjectCountController extends SiteGroupProjectController
{

    private $GlobalEmployee;

    public function __construct(GlobalEmployee $GlobalEmployee)
    {
        $this->middleware('auth');
        $this->middleware('sitegrouppagechecker');
        $this->GlobalEmployee = $GlobalEmployee;
    }
    public function index()
    {
        $viewType = "Site Group employee List";
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function siteGroupWiseSubject(Request $request)
    {

        $academic_class_id = $request->academic_class_id;
        $academic_year_id = $request->academic_year_id;
        $academic_department_id = $request->academic_department_id;

        if (!$academic_year_id || !$academic_class_id) {
            throw new Error('Please Select Year, Class');
        }
        $subjectIDs_array = GlobalSubjectGroupConditionSetting::where('academic_year_id', $academic_year_id)
            ->where('academic_class_id', $academic_class_id)
            ->when($academic_department_id, function ($q) use ($academic_department_id) {
                return $q->where('academic_department_id', $academic_department_id);
            })
            ->where('academic_group_id', session()->get('ACADEMIC_GROUP_ID'))
            ->whereIn('site_id', $this->siteIds())
            ->get();
        return response()->json($subjectIDs_array, 200);
    }
    public function SiteGroupWiseEmployeeSubjectListCount(Request $request)
    {
        $site_id    = $request->site_id;
        $paginate   = $request->paginate;
        $search_txt = $request->search_txt;
        $txt        = '%' . $search_txt . '%';

        $data = [];
        $data['academic_department_id']  =  $request->academic_department_id ?? null;
        $data['academic_class_id']       =  $request->academic_class_id ?? null;
        $data['academic_year_id']        =  $request->academic_year_id ?? null;
        $data['site_id']                 =    $request->site_id ?? null;
        $data['site_subject_group_condition_setting_id']                 =    $request->site_subject_group_condition_setting_id ?? null;

        if (!$data['site_subject_group_condition_setting_id'] || !$data['academic_class_id'] || !$data['academic_year_id']) {
            throw new Error('Please Select, subject Year, Class');
        }


        $groupWiseSiteEmployeeSubjects = [];
        $groupWiseSiteEmployeeSubjectsCount = [];
        $groupWiseSiteEmployeeSubjectsCount['EmployeeHasSubject'] = 0;
        $groupWiseSiteEmployeeSubjectsCount['total_Grpup_site']   = 0;
        $key  = 0;
        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();
            $getSubjectID = GlobalSubjectGroupConditionSetting::where('id', $data['site_subject_group_condition_setting_id'])
                ->where('status', true)
                ->first();

            $SiteEmpUserList = GlobalSiteEmployeeDepartmentClassSubject::where('academic_subject_id', $getSubjectID->academic_subject_id)
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('site_id', $data['site_id'])
                ->get();


            $SiteEmpUserIds = $SiteEmpUserList->pluck('user_id')->unique();

            $EmployeeHasSubject = $this->GlobalEmployee::whereIn('id', $SiteEmpUserIds)
                ->select('id', 'username', 'religion_id', 'gender_id', 'designation_id', 'contact_number')
                ->where('status', true)
                ->orderBy('employee_serial', 'ASC')
                ->get();


            $groupWiseSiteEmployeeSubjects[$key]['site_id']             = $site->id;
            $groupWiseSiteEmployeeSubjects[$key]['site_name']           = $site->site_name;
            $groupWiseSiteEmployeeSubjects[$key]['EmployeeHasSubject']  = $EmployeeHasSubject->count();
            $groupWiseSiteEmployeeSubjects[$key]['Employees']           = $EmployeeHasSubject;

            $groupWiseSiteEmployeeSubjectsCount['subject_name']       =  $getSubjectID->subject_name;
            $groupWiseSiteEmployeeSubjectsCount['EmployeeHasSubject'] += $EmployeeHasSubject->count();
            $groupWiseSiteEmployeeSubjectsCount['total_Grpup_site']++;
            
        } else {

            $GroupWiseSites = GlobalSiteInfo::select('id')
                ->whereIn('id', $this->siteIds())
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->get();

            foreach ($GroupWiseSites as  $site) {
                $getSubjectID = GlobalSubjectGroupConditionSetting::where('id', $data['site_subject_group_condition_setting_id'])
                    ->where('status', true)
                    ->first();

                $SiteEmpUserList = GlobalSiteEmployeeDepartmentClassSubject::where('academic_subject_id', $getSubjectID->academic_subject_id)
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->where('site_id', $site->id)
                    ->get();


                $SiteEmpUserIds = $SiteEmpUserList->pluck('user_id')->unique();

                $EmployeeHasSubject = $this->GlobalEmployee::whereIn('id', $SiteEmpUserIds)
                    ->select('id', 'username', 'religion_id', 'gender_id', 'designation_id', 'contact_number')
                    ->where('status', true)
                    ->orderBy('employee_serial', 'ASC')
                    ->get();


                $groupWiseSiteEmployeeSubjects[$key]['site_id']             = $site->id;
                $groupWiseSiteEmployeeSubjects[$key]['site_name']           = $site->site_name;
                $groupWiseSiteEmployeeSubjects[$key]['EmployeeHasSubject']  = $EmployeeHasSubject->count();
                $groupWiseSiteEmployeeSubjects[$key]['Employees']           = $EmployeeHasSubject;
                $key++;

                $groupWiseSiteEmployeeSubjectsCount['subject_name']       =  $getSubjectID->subject_name;
                $groupWiseSiteEmployeeSubjectsCount['EmployeeHasSubject'] += $EmployeeHasSubject->count();
                $groupWiseSiteEmployeeSubjectsCount['total_Grpup_site']++;
            }
        }
        return response()->json([
            'groupWiseSiteEmployeeSubjects'      => $groupWiseSiteEmployeeSubjects,
            'groupWiseSiteEmployeeSubjectsCount' => $groupWiseSiteEmployeeSubjectsCount,
        ], 200);
    }
    public function SingleSiteGroupWiseEmployeeSubjectList(Request $request)
    {
        $site_id    = $request->site_id;
        $paginate   = $request->paginate;
        $search_txt = $request->search_txt;
        $txt        = '%' . $search_txt . '%';

        $data = [];
        $data['academic_department_id']  =  $request->academic_department_id ?? null;
        $data['academic_class_id']       =  $request->academic_class_id ?? null;
        $data['academic_year_id']        =  $request->academic_year_id ?? null;
        $data['site_id']                 =  $request->single_site_id ?? null;
        $data['site_subject_group_condition_setting_id']                 =    $request->site_subject_group_condition_setting_id ?? null;

        if (!$data['site_subject_group_condition_setting_id'] || !$data['academic_class_id'] || !$data['academic_year_id']) {
            throw new Error('Please Select, subject Year, Class');
        }
        $groupWiseSingleSite = [];


        if ($data['site_id']) {

            $site = GlobalSiteInfo::select('id')
                ->where('id', $data['site_id'])
                ->first();
            $getSubjectID = GlobalSubjectGroupConditionSetting::where('id', $data['site_subject_group_condition_setting_id'])
                ->where('status', true)
                ->first();

            $SiteEmpUserList = GlobalSiteEmployeeDepartmentClassSubject::where('academic_subject_id', $getSubjectID->academic_subject_id)
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('site_id', $data['site_id'])
                ->get();


            $SiteEmpUserIds = $SiteEmpUserList->pluck('user_id')->unique();

            $EmployeeHasSubject = $this->GlobalEmployee::whereIn('id', $SiteEmpUserIds)
                ->select('id', 'username', 'religion_id', 'gender_id', 'designation_id', 'contact_number')
                ->where('status', true)
                ->orderBy('employee_serial', 'ASC')
                ->paginate($paginate);

            $EmployeeHasSubject->getCollection()->transform(function ($employee) {
                $employee->gender_name      = $employee->gender      ? $employee->gender->gender_name : null;
                $employee->religion_name    = $employee->religion    ? $employee->religion->name      : null;
                $employee->designation_name = $employee->designation ? $employee->designation->name   : null;
                return $employee;
            });

            $groupWiseSingleSite['site_id']       = $site->id;
            $groupWiseSingleSite['site_name']     = $site->site_name;
            $groupWiseSingleSite['subject_name']  = $getSubjectID->subject_name;
        }
        return response()->json([
            'groupWiseSiteSubjectsWiseEmployee' => $EmployeeHasSubject,
            'groupWiseSingleSite'               => $groupWiseSingleSite,
        ], 200);
    }
}
