<?php

namespace App\Http\Controllers\Site\StudentPanel\Transaction;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Edu\Transaction\EduStudentInvoice;
use App\Models\Edu\Transaction\EduTransactionDetail;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Employee\Employee;
use App\Models\Site\SiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\EduTransaction\EduStudentNagadTransactionTrait;
use PDF;
use Response;
Use Error;
use Session;


class StudentTransactionController extends Controller
{
    use EduStudentNagadTransactionTrait;


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('siteStudentchecker');

    }


    public function index()
    {
        $viewType = 'Student Transaction';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    //===========================edu student transaction=======================
    public function getStudentEduInvoiceListForTransaction(){

//        return [ \Session::get('SITE_ID'), \Session::get('ACADEMIC_GROUP_ID'), \Auth::user()->id];

        $invoice_list=EduStudentInvoice::with(['eduStudentInvoiceItem'=>function($query){
            $query->select('id', 'edu_item_detail_id', 'edu_student_invoice_id');
            $query->with(['itemDetail'=>function($querys){
                $querys->select('id', 'item_name');
            }]);
        }])
            ->where('site_id', \Session::get('SITE_ID'))
            ->where('academic_group_id', \Session::get('ACADEMIC_GROUP_ID'))
            ->where('user_id', \Auth::user()->id)
            ->orderBy('edu_student_panel_close_date', 'asc')
            ->get();


        $get_order_ids=$invoice_list->pluck('order_id')->unique();



        $transaction_list=[];
        if(count($get_order_ids)>0){



        $transaction_list=EduTransactionDetail::with(['academicOnlinePaymentMethod'])
//                ->whereIn('order_id', $get_order_ids)
            ->select('id', 'paid_amount', 'academic_online_payment_method_id', 'order_id', 'created_at')
            ->get();



        }


        return response()->json(
            [
                'invoice_list'=>$invoice_list,
                'transaction_list'=>$transaction_list,


            ]);


    }


    public function getOnlinePaymentMethodListForTransaction(){

        $payment_list=AcademicOnlinePaymentMethod::get();

        return $payment_list;

    }


    public function getPaymentBasePageForTransaction(Request $request){

        $get_invoice_amount=EduStudentInvoice::whereIn('id', $request->edu_student_invoice_ids)
            ->where('online_payment_status', false)
            ->where('manual_payment_status', false)
            ->get();

        $payable_amount=$get_invoice_amount->sum('payable_amount');

        if($payable_amount<=0){
            return Response::json(['message' => 'You can not pay Zero tk!', 'mode' => 'Error'], 412);
        }


        if($request->company_name_key=='nagad'){

            $MerchantID='683002007104225';
//            $MerchantID='9856000002490239';
            $OrderId = 'Edu'.strtotime("now").rand(1000, 10000);
            $DateTime=Carbon::now()->format('YmdHis');
            $merchant_number='01711307878';
//            $merchant_number='01827864575';

            $trans_data=[
                'merchant_id'=>$MerchantID,
                'order_id'=>$OrderId,
                'date_time'=>$DateTime,
                'amount'=>$payable_amount,

                'merchant_number'=>$merchant_number,

            ];

            $Result_Data = $this->eduStudentTransactionRequest($trans_data);


            EduStudentInvoice::whereIn('id', $request->edu_student_invoice_ids)
                ->update([
                    'order_id'=>$OrderId,
                ]);


            return $Result_Data;
        }

    }



    public function getNagadEduCallbackWebsite(){

        $return_data=$this->TransactionComplition();
        $active_data=json_decode($return_data, true);

        $get_invoice=EduStudentInvoice::where('order_id', $active_data['orderId'])->get();

        $get_student_history_ids=$get_invoice->pluck('student_history_id')->unique();

        EduStudentInvoice::where('order_id', $active_data['orderId'])
            ->update([
                'online_payment_status'=>true,
                'paid_amount'=>$active_data['amount'],
            ]);

        $method_id=AcademicOnlinePaymentMethod::where('name_key', 'nagad')->first();

        $transaction_detail = new EduTransactionDetail();

        $transaction_detail->merchant_id =$active_data['merchantId'];
        $transaction_detail->order_id =$active_data['orderId'];
        $transaction_detail->payment_ref_id =$active_data['paymentRefId'];
        $transaction_detail->paid_amount =$active_data['amount'];
        $transaction_detail->client_mobile_no =$active_data['clientMobileNo'];
        $transaction_detail->merchant_mobile_no =$active_data['merchantMobileNo'];
        $transaction_detail->order_date_time =$active_data['orderDateTime'];
        $transaction_detail->issuer_payment_date_time =$active_data['issuerPaymentDateTime'];
        $transaction_detail->issuer_payment_ref_no =$active_data['issuerPaymentRefNo'];

        $transaction_detail->academic_online_payment_method_id =$method_id->id;
        $transaction_detail->site_id =\Session::get('SITE_ID');

        $transaction_detail->save();






        $student_invoice_non_payment_list=EduStudentInvoice::whereIn('student_history_id',  $get_student_history_ids)
            ->where('online_payment_status', false)
            ->where('manual_payment_status', false)
            ->orderBy('edu_student_panel_close_date', 'asc')
            ->select('student_history_id', 'edu_student_panel_close_date')
            ->get();


        if(count($student_invoice_non_payment_list)>0){


            $student_history_ids=$student_invoice_non_payment_list->pluck('student_history_id')->unique();
            $get_user_id=GlobalStudentHistory::whereIn('id', $student_history_ids)
                ->pluck('user_id')
                ->unique();


            $get_student_invoice_payment_last_date_list=$student_invoice_non_payment_list->first();

            GlobalUser::whereIn('id', $get_user_id)
                ->update([
                    'student_edu_payment_status'=>false,
                    'edu_student_panel_close_date'=>$get_student_invoice_payment_last_date_list->edu_student_panel_close_date
                ]);

            GlobalStudentHistory::whereIn('id', $student_history_ids)
                ->update([
                    'student_edu_payment_status'=>false,
                    'edu_student_panel_close_date'=>$get_student_invoice_payment_last_date_list->edu_student_panel_close_date
                ]);
        }
        else{

            $get_user_id=GlobalStudentHistory::whereIn('id', $get_student_history_ids)
                ->pluck('user_id')
                ->unique();



            GlobalUser::whereIn('id', $get_user_id)
                ->update([
                    'student_edu_payment_status'=>true,
                    'edu_student_panel_close_date'=>null
                ]);



            GlobalStudentHistory::whereIn('id', $get_student_history_ids)
                ->update([
                    'student_edu_payment_status'=>true,
                    'edu_student_panel_close_date'=>null
                ]);
        }



        //=====Log Start

        $user_list=GlobalStudentHistory::with(['student'=>function($query){
            $query->select('id', 'username');
        }])
            ->select('id', 'user_id')
            ->whereIn('id', $get_student_history_ids)
            ->first();



        $issue = new    IssueDetail();
        $issue->issue_type = 'transaction:edu-student';

        $issue->bearer_type = 'edu';
        $issue->bearer_id = \Session::get('SITE_ID');
        $issue->username = $user_list->student->username;
        $issue->ip_address = request()->ip();
        $issue->issue_details = $return_data;

        $issue->save();

        //=====Log End


        return redirect()->route('student-transaction-master-form');

    }
//
//http://democollege.eduworld.test:81/student/transaction/get-nagad-edu-callback-website?
////merchant=683002007104225&order_id=Edu16062340674618&payment_ref_id
////=MTEyNDIyMDc0ODQ3My42ODMwMDIwMDcxMDQyMjUuRWR1MTYwNjIzNDA2NzQ2MTguMjc0ZDJhNmU1YzAxMWM3ODZiODA=
////&status=Failed&status_code=50_0026_839&message=E%20Com%20Trx%20Failed.

    public function downloadEduStudentPaymentVoucher(Request $request){


        ini_set('memory_limit', '-1');


        $page_tittle = "Money Receipt";
        $report_tittle = "<b>Money Receipt</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Money Receipt";

        $voucher_list=EduTransactionDetail::with(['academicOnlinePaymentMethod',
            'eduStudentInvoice'=>function($query){
                $query->select('id', 'order_id', 'student_history_id');
                $query->with(['eduStudentInvoiceItem'=>function($q){
                    $q->with(['itemDetail']);
                }]);
            }])
            ->where('id', $request->voucher_id)
            ->select('id', 'academic_online_payment_method_id', 'paid_amount', 'order_id', 'created_at')
            ->first();

//        return $voucher_list;

        $student_history_ids= $voucher_list->eduStudentInvoice->pluck('student_history_id')->unique();


        $student_detail= GlobalStudentHistory::with(['version','year','department','stClass', 'shift', 'section', 'accGroup', 'session'])
            ->whereIn('id', $student_history_ids)
            ->select('id', 'user_id', 'student_roll_number', 'academic_version_id', 'student_roll_number', 'academic_year_id', 'academic_department_id',
                'academic_class_id', 'site_batch_detail_id', 'academic_class_group_id','academic_shift_id',
                'academic_session_id', 'board_registration_number', 'academic_section_id',
                'board_roll_number')
            ->get();

//return $student_detail;

        $student_info=GlobalUser::where('id', \Auth::user()->id)
            ->select('id', 'username')
            ->first();


        $site_list=SiteInfo::with(['photo'])
            ->where('id', Session::get('SITE_ID'))
            ->select('id', 'site_logo')
            ->first();


//        $institute_head = Employee::where('institute_head', 1)->first();
//
//        $signature = $institute_head->signature ?? '/img/signature/signature.png';
//        $designation = $institute_head->designation->name ?? 'Institution Head';


        $pdf = PDF::loadView('default.site.student-panel.transaction.edu-student-payment-voucher-pdf',
            compact('student_detail', 'voucher_list', 'student_info', 'site_list', 'report_tittle',
                'page_tittle', 'report_tittle2', 'title_view'))
//            ->setPaper('a4', 'landscape')
            ->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);


    }

}
